/*
 * Decompiled with CFR 0.152.
 */
package jas.plot;

import jas.plot.FontMenuItem;
import jas.plot.HasPopupItems;
import jas.plot.JASPlotMouseListener;
import jas.plot.LabelTextConverter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;

public class EditableLabel
extends JComponent
implements JASPlotMouseListener,
HasPopupItems {
    private Vector listener;
    private boolean showFontMenuItem = true;
    private final LabelTextConverter converter;
    private String sourceText;
    private JLabel label;
    private JTextField textField;
    private String prefix;
    private boolean isRotated = false;

    public EditableLabel(String text, String prefix, int align) {
        this.sourceText = text;
        this.prefix = prefix;
        this.converter = new LabelTextConverter();
        this.setLayout(new BorderLayout());
        this.label = new JLabel(this.converter.convert(text), align);
        this.label.setVerticalAlignment(1);
        this.label.setForeground(this.getForeground());
        this.add((Component)this.label, "Center");
    }

    public EditableLabel(String text, String prefix) {
        this(text, prefix, 0);
    }

    public void addActionListener(ActionListener al) {
        if (this.listener == null) {
            this.listener = new Vector();
        }
        this.listener.addElement(al);
    }

    public void removeActionListener(ActionListener al) {
        this.listener.removeElement(al);
    }

    protected void fireActionPerformed() {
        if (this.listener != null) {
            ActionEvent event = new ActionEvent(this, 1001, null);
            Enumeration e = this.listener.elements();
            while (e.hasMoreElements()) {
                ((ActionListener)e.nextElement()).actionPerformed(event);
            }
        }
    }

    void edit() {
        this.textField = new JTextField(this.sourceText);
        this.textField.setFont(this.getFont());
        this.textField.setBorder(null);
        this.textField.setHorizontalAlignment(this.label.getHorizontalAlignment());
        this.textField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent a) {
                EditableLabel.this.finishTextEdit();
            }
        });
        this.textField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent fe) {
                EditableLabel.this.finishTextEdit();
            }
        });
        this.remove(this.label);
        this.add((Component)this.textField, "Center");
        this.textField.requestFocus();
        this.revalidate();
        this.textField.getCaret().setVisible(true);
    }

    public void mouseEventNotify(MouseEvent me) {
        if (me.getID() == 500 && this.textField == null && me.getClickCount() == 2) {
            this.edit();
        }
    }

    private void finishTextEdit() {
        if (this.textField != null) {
            JTextField text = this.textField;
            this.textField = null;
            this.setText(text.getText());
            this.remove(text);
            this.add((Component)this.label, "Center");
            this.fireActionPerformed();
            this.revalidate();
            this.repaint();
        }
    }

    public void addNotify() {
        super.addNotify();
        this.label.setFont(this.getFont());
    }

    public void setFont(Font f) {
        super.setFont(f);
        this.label.setFont(f);
        this.label.revalidate();
    }

    public String getText() {
        return this.label.getText();
    }

    public void setText(String text) {
        this.sourceText = text;
        this.label.setText(this.converter.convert(text));
    }

    public void modifyPopupMenu(JPopupMenu menu, Component source) {
        if (menu.getComponentCount() > 0) {
            menu.addSeparator();
        }
        JMenuItem editMenuItem = new JMenuItem("Edit " + this.prefix + " Text"){

            protected final void fireActionPerformed(ActionEvent e) {
                EditableLabel.this.edit();
            }
        };
        if (this.showFontMenuItem) {
            menu.add(new FontMenuItem(this, this.prefix));
        }
        menu.add(editMenuItem);
    }

    public boolean isShowFontMenuItem() {
        return this.showFontMenuItem;
    }

    public void setShowFontMenuItem(boolean show) {
        this.showFontMenuItem = show;
    }

    public void paint(Graphics g) {
        if (g instanceof Graphics2D && this.isRotated) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.rotate(-1.5707963267948966);
            g2d.translate(-this.getHeight(), 0);
        }
        super.paint(g);
    }

    public void setRotated(boolean isRotated) {
        this.isRotated = isRotated;
    }

    public boolean isRotated() {
        return this.isRotated;
    }
}

