package com.renderx.xepx.x4u.as;

import javax.swing.*;
import javax.swing.border.*;
import javax.swing.table.*;
import java.awt.*;
import java.awt.event.*;

class XSLParamTable extends JDialog {
	
		private DefaultTableModel model;
		private JTable table;
		private Settings settings;
		
    XSLParamTable(JDialog dialog, Settings settings) {
			super(dialog, "XSL Parameters", true);
			ButtonListener listener = new ButtonListener();
			
			
			this.settings = settings;
			java.util.Vector columns = new java.util.Vector();
			columns.add("parameter");
			columns.add("value");
			model = new DefaultTableModel(settings.xslparams, columns);
			table = new JTable(model);

			table.setColumnSelectionAllowed(false);
			table.setRowSelectionAllowed(true);
			table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
			
			table.setPreferredScrollableViewportSize(new Dimension(250,250));
			JScrollPane scrollPane = new JScrollPane(table);
			
			JPanel editButtonPanel = new JPanel();
			JPanel confirmButtonPanel = new JPanel();
			
			JButton add = new JButton("Add");
			JButton delete = new JButton("Delete");
			JButton ok = new JButton("Ok");
			JButton cancel = new JButton("Cancel");
			
			add.setActionCommand("ADD");
			delete.setActionCommand("DELETE");
			ok.setActionCommand("OK");
			cancel.setActionCommand("CANCEL");
			
			add.addActionListener(listener);
			delete.addActionListener(listener);
			ok.addActionListener(listener);
			cancel.addActionListener(listener);
			
			getRootPane().setDefaultButton(ok);
			
			editButtonPanel.setLayout(new GridLayout(1,2,10,10));
			editButtonPanel.add(add);
			editButtonPanel.add(delete);

			confirmButtonPanel.setLayout(new GridLayout(1,2,10,10));
			confirmButtonPanel.add(ok);
			confirmButtonPanel.add(cancel);
			
			Container panel = getContentPane();
			panel.setLayout(new GridBagLayout());
			GridBagConstraints c = new GridBagConstraints();
			
			c.fill = GridBagConstraints.BOTH;
			c.gridwidth = 1;
			c.gridheight = 1;
			c.weighty = 1.0;
			c.weightx = 1.0;
			c.insets = new Insets(10, 10, 10, 10);
			panel.add(scrollPane, c);
			
			c.fill = GridBagConstraints.NONE;
			c.anchor = GridBagConstraints.CENTER;
			c.gridx = 0;
			c.gridy = 1;
			c.gridwidth = 1;
			c.gridheight = 1;
			c.weighty = 0.0;
			c.weightx = 0.0;
			c.insets = new Insets(0, 10, 0, 10);
			panel.add(editButtonPanel, c);
			
			c.anchor = GridBagConstraints.EAST;
			c.gridx = 0;
			c.gridy = 2;
			c.insets = new Insets(30, 10, 10, 10);
			panel.add(confirmButtonPanel, c);
			

		setSize(300, 420);
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		Dimension frameSize = getSize();
		if (frameSize.height > screenSize.height) {
			frameSize.height = screenSize.height;
		}
		if (frameSize.width > screenSize.width) {
			frameSize.width = screenSize.width;
		}
		
		setLocation((screenSize.width - frameSize.width) / 3, (screenSize.height - frameSize.height) / 3);
		setVisible(true);

    }
    
    class ButtonListener implements ActionListener {
        
			public void actionPerformed(ActionEvent e) {
				String command = e.getActionCommand();
				
				if(command.equals("ADD") )
				{
					model.addRow(new String[]{"", ""});
				}
				else if(command.equals("DELETE"))
				{
					int row = table.getSelectedRow();
					if(row != -1) model.removeRow(row);
				}
				else if(command.equals("OK"))
				{
					settings.xslparams = model.getDataVector();
					XSLParamTable.this.dispose();
				}
				else if(command.equals("CANCEL"))
				{
					XSLParamTable.this.dispose();
				}
			}				
    }
}  
