/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.pre;

import com.renderx.graphics.SpotColorList;
import com.renderx.sax.InputSource;
import com.renderx.sax.NullSource;
import com.renderx.sax.SAXStorage;
import com.renderx.sax.Serializer;
import com.renderx.util.Hashtable;
import com.renderx.util.URLSpec;
import com.renderx.util.URLUtil;
import com.renderx.util.User;
import com.renderx.xep.cmp.FO;
import com.renderx.xep.cmp.RootHandler;
import com.renderx.xep.lib.Conf;
import com.renderx.xep.lib.ConfigurationException;
import com.renderx.xep.lib.Session;
import com.renderx.xep.pre.AttList;
import com.renderx.xep.pre.Attn;
import com.renderx.xep.pre.Attr;
import com.renderx.xep.pre.AttributeParser;
import com.renderx.xep.pre.Bidi;
import com.renderx.xep.pre.Elem;
import com.renderx.xep.pre.ElementHandler;
import com.renderx.xep.pre.Expr;
import com.renderx.xep.pre.FOHandler;
import com.renderx.xep.pre.FOPreprocessor;
import com.renderx.xep.pre.ParserException;
import com.renderx.xep.pre.WritingMode;
import com.renderx.xep.pre.XPathBuilderFilter;
import com.renderx.xep.pre.helpers.DummyElementHandler;
import com.renderx.xep.pre.helpers.ElementHandlerSerializer;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLFilterImpl;
import org.xml.sax.helpers.XMLReaderFactory;

public class Parser {
    protected final Session session;
    private static boolean initialized = false;

    public Parser() throws ConfigurationException {
        this(new Session());
    }

    public Parser(Session session) throws ConfigurationException {
        this.session = session;
        Parser.init();
    }

    public static synchronized void init() throws ConfigurationException {
        if (initialized) {
            return;
        }
        SpotColorList.init();
        Bidi.init();
        Attr.init();
        Expr.init();
        AttributeParser.init();
        Attn.init();
        Elem.init();
        WritingMode.init();
        initialized = true;
    }

    void parse(XMLReader xMLReader, org.xml.sax.InputSource inputSource, ElementHandler elementHandler) throws SAXException, IOException {
        xMLReader.setContentHandler(this.createContentHandler(inputSource.getSystemId(), elementHandler));
        xMLReader.parse(inputSource);
    }

    ContentHandler createContentHandler(String string, ElementHandler elementHandler) {
        FOPreprocessor fOPreprocessor = new FOPreprocessor(new FOHandler(string, elementHandler, this.session), this.session);
        return this.session.config.ENABLE_ACCESSIBILITY ? new XPathBuilderFilter(fOPreprocessor) : fOPreprocessor;
    }

    public ContentHandler createContentHandler(String string, FO fO) {
        return this.createContentHandler(string, new RootHandler(fO, this.session));
    }

    public static void main(String[] stringArray) throws Exception {
        String string = null;
        if (stringArray.length == 1) {
            string = stringArray[0] + ".parsed";
            System.out.println("Dumping parser output to " + string);
        } else if (stringArray.length == 2) {
            string = stringArray[1];
        } else {
            System.out.println("Usage: com.renderx.xep.pre.Parser <input file name> [<output file name>]");
            System.exit(0);
        }
        Parser.init();
        Parser parser = new Parser();
        XMLReader xMLReader = com.renderx.sax.XMLReaderFactory.createXMLReader();
        InputSource inputSource = new InputSource(new URLSpec(stringArray[0]));
        ElementHandlerSerializer elementHandlerSerializer = new ElementHandlerSerializer(new BufferedOutputStream(new FileOutputStream(string)));
        try {
            if (System.getProperties().containsKey("com.renderx.xep.pre.DummyElementHandler")) {
                parser.parse(xMLReader, inputSource, new DummyElementHandler());
            } else {
                parser.parse(xMLReader, inputSource, elementHandlerSerializer);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            elementHandlerSerializer.flush();
            throw throwable;
        }
        elementHandlerSerializer.flush();
    }

    public static class Test
    extends TestSuite {
        static XMLReader reader = null;
        static Hashtable defaults = null;
        static boolean debugmode = false;
        static Conf conf = null;

        public static void main(String[] stringArray) {
            if (stringArray.length == 1 && stringArray[0].equals("-debug")) {
                debugmode = true;
            }
            TestRunner.run((junit.framework.Test)Test.suite());
        }

        public static junit.framework.Test suite() {
            Object object;
            Object object2;
            Object object3;
            CharSequence charSequence;
            SAXStorage sAXStorage = null;
            Vector vector = null;
            TestSuite testSuite = null;
            Hashtable hashtable = new Hashtable();
            hashtable.put("margin.xml", "Margin shorthand TestSuite");
            hashtable.put("padding.xml", "Padding shorthand TestSuite");
            hashtable.put("border.xml", "Border shorthands TestSuite");
            hashtable.put("pagebreak.xml", "Page-break shorthands TestSuite");
            hashtable.put("whitespace.xml", "White-space shorthand TestSuite");
            hashtable.put("font.xml", "Font shorthand TestSuite");
            hashtable.put("background.xml", "Background shorthand TestSuite");
            hashtable.put("expressions.xml", "Basic expressions TestSuite");
            hashtable.put("composite.xml", "Composite properties TestSuite");
            hashtable.put("shorthands.xml", "Basic shorthands TestSuite");
            TestSuite testSuite2 = new TestSuite("Parser TestSuite");
            try {
                Test.initParser();
                sAXStorage = Test.parseTemplate("testing.fo");
            }
            catch (Exception exception) {
                System.out.println("Error during setup! " + exception);
            }
            try {
                conf = new Conf();
            }
            catch (ConfigurationException configurationException) {
                System.out.println("Configuration problems while initializing parser" + configurationException);
            }
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                charSequence = (String)enumeration.nextElement();
                try {
                    vector = Test.parseAttributes((String)charSequence);
                }
                catch (Exception exception) {
                    System.out.println("Error during parsing test data! File: " + (String)charSequence + exception);
                }
                testSuite = new TestSuite((String)hashtable.get(charSequence));
                int n = 0;
                while (n < vector.size()) {
                    object3 = (TestAttribute)vector.elementAt(n);
                    object2 = new ParserAttributesTest(((TestAttribute)object3).name + "#" + n);
                    ((ParserAttributesTest)((Object)object2)).debugmode = debugmode;
                    ((ParserAttributesTest)((Object)object2)).defaults = defaults;
                    ((ParserAttributesTest)((Object)object2)).attr = object3;
                    ((ParserAttributesTest)((Object)object2)).template = sAXStorage;
                    testSuite.addTest((junit.framework.Test)object2);
                    ++n;
                }
                testSuite2.addTest((junit.framework.Test)testSuite);
            }
            charSequence = new StringBuffer();
            Vector<String[]> vector2 = null;
            TestSuite testSuite3 = new TestSuite("Parser Inheritance TestSuite");
            vector2 = new Vector<String[]>();
            try {
                object3 = new BufferedReader(new InputStreamReader(ClassLoader.getSystemResourceAsStream("com/renderx/xep/pre/TEST_DATA/testing.fo")));
                while ((object2 = ((BufferedReader)object3).readLine()) != null) {
                    ((StringBuffer)charSequence).append((String)object2);
                }
                object3 = new BufferedReader(new InputStreamReader(ClassLoader.getSystemResourceAsStream("com/renderx/xep/pre/TEST_DATA/props.txt")));
                while ((object2 = ((BufferedReader)object3).readLine()) != null) {
                    String string = ((String)object2).substring(((String)object2).indexOf(" ") + 1);
                    vector2.add(new String[]{((String)object2).substring(0, ((String)object2).indexOf(" ")), string.substring(string.indexOf(" ") + 1), string.substring(0, string.indexOf(" "))});
                }
            }
            catch (Exception exception) {
                System.out.println("Error! Can't find properties! " + exception);
            }
            int n = 0;
            while (n < vector2.size()) {
                object = (String[])vector2.elementAt(n);
                String string = ((StringBuffer)charSequence).toString();
                string = string.substring(0, string.indexOf("<fo:root") + 9) + object[0] + "=\"" + object[1] + "\" " + string.substring(string.indexOf("<fo:root") + 9);
                ParserInheritanceTest parserInheritanceTest = new ParserInheritanceTest(object[0]);
                parserInheritanceTest.debugmode = debugmode;
                parserInheritanceTest.xml = string;
                parserInheritanceTest.name = object[0];
                parserInheritanceTest.value = object[1];
                parserInheritanceTest.inherited = object[2];
                testSuite3.addTest((junit.framework.Test)parserInheritanceTest);
                ++n;
            }
            testSuite2.addTest((junit.framework.Test)testSuite3);
            object = new ParserMarkerTest("Parser Marker Test");
            object.debugmode = debugmode;
            testSuite2.addTest((junit.framework.Test)object);
            return testSuite2;
        }

        static void initParser() throws SAXException, ParserConfigurationException, IOException {
            Cloneable cloneable;
            if (User.getProperty("org.xml.sax.driver") == null) {
                cloneable = User.getProperties();
                ((Properties)cloneable).put("org.xml.sax.driver", "com.icl.saxon.aelfred.SAXDriver");
                User.setProperties((Properties)cloneable);
            }
            reader = XMLReaderFactory.createXMLReader();
            cloneable = Test.parseAttributes("defaults.xml");
            defaults = new Hashtable();
            int n = 0;
            while (n < ((Vector)cloneable).size()) {
                TestAttribute testAttribute = (TestAttribute)((Vector)cloneable).elementAt(n);
                defaults.put(testAttribute.name, testAttribute.value);
                ++n;
            }
        }

        static SAXStorage parseTemplate(String string) throws SAXException, IOException {
            SAXStorage sAXStorage = new SAXStorage();
            reader.setContentHandler(sAXStorage);
            reader.parse(new org.xml.sax.InputSource(ClassLoader.getSystemResourceAsStream("com/renderx/xep/pre/TEST_DATA/" + string)));
            return sAXStorage;
        }

        static Vector parseAttributes(String string) throws SAXException, IOException {
            MyContentHandler myContentHandler = new MyContentHandler();
            reader.setContentHandler(myContentHandler);
            reader.parse(new org.xml.sax.InputSource(ClassLoader.getSystemResourceAsStream("com/renderx/xep/pre/TEST_DATA/" + string)));
            return myContentHandler.attributes;
        }

        static class ParserMarkerTest
        extends TestCase {
            StringBuffer xmlsource = new StringBuffer();
            Vector objs = null;
            boolean debugmode = false;

            ParserMarkerTest(String string) {
                super(string);
            }

            public void runTest() {
                this.testMarker();
            }

            protected void setUp() {
                this.objs = new Vector();
                try {
                    String string;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(ClassLoader.getSystemResourceAsStream("com/renderx/xep/pre/TEST_DATA/marker-locations.fo")));
                    while ((string = bufferedReader.readLine()) != null) {
                        this.xmlsource.append(string);
                    }
                    bufferedReader = new BufferedReader(new InputStreamReader(ClassLoader.getSystemResourceAsStream("com/renderx/xep/pre/TEST_DATA/marker-locations.txt")));
                    while ((string = bufferedReader.readLine()) != null) {
                        this.objs.add(string);
                    }
                }
                catch (Exception exception) {
                    System.out.println("Error while reading source..." + exception);
                }
            }

            public void testMarker() {
                Parser parser = null;
                String string = "";
                int n = 0;
                while (n < this.objs.size()) {
                    String string2 = (String)this.objs.elementAt(n);
                    int n2 = this.xmlsource.toString().indexOf("<fo:flow");
                    int n3 = this.xmlsource.substring(n2).indexOf("<fo:" + string2);
                    int n4 = this.xmlsource.substring(n2 + n3).indexOf(">");
                    String string3 = this.xmlsource.substring(0, n2 + n3 + n4 + 1) + "<fo:marker marker-class-name=\"test\">Test</fo:marker>" + this.xmlsource.substring(n2 + n3 + n4 + 1);
                    InputSource inputSource = new InputSource(new StringReader(string3));
                    MyElementHandler myElementHandler = new MyElementHandler();
                    myElementHandler.name = string2;
                    try {
                        parser = new Parser(new Session(conf));
                        if (this.debugmode) {
                            ElementHandlerSerializer elementHandlerSerializer = new ElementHandlerSerializer(new BufferedOutputStream(new FileOutputStream(string2 + ".parsed")));
                            parser.parse(reader, inputSource, elementHandlerSerializer);
                            elementHandlerSerializer.flush();
                        } else {
                            parser.parse(reader, inputSource, myElementHandler);
                        }
                    }
                    catch (Exception exception) {
                        System.out.println("Error while parsing " + exception);
                    }
                    if (!this.debugmode && !myElementHandler.found) {
                        string = string + "\nError! Element fo:" + myElementHandler.name + " doesn't support markers...";
                    }
                    ++n;
                }
                if (!string.equals("")) {
                    Assert.fail((String)string);
                }
                Assert.assertTrue((boolean)true);
            }

            class MyElementHandler
            implements ElementHandler {
                String name = null;
                boolean found = false;

                public void endElement(short s) {
                }

                public void startElement(short s, AttList attList) {
                    if (Elem.getName(s).equals("marker")) {
                        this.found = true;
                    }
                }
            }
        }

        static class ParserInheritanceTest
        extends TestCase {
            boolean debugmode = false;
            String xml = null;
            String name = null;
            String value = null;
            String inherited = null;

            ParserInheritanceTest(String string) {
                super(string);
            }

            public void runTest() {
                this.testInheritance();
            }

            public void testInheritance() {
                Parser parser = null;
                String string = "";
                InputSource inputSource = new InputSource(new StringReader(this.xml));
                try {
                    inputSource.setSystemId(URLUtil.toURL(new File(".")).toExternalForm());
                }
                catch (Exception exception) {
                    System.out.println("Cannot set source document SystemID " + exception);
                }
                InheritanceElementHandler inheritanceElementHandler = new InheritanceElementHandler();
                inheritanceElementHandler.name = this.name;
                inheritanceElementHandler.val = this.value;
                try {
                    parser = new Parser(new Session(conf));
                    if (this.debugmode) {
                        System.err.println("Dumping parsed file to " + this.name + ".parsed");
                        FileOutputStream fileOutputStream = new FileOutputStream(this.name + ".parsed");
                        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                        ElementHandlerSerializer elementHandlerSerializer = new ElementHandlerSerializer(bufferedOutputStream);
                        parser.parse(XMLReaderFactory.createXMLReader(), inputSource, elementHandlerSerializer);
                        elementHandlerSerializer.flush();
                        bufferedOutputStream.flush();
                        fileOutputStream.close();
                    } else {
                        parser.parse(XMLReaderFactory.createXMLReader(), inputSource, inheritanceElementHandler);
                    }
                }
                catch (Exception exception) {
                    System.out.println("Error while parsing " + exception);
                    exception.printStackTrace(System.err);
                }
                if (!this.debugmode && inheritanceElementHandler.found && this.inherited.equals("no")) {
                    Assert.fail((String)("Extra inheritance error! Property " + this.name + " was inherited, but it violates the spec!"));
                }
                if (!this.debugmode && !inheritanceElementHandler.found && this.inherited.equals("yes")) {
                    Assert.fail((String)("Missing inheritance error! Property " + this.name + " was not inherited, but it must be inherited according to spec!"));
                }
                Assert.assertTrue((boolean)true);
            }

            class InheritanceElementHandler
            implements ElementHandler {
                String name = null;
                String val = null;
                boolean found = false;

                public void endElement(short s) {
                }

                public void startElement(short s, AttList attList) {
                    Enumeration enumeration = attList.keys();
                    while (enumeration.hasMoreElements()) {
                        Attn attn = (Attn)enumeration.nextElement();
                        if (attn.name.equals("table-omit-footer-at-break") || attn.name.equals("column-number") || attn.name.equals("float") || attn.name.equals("number-columns-spanned") || attn.name.equals("number-rows-spanned") || attn.name.equals("src") || Elem.getName(s).equals("root") && attn.name.equals("media-usage") || !attn.name.equals(this.name) && !attn.name.startsWith(this.name + ".") || attn.name.startsWith("border-") && attn.name.endsWith("-width.length") && defaults.get(attn.name) != null && defaults.get(attn.name).equals(attList.get(attn).toString()) || attn.name.equals("content-type") && Elem.getName(s).equals("external-graphic") && !attList.get(attn).toString().equals(this.val)) continue;
                        this.found = true;
                    }
                }
            }
        }

        static class ParserAttributesTest
        extends TestCase {
            Hashtable defaults = null;
            boolean debugmode = false;
            SAXStorage template = null;
            TestAttribute attr = null;
            String testName = null;

            ParserAttributesTest(String string) {
                super(string);
                this.testName = string;
            }

            public void runTest() {
                this.testAttributes();
            }

            public void testAttributes() {
                MyElementHandler myElementHandler = new MyElementHandler();
                MyXMLFilter myXMLFilter = new MyXMLFilter();
                myXMLFilter.attr = this.attr;
                myElementHandler.attr = this.attr;
                myXMLFilter.setParent(this.template);
                Parser parser = null;
                try {
                    parser = new Parser(new Session(conf));
                }
                catch (ConfigurationException configurationException) {
                    System.out.println("Configuration problems while initializing parser" + configurationException);
                }
                try {
                    if (this.debugmode) {
                        String string = this.testName + ".parsed";
                        if (string.indexOf(":") != -1) {
                            string = string.substring(string.indexOf(":") + 1);
                        }
                        Serializer serializer = new Serializer(string + "-source");
                        myXMLFilter.setContentHandler(serializer);
                        myXMLFilter.parse(new NullSource());
                        ElementHandlerSerializer elementHandlerSerializer = new ElementHandlerSerializer(new BufferedOutputStream(new FileOutputStream(string)));
                        parser.parse(myXMLFilter, new NullSource(), elementHandlerSerializer);
                        elementHandlerSerializer.flush();
                    } else {
                        parser.parse(myXMLFilter, new NullSource(), myElementHandler);
                    }
                }
                catch (Exception exception) {
                    System.out.println("Error while parsing " + exception);
                    exception.printStackTrace(System.out);
                    Assert.fail((String)("Error while parsing " + exception));
                }
            }

            class MyElementHandler
            implements ElementHandler {
                TestAttribute attr = null;
                boolean scipflag = true;

                public void endElement(short s) {
                }

                public void startElement(short s, AttList attList) {
                    if (Elem.getName(s).equals("block") && this.scipflag) {
                        this.scipflag = false;
                        return;
                    }
                    if (Elem.getName(s).equals(this.attr.element)) {
                        String string = "\nElement: " + Elem.getName(s) + " Source attribute: " + this.attr.name + "=\"" + this.attr.value + "\"\nProperties found: " + attList.toString() + "\nExpected properties:\n ";
                        int n = 0;
                        while (n < this.attr.props.size()) {
                            block10: {
                                String[] stringArray = (String[])this.attr.props.elementAt(n);
                                string = string + stringArray[0] + "=\"" + stringArray[1] + "\";\n ";
                                try {
                                    Attn attn = Attn.byName(stringArray[0]);
                                    if (attList.containsKey(attn)) {
                                        if (stringArray[0].equals("background-image")) {
                                            String string2 = stringArray[1];
                                            String string3 = attList.get(attn).toString();
                                            File file = new File(string2);
                                            File file2 = new File(string3);
                                            try {
                                                string2 = file.getCanonicalPath();
                                                string3 = file2.getCanonicalPath();
                                            }
                                            catch (Exception exception) {
                                                Assert.fail((String)"Can't calculate canonical path...");
                                            }
                                            Assert.assertEquals((String)("Property " + stringArray[0] + " corresponding to attribute " + this.attr.name + "=" + this.attr.value + " found in output, but has wrong value.\n"), (String)string2, (String)string3);
                                            break block10;
                                        }
                                        Assert.assertEquals((String)("Property " + stringArray[0] + " corresponding to attribute " + this.attr.name + "=" + this.attr.value + " found in output, but has wrong value.\n"), (String)stringArray[1], (String)attList.get(attn).toString());
                                        break block10;
                                    }
                                    if (ParserAttributesTest.this.defaults.get(stringArray[0]) == null || !ParserAttributesTest.this.defaults.get(stringArray[0]).equals(stringArray[1])) {
                                        Assert.fail((String)("Property " + stringArray[0] + " (value " + stringArray[1] + ") corresponding to attribute " + this.attr.name + "=" + this.attr.value + " wasn't found in output." + string + "\n"));
                                    }
                                }
                                catch (ParserException parserException) {
                                    Assert.fail((String)("Invalid attribute name! " + parserException));
                                }
                            }
                            ++n;
                        }
                    }
                }
            }

            class MyXMLFilter
            extends XMLFilterImpl {
                TestAttribute attr = null;
                AttributesImpl newatts = null;

                MyXMLFilter() {
                }

                public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                    if (string2.equals(this.attr.element)) {
                        this.newatts = new AttributesImpl();
                        int n = 0;
                        while (n < attributes.getLength()) {
                            String string4 = attributes.getQName(n);
                            if (string4 == null || !string4.startsWith("xmlns:")) {
                                this.newatts.addAttribute(attributes.getURI(n), attributes.getLocalName(n), attributes.getQName(n), attributes.getType(n), attributes.getValue(n));
                            }
                            ++n;
                        }
                        this.newatts.addAttribute("", this.attr.name, this.attr.name, "CDATA", this.attr.value);
                        super.startElement(string, string2, string3, this.newatts);
                    } else {
                        super.startElement(string, string2, string3, attributes);
                    }
                }
            }
        }

        static class TestAttribute {
            String name = "";
            String value = "";
            String element = "";
            Vector props = new Vector();

            TestAttribute() {
            }
        }

        static class MyContentHandler
        extends DefaultHandler {
            Vector attributes = new Vector();
            TestAttribute attr = null;

            MyContentHandler() {
            }

            public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                if (string2.equals("attribute")) {
                    this.attr = new TestAttribute();
                    this.attr.name = attributes.getValue("name");
                    this.attr.value = attributes.getValue("value");
                    this.attr.element = attributes.getValue("element");
                } else if (string2.equals("property")) {
                    this.attr.props.add(new String[]{attributes.getValue("name"), attributes.getValue("value")});
                }
            }

            public void endElement(String string, String string2, String string3) throws SAXException {
                if (string2.equals("attribute")) {
                    this.attributes.add(this.attr);
                }
            }
        }
    }
}

