/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pslib;

import com.renderx.graphics.vector.ExternalImage;
import com.renderx.graphics.vector.Gradient;
import com.renderx.graphics.vector.OpaqueColor;
import com.renderx.graphics.vector.PaintServer;
import com.renderx.graphics.vector.Pattern;
import com.renderx.pslib.Function;
import com.renderx.pslib.PSOutputStream;
import com.renderx.util.Hashtable;
import com.renderx.util.List;
import java.io.IOException;
import java.util.Enumeration;

public class Patterns {
    int patternsCount = -1;
    Hashtable patterns = new Hashtable();

    Patterns() {
    }

    String getPSPatternName(PaintServer paintServer) {
        return (String)this.patterns.get(paintServer);
    }

    void addPattern(PaintServer paintServer) {
        ++this.patternsCount;
        this.patterns.put(paintServer, "P" + this.patternsCount);
    }

    void write(PSOutputStream pSOutputStream) throws IOException {
        Enumeration enumeration = this.patterns.keys();
        while (enumeration.hasMoreElements()) {
            PaintServer paintServer = (PaintServer)enumeration.nextElement();
            pSOutputStream.print("/" + this.patterns.get(paintServer) + " ");
            PSPattern pSPattern = null;
            if (paintServer instanceof Gradient) {
                pSPattern = new ShadingPattern((Gradient)paintServer);
            } else if (paintServer instanceof Pattern) {
                pSPattern = new TilingPattern((Pattern)paintServer);
            }
            pSPattern.write(pSOutputStream);
            pSOutputStream.println();
            pSOutputStream.print("/Pattern ");
            pSOutputStream.println("defineresource");
        }
    }

    static class ShadingPattern
    extends PSPattern {
        PSShading shading = null;

        ShadingPattern(Gradient gradient) {
            super(gradient);
        }

        String getPatternType() {
            return "2";
        }

        void writePatternContent(PSOutputStream pSOutputStream) throws IOException {
            if (this.paintServer instanceof Gradient.LinearGradient) {
                this.shading = new AxialShading((Gradient)this.paintServer);
            } else if (this.paintServer instanceof Gradient.RadialGradient) {
                this.shading = new RadialShading((Gradient)this.paintServer);
            }
            pSOutputStream.println();
            pSOutputStream.print("/Shading ");
            this.shading.write(pSOutputStream);
        }

        static class RadialShading
        extends PSShading {
            Function.FunctionType3 function;

            RadialShading(Gradient gradient) {
                super(gradient);
            }

            String getShadingType() {
                return "3";
            }

            void writeShadingContent(PSOutputStream pSOutputStream) throws IOException {
                Gradient.RadialGradient radialGradient = (Gradient.RadialGradient)this.gradient;
                pSOutputStream.print("/Coords [");
                pSOutputStream.print("" + radialGradient.xbeg + " " + radialGradient.ybeg + " " + radialGradient.rbeg + " " + radialGradient.xend + " " + radialGradient.yend + " " + radialGradient.rend);
                pSOutputStream.print("] ");
                pSOutputStream.print("/Domain [0 1] ");
                pSOutputStream.println();
                pSOutputStream.print("/Function ");
                this.function = new Function.FunctionType3(this.colorComponents);
                this.setFunctionType3Intervals(pSOutputStream, this.function);
                this.function.write(pSOutputStream);
                pSOutputStream.print("/Extend [false true]");
            }
        }

        public static class AxialShading
        extends PSShading {
            Function.FunctionType3 function;

            AxialShading(Gradient gradient) {
                super(gradient);
            }

            String getShadingType() {
                return "2";
            }

            void writeShadingContent(PSOutputStream pSOutputStream) throws IOException {
                Gradient.LinearGradient linearGradient = (Gradient.LinearGradient)this.gradient;
                pSOutputStream.print("/Coords [");
                pSOutputStream.print("" + linearGradient.xbeg + " " + linearGradient.ybeg + " " + linearGradient.xend + " " + linearGradient.yend);
                pSOutputStream.print("] ");
                pSOutputStream.print("/Domain [0 1] ");
                pSOutputStream.println();
                pSOutputStream.print("/Function ");
                this.function = new Function.FunctionType3(this.colorComponents);
                this.setFunctionType3Intervals(pSOutputStream, this.function);
                this.function.write(pSOutputStream);
                pSOutputStream.print("/Extend [true true]");
            }
        }

        static abstract class PSShading {
            final Gradient gradient;
            int colorComponents;

            PSShading(Gradient gradient) {
                this.gradient = gradient;
            }

            abstract String getShadingType();

            abstract void writeShadingContent(PSOutputStream var1) throws IOException;

            void write(PSOutputStream pSOutputStream) throws IOException {
                pSOutputStream.print("<</ShadingType " + this.getShadingType() + " ");
                pSOutputStream.print("/ColorSpace " + this.getColorSpace(pSOutputStream));
                this.writeShadingContent(pSOutputStream);
                pSOutputStream.print(">>");
            }

            Function.FunctionType2 createFunctionType2(PSOutputStream pSOutputStream, double[] dArray, double[] dArray2) {
                Function.FunctionType2 functionType2 = new Function.FunctionType2(this.colorComponents, 1.0);
                functionType2.setC0(dArray);
                functionType2.setC1(dArray2);
                return functionType2;
            }

            void setFunctionType3Intervals(PSOutputStream pSOutputStream, Function.FunctionType3 functionType3) {
                Gradient.Stop stop = (Gradient.Stop)this.gradient.stoplist.car();
                stop.offset = 0.0;
                Enumeration enumeration = this.gradient.stoplist.elements();
                while (enumeration.hasMoreElements()) {
                    Gradient.Stop stop2 = (Gradient.Stop)enumeration.nextElement();
                    if (stop2.offset > stop.offset) {
                        functionType3.addFunction(this.createFunctionType2(pSOutputStream, stop.color.values(), stop2.color.values()));
                        if (stop2.offset < 1.0) {
                            functionType3.addBound(stop2.offset);
                        }
                    }
                    stop = stop2;
                }
                if (stop.offset < 1.0) {
                    functionType3.addFunction(this.createFunctionType2(pSOutputStream, stop.color.values(), stop.color.values()));
                }
            }

            private boolean checkColorSpaceConsistency() {
                OpaqueColor opaqueColor = ((Gradient.Stop)this.gradient.stoplist.car()).color;
                Enumeration enumeration = this.gradient.stoplist.elements();
                while (enumeration.hasMoreElements()) {
                    OpaqueColor opaqueColor2 = ((Gradient.Stop)enumeration.nextElement()).color;
                    if (!opaqueColor.getClass().getName().equals(opaqueColor2.getClass().getName())) {
                        return false;
                    }
                    opaqueColor = opaqueColor2;
                }
                return true;
            }

            private void setDefaultColors() {
                Gradient.Stop stop = new Gradient.Stop(0.0, new OpaqueColor.RGB(0.0, 0.0, 0.0), 1.0);
                Gradient.Stop stop2 = new Gradient.Stop(1.0, new OpaqueColor.RGB(0.0, 0.0, 0.0), 1.0);
                List list = new List();
                list.append(stop).append(stop2);
                this.gradient.stoplist = list;
                this.colorComponents = 3;
            }

            private String getDefaultColorSpace() {
                return "/DeviceRGB";
            }

            private String getColorSpace(PSOutputStream pSOutputStream) {
                if (!this.checkColorSpaceConsistency()) {
                    Enumeration enumeration = this.gradient.stoplist.elements();
                    while (enumeration.hasMoreElements()) {
                        Gradient.Stop stop = (Gradient.Stop)enumeration.nextElement();
                        stop.color = stop.color.toRGB();
                    }
                    return this.getDefaultColorSpace();
                }
                return this.getColorSpace(((Gradient.Stop)this.gradient.stoplist.car()).color, pSOutputStream);
            }

            private String getColorSpace(OpaqueColor opaqueColor, PSOutputStream pSOutputStream) {
                if (opaqueColor instanceof OpaqueColor.RGB) {
                    this.colorComponents = 3;
                    return "/DeviceRGB";
                }
                if (opaqueColor instanceof OpaqueColor.CMYK) {
                    this.colorComponents = 4;
                    return "/DeviceCMYK";
                }
                if (opaqueColor instanceof OpaqueColor.Grayscale) {
                    this.colorComponents = 1;
                    return "/DeviceGray";
                }
                if (opaqueColor instanceof OpaqueColor.SpotColor) {
                    return this.getColorSpace(((OpaqueColor.SpotColor)opaqueColor).altcolor, pSOutputStream);
                }
                if (opaqueColor instanceof OpaqueColor.Registration) {
                    if (pSOutputStream.doc.errorHandler != null) {
                        pSOutputStream.doc.errorHandler.warning("Unsuported color space in a gradient; gradient reverted to solid black color.");
                    }
                    this.setDefaultColors();
                    return this.getDefaultColorSpace();
                }
                if (pSOutputStream.doc.errorHandler != null) {
                    pSOutputStream.doc.errorHandler.error("Unexpected color space in a gradient; gradient reverted to solid black color.");
                }
                this.setDefaultColors();
                return this.getDefaultColorSpace();
            }
        }
    }

    static class TilingPattern
    extends PSPattern {
        double xstep = 0.0;
        double ystep = 0.0;

        TilingPattern(Pattern pattern) throws IOException {
            super(pattern);
            this.xstep = ((Pattern)this.paintServer).xstep;
            this.ystep = ((Pattern)this.paintServer).ystep;
        }

        String getPatternType() {
            return "1";
        }

        void writePatternContent(PSOutputStream pSOutputStream) throws IOException {
            pSOutputStream.print("/PaintType 1 ");
            pSOutputStream.println("/TilingType 1");
            pSOutputStream.print("/BBox [0 0 " + this.xstep + " " + this.ystep + "] ");
            pSOutputStream.print("/XStep " + this.xstep + " ");
            pSOutputStream.println("/YStep " + this.ystep);
        }

        void writeTail(PSOutputStream pSOutputStream) throws IOException {
            pSOutputStream.println("/PaintProc {");
            pSOutputStream.doc.setCharSpacing(0.0f);
            pSOutputStream.doc.setWordSpacing(0.0f);
            ExternalImage externalImage = (ExternalImage)((Pattern)this.paintServer).content.children.car();
            pSOutputStream.doc.placeImage(externalImage.image, false);
            pSOutputStream.print("} bind >>");
        }
    }

    static abstract class PSPattern {
        final PaintServer paintServer;

        PSPattern(PaintServer paintServer) {
            this.paintServer = paintServer;
        }

        abstract String getPatternType();

        abstract void writePatternContent(PSOutputStream var1) throws IOException;

        void write(PSOutputStream pSOutputStream) throws IOException {
            pSOutputStream.print("<</PatternType " + this.getPatternType() + " ");
            this.writePatternContent(pSOutputStream);
            this.writeTail(pSOutputStream);
        }

        void writeTail(PSOutputStream pSOutputStream) throws IOException {
            pSOutputStream.print(">>");
        }
    }
}

