/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pslib;

import com.renderx.graphics.ImageFormatException;
import com.renderx.pslib.Image;
import com.renderx.pslib.PSDocument;
import com.renderx.pslib.PSOutputStream;
import com.renderx.pslib.PageId;
import com.renderx.util.Array;
import com.renderx.util.Hashtable;
import com.renderx.util.List;
import com.renderx.util.URLSpec;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class Pages {
    int currentPageNumber = 0;
    Page currentPage = null;
    PSDocument doc = null;
    public boolean USE_TEMP_FILE = true;
    private static int filenumber = 0;
    File tempFile = null;
    RandomAccessFile raf = null;
    private Array pages = new Array();

    static synchronized File getTempFile(File file) {
        File file2 = null;
        while ((file2 = new File(file, Integer.toHexString((int)System.currentTimeMillis()) + "_" + Integer.toHexString(++filenumber) + ".tmp")).exists()) {
        }
        return file2;
    }

    Pages(PSDocument pSDocument, File file) {
        this.doc = pSDocument;
        boolean bl = this.USE_TEMP_FILE = file != null;
        if (this.USE_TEMP_FILE) {
            try {
                this.tempFile = Pages.getTempFile(file);
                this.raf = new RandomAccessFile(this.tempFile, "rw");
            }
            catch (IOException iOException) {
                pSDocument.errorHandler.exception("Cannot create temporary file " + this.tempFile.toString(), iOException);
                this.USE_TEMP_FILE = false;
            }
        }
    }

    int length() {
        return this.pages.length();
    }

    void insertBlankPage(int n) {
        this.pages.put(n, null);
    }

    void writeComment(PSOutputStream pSOutputStream, String string) throws IOException {
        if (string != null) {
            pSOutputStream.println(string);
        } else {
            pSOutputStream.doc.errorHandler.error("Internal error: a PostScript comment is null");
        }
    }

    void write(PSOutputStream pSOutputStream) throws IOException {
        int n = 0;
        while (n < this.length()) {
            Page page;
            if ((page = (Page)this.pages.get(n++)) != null) {
                pSOutputStream.println("%%Page: " + page.id.generateNextId() + " " + n);
                page.write(pSOutputStream);
                continue;
            }
            pSOutputStream.println("%%Page: " + n + " " + n);
            pSOutputStream.println("%%BeginPageSetup");
            pSOutputStream.println("%%EndPageSetup");
            pSOutputStream.println("showpage");
            pSOutputStream.println("%%PageTrailer");
        }
        if (this.USE_TEMP_FILE) {
            this.raf.close();
            this.tempFile.delete();
        }
    }

    void beginPage(String string) throws IOException {
        this.currentPage = new Page(string);
        this.pages.put(this.currentPageNumber, this.currentPage);
        ++this.currentPageNumber;
    }

    void endPage() throws IOException {
        this.currentPage.endPage();
        this.currentPage = null;
    }

    public Page getCurrentPage() {
        return this.currentPage;
    }

    static class PageBoundaries {
        Hashtable boundaries = new Hashtable();

        public PageBoundaries(Hashtable hashtable) {
            this.boundaries = (Hashtable)hashtable.clone();
        }

        public boolean isBleeds() {
            return this.boundaries.containsKey("BLEED");
        }

        public boolean isMediaBoxOffset() {
            return this.boundaries.containsKey("CROP_OFFSET");
        }

        public boolean isBleedMarkWidth() {
            return this.boundaries.containsKey("BLEED_MARK_WIDTH");
        }

        public boolean isCropMarkWidth() {
            return this.boundaries.containsKey("CROP_MARK_WIDTH");
        }

        public float[] getBleeds() {
            float[] fArray = new float[4];
            int n = 0;
            while (n < fArray.length) {
                fArray[n] = 0.0f;
                ++n;
            }
            if (this.isBleeds()) {
                fArray = (float[])this.boundaries.get("BLEED");
            }
            return fArray;
        }

        public float[] getMediaBoxOffset() {
            float[] fArray = new float[4];
            int n = 0;
            while (n < fArray.length) {
                fArray[n] = 0.0f;
                ++n;
            }
            if (this.isMediaBoxOffset()) {
                fArray = (float[])this.boundaries.get("CROP_OFFSET");
            }
            float[] fArray2 = this.getBleeds();
            int n2 = 0;
            while (n2 < fArray.length) {
                if (fArray[n2] < fArray2[n2]) {
                    fArray[n2] = fArray2[n2];
                }
                ++n2;
            }
            return fArray;
        }

        public float getBleedMarkWidth() {
            return !this.isBleedMarkWidth() ? 0.0f : new Float((String)this.boundaries.get("BLEED_MARK_WIDTH")).floatValue();
        }

        public float getCropMarkWidth() {
            return !this.isCropMarkWidth() ? 0.0f : new Float((String)this.boundaries.get("CROP_MARK_WIDTH")).floatValue();
        }

        public boolean isPageOffset() {
            return this.isMediaBoxOffset() || this.isBleeds();
        }
    }

    public class Page {
        private ByteArrayOutputStream accumulator = null;
        public PSOutputStream contentStream = null;
        public PageId id = null;
        private long dataOffset = 0L;
        private long dataLength = 0L;
        Hashtable pagedevice = new Hashtable();
        Hashtable pageboundaries = new Hashtable();
        List printermarks = new List();
        private final Hashtable pageLevelComments = new Hashtable();
        List images = new List();

        Page(String string) throws IOException {
            this.id = new PageId(string);
            if (Pages.this.USE_TEMP_FILE) {
                this.dataOffset = Pages.this.raf.getFilePointer();
                this.contentStream = new PSOutputStream(Pages.this.doc, new RAFOutputStream());
            } else {
                this.accumulator = new ByteArrayOutputStream();
                this.contentStream = new PSOutputStream(Pages.this.doc, this.accumulator);
            }
        }

        public void writePageSetup(PSOutputStream pSOutputStream) throws IOException {
            Object object;
            Object object2;
            Object object3;
            pSOutputStream.println("%%BeginPageSetup");
            Enumeration enumeration = this.images.elements();
            while (enumeration.hasMoreElements()) {
                object3 = (String)enumeration.nextElement();
                if (pSOutputStream.doc.images.getImageCountById((String)object3) > pSOutputStream.doc.IMAGE_INLINE_THRESHOLD) continue;
                try {
                    object = object2 = pSOutputStream.doc.images.getImageById((String)object3);
                    synchronized (object) {
                        boolean bl = false;
                        URLSpec uRLSpec = null;
                        if (((com.renderx.graphics.Image)object2).source == null) {
                            uRLSpec = ((com.renderx.graphics.Image)object2).getFactory().getSource((com.renderx.graphics.Image)object2);
                            if (((com.renderx.graphics.Image)object2).source == null) {
                                bl = true;
                                ((com.renderx.graphics.Image)object2).source = uRLSpec;
                            }
                        }
                        Image image = new Image((com.renderx.graphics.Image)object2, (String)object3);
                        image.write(pSOutputStream);
                        if (bl) {
                            ((com.renderx.graphics.Image)object2).source = null;
                        }
                    }
                }
                catch (ImageFormatException imageFormatException) {
                    pSOutputStream.doc.errorHandler.exception("", imageFormatException);
                }
            }
            object3 = this.pagedevice.keys();
            if (object3.hasMoreElements()) {
                pSOutputStream.println("XEPPS_DocumentPageDevice dup length dict copy");
                while (object3.hasMoreElements()) {
                    object2 = (String)object3.nextElement();
                    object = (String)this.pagedevice.get(object2);
                    pSOutputStream.println("dup /" + (String)object2 + " " + (String)object + " put");
                }
                pSOutputStream.println("SafeSetPageDevice");
            } else {
                pSOutputStream.println("XEPPS_DocumentPageDevice SafeSetPageDevice");
            }
            pSOutputStream.println("%%EndPageSetup");
        }

        public void writePageTrailer(PSOutputStream pSOutputStream) throws IOException {
            pSOutputStream.println("showpage");
            pSOutputStream.println("%%PageTrailer");
        }

        public void endPage() throws IOException {
            this.contentStream.flush();
            if (Pages.this.USE_TEMP_FILE) {
                this.dataLength = Pages.this.raf.getFilePointer() - this.dataOffset;
            }
        }

        void writePrinterMarks(PSOutputStream pSOutputStream) throws IOException {
            PageBoundaries pageBoundaries = new PageBoundaries(this.pageboundaries);
            PageBoundaries pageBoundaries2 = new PageBoundaries(pSOutputStream.doc.getPageBoundaries());
            if (pageBoundaries.isPageOffset() || pageBoundaries2.isPageOffset()) {
                float[] fArray = pageBoundaries2.getBleeds();
                if (pageBoundaries.isBleeds()) {
                    fArray = pageBoundaries.getBleeds();
                }
                float[] fArray2 = pageBoundaries2.getMediaBoxOffset();
                if (pageBoundaries.isMediaBoxOffset()) {
                    fArray2 = pageBoundaries.getMediaBoxOffset();
                }
                String string = pSOutputStream.doc.getPageDeviceEntry("PageSize");
                if (this.pagedevice.containsKey("PageSize")) {
                    string = (String)this.pagedevice.get("PageSize");
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                String string2 = stringTokenizer.nextToken();
                string2 = string2.substring(1);
                String string3 = stringTokenizer.nextToken();
                string3 = string3.substring(0, string3.length() - 1);
                float f = new Float(string2).floatValue();
                float f2 = new Float(string3).floatValue();
                pSOutputStream.println("gsave");
                pSOutputStream.println("newpath");
                pSOutputStream.println("0 0 moveto");
                pSOutputStream.println("0 " + string3 + " lineto");
                pSOutputStream.println(string2 + " " + string3 + " lineto");
                pSOutputStream.println(string2 + " " + 0 + " lineto");
                pSOutputStream.println("closepath");
                pSOutputStream.println("clippath");
                pSOutputStream.println("newpath");
                pSOutputStream.println("" + (fArray2[0] - fArray[0]) + " " + (fArray2[1] - fArray[1]) + " moveto");
                pSOutputStream.println("" + (fArray2[0] - fArray[0]) + " " + (f2 - fArray2[3] + fArray[3]) + " lineto");
                pSOutputStream.println("" + (f - fArray2[2] + fArray[2]) + " " + (f2 - fArray2[3] + fArray[3]) + " lineto");
                pSOutputStream.println("" + (f - fArray2[2] + fArray[2]) + " " + (fArray2[1] - fArray[1]) + " lineto");
                pSOutputStream.println("closepath");
                pSOutputStream.println("clip");
                pSOutputStream.println("newpath");
                pSOutputStream.println("" + fArray2[0] + " " + fArray2[1] + " translate");
            }
        }

        private void writePageLevelComments(PSOutputStream pSOutputStream) throws IOException {
            Enumeration enumeration = this.pageLevelComments.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)this.pageLevelComments.get(enumeration.nextElement());
                if (string == null) continue;
                pSOutputStream.println(string);
            }
        }

        public void setPageLevelComment(String string, String string2) {
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            string2 = PSDocument.handlePSCommentValue(string2, "%");
            this.pageLevelComments.put(string, string2);
        }

        void write(PSOutputStream pSOutputStream) throws IOException {
            this.contentStream.flush();
            this.writePageSetup(pSOutputStream);
            this.writePageLevelComments(pSOutputStream);
            this.writePrinterMarks(pSOutputStream);
            if (Pages.this.USE_TEMP_FILE) {
                byte[] byArray = new byte[16384];
                Pages.this.raf.seek(this.dataOffset);
                while (this.dataLength > 0L) {
                    int n = this.dataLength < 16384L ? (int)this.dataLength : 16384;
                    Pages.this.raf.readFully(byArray, 0, n);
                    pSOutputStream.write(byArray, 0, n);
                    this.dataLength -= (long)n;
                }
            } else {
                this.accumulator.writeTo(pSOutputStream);
                this.accumulator.close();
            }
            this.writePageTrailer(pSOutputStream);
        }

        class RAFOutputStream
        extends OutputStream {
            RAFOutputStream() {
            }

            public void write(int n) throws IOException {
                ((Page)Page.this).Pages.this.raf.write((byte)n);
            }

            public void write(byte[] byArray) throws IOException {
                ((Page)Page.this).Pages.this.raf.write(byArray);
            }

            public void write(byte[] byArray, int n, int n2) throws IOException {
                ((Page)Page.this).Pages.this.raf.write(byArray, n, n2);
            }
        }
    }
}

