/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.graphics.UnregisteredMIMETypeException;
import com.renderx.graphics.vector.ImageTree;
import com.renderx.graphics.vector.Pattern;
import com.renderx.pdflib.ColorSpace;
import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.PDFImage;
import com.renderx.pdflib.PDFOutputStream;
import com.renderx.pdflib.PDFPattern;
import com.renderx.pdflib.Resources;
import java.io.IOException;

public class TilingPattern
extends PDFPattern {
    PDFImage content = null;
    double xstep = 0.0;
    double ystep = 0.0;

    TilingPattern(IndirectObject indirectObject, Pattern pattern) throws UnregisteredMIMETypeException {
        super(indirectObject, pattern);
        this.xstep = pattern.xstep;
        this.ystep = pattern.ystep;
        ImageTree imageTree = new ImageTree(0.0, 0.0, this.xstep, this.ystep);
        imageTree.root = pattern.content;
        PDFImage.SubTreeVectorImage subTreeVectorImage = new PDFImage.SubTreeVectorImage(imageTree);
        subTreeVectorImage.supportsVectorRendering = true;
        this.content = new PDFImage(indirectObject, subTreeVectorImage);
    }

    String getPatternType() {
        return "1";
    }

    void writePatternContent(PDFOutputStream pDFOutputStream) {
        pDFOutputStream.println("/PaintType 1");
        pDFOutputStream.println("/TilingType 1");
        pDFOutputStream.println("/BBox [0 0 " + PDFOutputStream.pdf_float(this.xstep) + " " + PDFOutputStream.pdf_float(this.ystep) + "]");
        pDFOutputStream.println("/XStep " + PDFOutputStream.pdf_float(this.xstep));
        pDFOutputStream.println("/YStep " + PDFOutputStream.pdf_float(this.ystep));
    }

    void writeTail(PDFOutputStream pDFOutputStream) {
        this.content.length_id = pDFOutputStream.getNextID();
        IndirectObject indirectObject = pDFOutputStream.getNextID();
        pDFOutputStream.doc.currentResources = this.content.formResources = new Resources(indirectObject);
        pDFOutputStream.println("/Resources " + indirectObject.toStringR());
        pDFOutputStream.println("/Length " + this.content.length_id.toStringR());
        if (pDFOutputStream.compression) {
            pDFOutputStream.println("/Filter /FlateDecode");
        }
        pDFOutputStream.println(">>");
        pDFOutputStream.println("stream");
        try {
            int n = pDFOutputStream.size();
            pDFOutputStream.startStream();
            pDFOutputStream.doc.setCharSpacing(0.0f);
            pDFOutputStream.doc.setWordSpacing(0.0f);
            pDFOutputStream.doc.currentColorSpace = ColorSpace.cs_undefined;
            this.content.PaintGraphicObject(pDFOutputStream, this.content.imageTree.root);
            pDFOutputStream.doc.currentColorSpace = null;
            pDFOutputStream.finishStream();
            this.content.length = pDFOutputStream.size() - n;
        }
        catch (IOException iOException) {
            pDFOutputStream.exception("", iOException);
        }
        pDFOutputStream.println("\nendstream");
        pDFOutputStream.println("endobj");
        pDFOutputStream.doc.currentResources = null;
    }

    void writeSubObjects(PDFOutputStream pDFOutputStream) {
        this.content.writeSubObjects(pDFOutputStream);
    }
}

