/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.PDFObject;
import com.renderx.pdflib.PDFOutputStream;
import com.renderx.pdflib.parser.PDFName;
import com.renderx.util.Hashtable;
import com.renderx.util.User;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;

public class Info
extends PDFObject {
    String Keywords;
    String Subject;
    String Title;
    String Creator;
    String Author;
    String Producer;
    String Publisher;
    String PDFXVersion;
    String PDFXConformance;
    Calendar ca;
    Hashtable customFields = new Hashtable();
    private static int ONE_HOUR = 3600000;

    Info(IndirectObject indirectObject) {
        super(indirectObject);
    }

    void set(String string, String string2) {
        if (string == null) {
            return;
        }
        if (string2 == null) {
            return;
        }
        if (string.equals("Keywords")) {
            this.Keywords = new String(string2);
        } else if (string.equals("Subject")) {
            this.Subject = new String(string2);
        } else if (string.equals("Title")) {
            this.Title = new String(string2);
        } else if (string.equals("Creator")) {
            this.Creator = new String(string2);
        } else if (string.equals("Author")) {
            this.Author = new String(string2);
        } else if (string.equals("Producer")) {
            this.Producer = new String(string2);
        } else if (string.equals("Publisher")) {
            this.Publisher = new String(string2);
        } else if (string.equals("GTS_PDFXVersion")) {
            this.PDFXVersion = new String(string2);
        } else if (string.equals("GTS_PDFXConformance")) {
            this.PDFXConformance = new String(string2);
        } else {
            this.customFields.put(string, string2);
        }
    }

    void writeBody(PDFOutputStream pDFOutputStream) {
        String string;
        if (this.Keywords != null) {
            pDFOutputStream.print("/Keywords ");
            pDFOutputStream.print_annotation(this.Keywords);
            pDFOutputStream.println();
        }
        if (this.Subject != null) {
            pDFOutputStream.print("/Subject ");
            pDFOutputStream.print_annotation(this.Subject);
            pDFOutputStream.println();
        }
        if (this.Title != null) {
            pDFOutputStream.print("/Title ");
            pDFOutputStream.print_annotation(this.Title);
            pDFOutputStream.println();
        }
        if (this.Creator != null) {
            pDFOutputStream.print("/Creator ");
            pDFOutputStream.print_annotation(this.Creator);
            pDFOutputStream.println();
        }
        if (this.Author != null) {
            pDFOutputStream.print("/Author ");
            pDFOutputStream.print_annotation(this.Author);
            pDFOutputStream.println();
        }
        if (this.Producer != null) {
            pDFOutputStream.print("/Producer ");
            pDFOutputStream.print_annotation(this.Producer);
            pDFOutputStream.println();
        }
        Enumeration enumeration = this.customFields.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            PDFName pDFName = new PDFName(string);
            pDFOutputStream.print("/");
            pDFName.quote(pDFOutputStream);
            pDFOutputStream.print(" ");
            pDFOutputStream.print_annotation((String)this.customFields.get(string));
            pDFOutputStream.println();
        }
        pDFOutputStream.println("/Trapped /False");
        string = "D:19700101000000Z";
        if (!"true".equals(User.getProperty("com.renderx.pdflib.nodate"))) {
            this.ca = new GregorianCalendar();
            this.ca.setTime(new Date());
            string = Info.calendarToString(this.ca);
        }
        pDFOutputStream.print("/CreationDate ");
        pDFOutputStream.print_annotation(string);
        pDFOutputStream.println();
        pDFOutputStream.print("/ModDate ");
        pDFOutputStream.print_annotation(string);
        pDFOutputStream.println();
        if (this.PDFXVersion != null) {
            pDFOutputStream.print("/GTS_PDFXVersion ");
            pDFOutputStream.print_annotation(this.PDFXVersion);
            pDFOutputStream.println();
        }
        if (this.PDFXConformance != null) {
            pDFOutputStream.print("/GTS_PDFXConformance ");
            pDFOutputStream.print_annotation(this.PDFXConformance);
            pDFOutputStream.println();
        }
    }

    private static String addzero(int n) {
        return n < 10 ? "0" + n : Integer.toString(n);
    }

    private static String addsignedzero(int n) {
        int n2 = Math.abs(n);
        String string = n2 < 10 ? "0" + n2 : Integer.toString(n);
        return n < 0 ? "-" + string : "+" + string;
    }

    private static String calendarToString(Calendar calendar) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
        ((Calendar)gregorianCalendar).add(11, -(calendar.get(15) / ONE_HOUR + calendar.get(16) / ONE_HOUR));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("D:");
        stringBuffer.append(new Integer(gregorianCalendar.get(1)));
        stringBuffer.append(Info.addzero(gregorianCalendar.get(2) + 1));
        stringBuffer.append(Info.addzero(gregorianCalendar.get(5)));
        stringBuffer.append(Info.addzero(gregorianCalendar.get(11)));
        stringBuffer.append(Info.addzero(gregorianCalendar.get(12)));
        stringBuffer.append(Info.addzero(gregorianCalendar.get(13)));
        stringBuffer.append("Z");
        return stringBuffer.toString();
    }

    void writeSubObjects(PDFOutputStream pDFOutputStream) {
    }
}

