/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.graphics.Image;
import com.renderx.graphics.ImageFormatException;
import com.renderx.graphics.UnregisteredMIMETypeException;
import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.PDFDocument;
import com.renderx.pdflib.PDFObject;
import com.renderx.pdflib.PDFOutputStream;
import com.renderx.smil.SMIL;
import com.renderx.util.Hashtable;
import com.renderx.util.URLSpec;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Enumeration;

class EmbeddedFiles {
    Hashtable embedded_files = new Hashtable();

    EmbeddedFiles() {
    }

    EmbeddedFile makeEmbeddedFile(URLSpec uRLSpec, PDFDocument pDFDocument) {
        EmbeddedFile embeddedFile = (EmbeddedFile)this.embedded_files.get(uRLSpec.toString());
        if (embeddedFile == null) {
            embeddedFile = new EmbeddedFile(pDFDocument.outputPDF.getNextID(), uRLSpec);
            this.embedded_files.put(uRLSpec.toString(), embeddedFile);
        }
        return embeddedFile;
    }

    void write(PDFOutputStream pDFOutputStream) {
        Enumeration enumeration = this.embedded_files.keys();
        while (enumeration.hasMoreElements()) {
            URLSpec uRLSpec = null;
            String string = (String)enumeration.nextElement();
            try {
                uRLSpec = new URLSpec(string);
            }
            catch (MalformedURLException malformedURLException) {
                pDFOutputStream.doc.errorHandler.error("MalformedURLException on '" + string + "' must have been detected earlier.");
            }
            ((EmbeddedFile)this.embedded_files.get(uRLSpec.toString())).write(pDFOutputStream);
        }
    }

    static class EmbeddedFile
    extends PDFObject {
        final URLSpec url;
        IndirectObject length_id;
        int length;

        EmbeddedFile(IndirectObject indirectObject, URLSpec uRLSpec) {
            super(indirectObject);
            this.url = uRLSpec;
        }

        String getType() {
            return "EmbeddedFile";
        }

        void copyContent(PDFOutputStream pDFOutputStream) {
            if (pDFOutputStream.compression) {
                pDFOutputStream.println("/Filter [/FlateDecode]");
            }
            pDFOutputStream.println("/Length " + this.length_id.toStringR());
            pDFOutputStream.println(">>");
            pDFOutputStream.println("stream");
            int n = pDFOutputStream.size();
            pDFOutputStream.startStream();
            Image image = null;
            SMIL sMIL = null;
            try {
                image = pDFOutputStream.doc.imageFactory.makeImage(this.url);
                if (image instanceof SMIL) {
                    sMIL = (SMIL)image;
                    sMIL.copyData(pDFOutputStream.getCurrentOutputStream());
                }
            }
            catch (IOException iOException) {
            }
            catch (ImageFormatException imageFormatException) {
            }
            catch (UnregisteredMIMETypeException unregisteredMIMETypeException) {
                // empty catch block
            }
            if (sMIL == null) {
                try {
                    InputStream inputStream = pDFOutputStream.doc.imageFactory.cache.openStream(this.url, pDFOutputStream.doc.errorHandler);
                    byte[] byArray = new byte[8192];
                    try {
                        int n2;
                        OutputStream outputStream = pDFOutputStream.getCurrentOutputStream();
                        while ((n2 = inputStream.read(byArray)) != -1) {
                            outputStream.write(byArray, 0, n2);
                        }
                        Object var10_13 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_14 = null;
                        inputStream.close();
                        throw throwable;
                    }
                    inputStream.close();
                    {
                    }
                }
                catch (IOException iOException) {
                    pDFOutputStream.exception("Cannot copy the contents of '" + this.url + "'", iOException);
                }
            }
            pDFOutputStream.finishStream();
            this.length = pDFOutputStream.size() - n;
            pDFOutputStream.println("\nendstream");
            pDFOutputStream.println("endobj");
        }

        void writeBody(PDFOutputStream pDFOutputStream) {
            this.length_id = pDFOutputStream.getNextID();
        }

        void writeTail(PDFOutputStream pDFOutputStream) {
            this.copyContent(pDFOutputStream);
        }

        void writeSubObjects(PDFOutputStream pDFOutputStream) {
            pDFOutputStream.printLength(this.length_id, this.length);
        }
    }
}

