/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.fonts.CFFFont;
import com.renderx.fonts.CharMetrics;
import com.renderx.fonts.FontDescriptor;
import com.renderx.fonts.Metric;
import com.renderx.fonts.TTMetric;
import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.PDFFontFile;
import com.renderx.pdflib.PDFOutputStream;
import com.renderx.util.SeekableByteArrayInputStream;
import com.renderx.util.SeekableInput;
import com.renderx.util.SeekableInputOffsetFilter;

public class CFFFontFile
extends PDFFontFile {
    CFFFontFile(IndirectObject indirectObject, FontDescriptor fontDescriptor, boolean bl) {
        super(indirectObject, fontDescriptor, bl);
    }

    public String pdfFontType() {
        return "FontFile3";
    }

    void writeBody(PDFOutputStream pDFOutputStream) {
        this.writeBaseData(pDFOutputStream);
        if (this.descriptor.record.getMetric().isCIDFont) {
            pDFOutputStream.println("/Subtype /CIDFontType0C");
        } else {
            pDFOutputStream.println("/Subtype /Type1C");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void writeTail(PDFOutputStream pDFOutputStream) {
        int n;
        block16: {
            pDFOutputStream.println(">>");
            pDFOutputStream.println("stream");
            n = pDFOutputStream.size();
            pDFOutputStream.startStream();
            try {
                Metric metric = this.descriptor.record.getMetric();
                if (this.enableSubset && this.descriptor.record.subset) {
                    SeekableInput seekableInput = this.descriptor.record.openSeekableFontStream();
                    byte[] byArray = new byte[(int)((TTMetric)metric).cff_length];
                    seekableInput.seek(((TTMetric)metric).cff_offset);
                    seekableInput.readFully(byArray);
                    SeekableByteArrayInputStream seekableByteArrayInputStream = new SeekableByteArrayInputStream(byArray);
                    try {
                        try {
                            CFFFont cFFFont = new CFFFont(seekableByteArrayInputStream, ((TTMetric)metric).getCFFMetric());
                            int n2 = 0;
                            while (true) {
                                Object object;
                                if (n2 >= 65536) {
                                    object = cFFFont.createSubset();
                                    pDFOutputStream.print((byte[])object);
                                    break;
                                }
                                if (this.descriptor.used.checkGlyph((char)n2) && (object = (Object)((CharMetrics)metric.uniTable.get((char)n2))) != null) {
                                    cFFFont.addGlyph(object.c);
                                }
                                ++n2;
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            Object var11_19 = null;
                            seekableByteArrayInputStream.close();
                            seekableInput.close();
                            break block16;
                        }
                        Object var11_18 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_20 = null;
                        seekableByteArrayInputStream.close();
                        seekableInput.close();
                        throw throwable;
                    }
                    seekableByteArrayInputStream.close();
                    seekableInput.close();
                    break block16;
                }
                SeekableInput seekableInput = this.descriptor.record.openSeekableFontStream();
                SeekableInputOffsetFilter seekableInputOffsetFilter = new SeekableInputOffsetFilter(seekableInput, ((TTMetric)metric).cff_offset);
                try {
                    try {
                        long l = ((TTMetric)metric).cff_length;
                        byte[] byArray = new byte[16384];
                        while (l > 0L) {
                            int n3 = l < (long)byArray.length ? (int)l : byArray.length;
                            l -= (long)n3;
                            seekableInputOffsetFilter.read(byArray, 0, n3);
                            pDFOutputStream.print(byArray, 0, n3);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        Object var13_23 = null;
                        seekableInputOffsetFilter.close();
                        seekableInput.close();
                        break block16;
                    }
                    Object var13_22 = null;
                }
                catch (Throwable throwable) {
                    Object var13_24 = null;
                    seekableInputOffsetFilter.close();
                    seekableInput.close();
                    throw throwable;
                }
                seekableInputOffsetFilter.close();
                seekableInput.close();
            }
            catch (Exception exception) {
                pDFOutputStream.exception("Cannot output subset for CFF font '" + this.descriptor.record.fontfile + "'", exception);
            }
        }
        pDFOutputStream.finishStream();
        this.length = pDFOutputStream.size() - n;
        pDFOutputStream.println("\nendstream");
        pDFOutputStream.println("endobj");
    }

    public void writeBaseData(PDFOutputStream pDFOutputStream) {
        this.length_id = pDFOutputStream.getNextID();
        pDFOutputStream.println("/Length " + this.length_id.toStringR());
        if (pDFOutputStream.compression) {
            pDFOutputStream.println("/Filter /FlateDecode");
        }
    }

    public void writeSubObjects(PDFOutputStream pDFOutputStream) {
        pDFOutputStream.printLength(this.length_id, this.length);
    }
}

