/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.graphics;

import com.renderx.graphics.ImageFormatException;

public abstract class PNGPredictor {
    private static final int PNG_FILTER_NONE = 0;
    private static final int PNG_FILTER_SUB = 1;
    private static final int PNG_FILTER_UP = 2;
    private static final int PNG_FILTER_AVERAGE = 3;
    private static final int PNG_FILTER_PAETH = 4;
    private static PNGPredictor predictor_NONE = new NonePredictor();
    private static PNGPredictor predictor_SUB = new SubPredictor();
    private static PNGPredictor predictor_UP = new UpPredictor();
    private static PNGPredictor predictor_AVERAGE = new AveragePredictor();
    private static PNGPredictor predictor_PAETH = new PaethPredictor();

    PNGPredictor() {
    }

    public abstract byte decode(int var1, int var2, byte[] var3, byte[] var4, int var5);

    public static PNGPredictor getPredictor(int n) throws ImageFormatException {
        switch (n) {
            case 0: {
                return predictor_NONE;
            }
            case 1: {
                return predictor_SUB;
            }
            case 2: {
                return predictor_UP;
            }
            case 3: {
                return predictor_AVERAGE;
            }
            case 4: {
                return predictor_PAETH;
            }
        }
        throw new ImageFormatException("Incorrect value for PNGPredictor filter type (" + n + ")");
    }

    public static class PaethPredictor
    extends PNGPredictor {
        int pred(int n, int n2, int n3) {
            int n4 = n + n2 - n3;
            int n5 = Math.abs(n4 - n);
            int n6 = Math.abs(n4 - n2);
            int n7 = Math.abs(n4 - n3);
            if (n5 <= n6 && n5 <= n7) {
                return n;
            }
            if (n6 <= n7) {
                return n2;
            }
            return n3;
        }

        public byte decode(int n, int n2, byte[] byArray, byte[] byArray2, int n3) {
            int n4 = n2 < n3 ? this.pred(0, byArray[n2] & 0xFF, 0) : this.pred(byArray2[n2 - n3] & 0xFF, byArray[n2] & 0xFF, byArray[n2 - n3] & 0xFF);
            return (byte)((n & 0xFF) + n4);
        }
    }

    public static class AveragePredictor
    extends PNGPredictor {
        public byte decode(int n, int n2, byte[] byArray, byte[] byArray2, int n3) {
            int n4 = byArray[n2] & 0xFF;
            if (n2 >= n3) {
                n4 += byArray2[n2 - n3] & 0xFF;
            }
            return (byte)((n & 0xFF) + (n4 >> 1));
        }
    }

    public static class UpPredictor
    extends PNGPredictor {
        public byte decode(int n, int n2, byte[] byArray, byte[] byArray2, int n3) {
            return (byte)((n & 0xFF) + (byArray[n2] & 0xFF));
        }
    }

    public static class SubPredictor
    extends PNGPredictor {
        public byte decode(int n, int n2, byte[] byArray, byte[] byArray2, int n3) {
            if (n2 < n3) {
                return (byte)n;
            }
            return (byte)((n & 0xFF) + (byArray2[n2 - n3] & 0xFF));
        }
    }

    public static class NonePredictor
    extends PNGPredictor {
        public byte decode(int n, int n2, byte[] byArray, byte[] byArray2, int n3) {
            return (byte)n;
        }
    }
}

