/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.fonts;

public class UsedGlyphs {
    protected byte[] usedGlyphs = new byte[8192];

    public UsedGlyphs() {
        this.clearGlyphs();
    }

    public void clearGlyphs() {
        int n = 0;
        while (n < this.usedGlyphs.length) {
            this.usedGlyphs[n] = 0;
            ++n;
        }
    }

    public void markGlyph(char c) {
        int n = (c & 0xFFFFFFF8) / 8;
        this.usedGlyphs[n] = (byte)(this.usedGlyphs[n] | 1 << (c & 7));
    }

    public boolean checkGlyph(char c) {
        return (this.usedGlyphs[(c & 0xFFFFFFF8) / 8] & 1 << (c & 7)) != 0;
    }
}

