package com.renderx.xepx.x4u.ct;

import javax.swing.border.*;
import java.awt.*;
import javax.swing.*;
import org.w3c.dom.*;
import java.util.*;
import javax.swing.table.*;
import javax.swing.event.*;
import java.awt.event.*;

/***************************************************************************
 * <p>Title: ConfFontAliases </p>
 * <p>Description: Creating JPanel for Font aliases with command buttons.
 *                 The Aliase's Table is created from parent DOM-node
 *
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: Zenteq.am</p>
 * @author: Boris Karapetyan
 * @version: 0.01
*  @todo
 **************************************************************************/

public class FontAliasesPanel extends JPanel{// implements TableModelListener{

  Node root = null;
  JTable aTable = null;
//  Vector colNames = new Vector(2) ;
  int currentRow = 0;

  public FontAliasesPanel(Node node) {
//    colNames.add("Alias"); colNames.add("Font Family");
    this.root = node;
    jbInit();
  }
 /* public FontAliasesPanel(Map mp) {
  this.map = mp;
  jbInit();
}*/

  private void jbInit() {    this.setBorder(new TitledBorder(BorderFactory.createLineBorder(Color.black,2),"Font Aliases"));
    this.setLayout(new BorderLayout());//borderLayout1);
    JPanel tablePanel = new JPanel(new GridLayout(1,1)); // Panel with ScrollPane for JTable
    JPanel commandPanel = new JPanel();
    this.add(tablePanel,  BorderLayout.CENTER);
    this.add(commandPanel,  BorderLayout.SOUTH);

    JScrollPane tableScrollPane = new JScrollPane();
    tablePanel.add(tableScrollPane, null);
    aTable = new JTable (new DomToTableModel((Element)root,false));
    TableColumn ffamilyColumn = aTable.getColumnModel().getColumn(1);
    JComboBox comboBox = new JComboBox(DOMWalker.getFonts());
    ffamilyColumn.setCellEditor(new DefaultCellEditor(comboBox));
    aTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    aTable.setSelectionBackground(Color.gray);
    aTable.setCellSelectionEnabled(true);
    aTable.setColumnSelectionAllowed(true);
//////////////    aTable.getModel().addTableModelListener(this);
    tableScrollPane.getViewport().add(aTable,null);
/*    aTable.addFocusListener(new java.awt.event.FocusAdapter() {
      public void focusLost(FocusEvent e) {
        aTable_focusLost(e);
      }
    });*/
// Enable after others buttons are pressed
    JButton deleteButton = new JButton("Delete alias");
    JButton addButton = new JButton("Add alias");
    addButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        addButton_actionPerformed(e);
      }
    });
    deleteButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        deleteButton_actionPerformed(e);
      }
    });

    commandPanel.add(addButton, null);
    commandPanel.add(deleteButton, null);
  }

  void addButton_actionPerformed(ActionEvent e) {
    DomToTableModel tm =  (DomToTableModel)aTable.getModel();
    Element tmp = root.getOwnerDocument().createElement("font-alias");
    tmp.setAttribute("name","Alias");
    tmp.setAttribute("value",DOMWalker.getFonts()[0]);//"font");

    root.appendChild(tmp);
    tm.addRow(tmp);
    currentRow = tm.getRowCount()-1;
  }

  void deleteButton_actionPerformed(ActionEvent e) {
    int row = aTable.getSelectedRow();
    if(row < 0) return; // IF table not selected !!!
    DomToTableModel tm = (DomToTableModel)aTable.getModel();
    Node tmp = (Element)tm.getNodeAt(row);
    root.removeChild(tmp);
    tm.deleteRow(row);
    currentRow = (currentRow==0)?0:currentRow-1;
  }
/*  void aTable_focusLost(FocusEvent e) {
        int row = aTable.getSelectedRow();
        DomToTableModel tm = (DomToTableModel)aTable.getModel();
        Element tmp = tm.getNodeAt(row);
//        tm.setValueAt(e.g);
////System.out.println("active row="+tm.getValueAt(row,0) + " MOD="+tmp.toString());
  }

 /* public void tableChanged(TableModelEvent e) {
    int row = e.getFirstRow();
    int column = e.getColumn();
    LngTableModel model = (LngTableModel)e.getSource();
    if(row < 0 || column < 0) return;
    currentRow = row;
    String columnName = model.getColumnName(column);
    Object data = model.getValueAt(row, column);
///////System.out.println("table CHANGED"+ e.getSource());
 }*/

}
