package com.renderx.xepx.x4u.as;

import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import javax.swing.border.*;

class SettingsPanel extends JDialog
{
	private Settings settings;	
	private JPanel stylesheetPanel;
	private JPanel outputFilePanel;
	private JPanel viewToolPanel;
	private JPanel buttonPanel;
	
	private JCheckBox applyStylesheet;
	private JTextField stylesheet;
	private JButton browseStylesheet;
	private JButton xslParameters;
	
	private JLabel formatLabel;
	private JComboBox format;
	private JLabel outputLabel;
	private JTextField output;
	private JButton browseOutput;
	private JCheckBox setRes;
	private JTextField res;
	private JButton browseRes;
	
	private JCheckBox display;
	private JTextField viewTool;
	private JButton browseviewTool;
	
	private JButton ok;
	private JButton cancel;
	
	boolean startFormatting = false;
	
	SettingsPanel(JFrame frame, Settings settings) {
		super(frame, "Formatting settings", true);		
		
		this.settings = settings;
		Listener listener = new Listener();
		
		stylesheetPanel = new JPanel();
		outputFilePanel = new JPanel();
		viewToolPanel = new JPanel();
		buttonPanel = new JPanel();
		
		applyStylesheet = new JCheckBox("Apply stylesheet");
		stylesheet = new JTextField(settings.stylesheet,24);
		stylesheet.setHorizontalAlignment(JTextField.LEFT);
		browseStylesheet = new JButton("Browse");
		xslParameters = new JButton("Transformation parameters");
		
		formatLabel = new JLabel("Format", JLabel.RIGHT);
		format = new JComboBox(new String[] {"pdf", "ps", "afp", "svg", "html", "xps", "ppml"});
		outputLabel=new JLabel("Output File", JLabel.RIGHT);
		output = new JTextField(settings.result,24);
		output.setHorizontalAlignment(JTextField.LEFT);
		browseOutput = new JButton("Browse");
		res = new JTextField(settings.afpRes, 24);
		browseRes = new JButton("Browse");
		setRes = new JCheckBox("Use Custom Resource");
		res.setHorizontalAlignment(JTextField.LEFT);
		
		
		display = new JCheckBox("Display with");
		viewTool = new JTextField(settings.viewer,24);
		viewTool.setHorizontalAlignment(JTextField.LEFT);
		browseviewTool = new JButton("Browse");
		
		ok = new JButton("OK");
		getRootPane().setDefaultButton(ok);
		cancel = new JButton("Cancel");
		
		applyStylesheet.setSelected(settings.transform);
		stylesheet.setText(settings.stylesheet); 
		stylesheet.setEnabled(settings.transform);
		browseStylesheet.setEnabled(settings.transform);
		xslParameters.setEnabled(settings.transform);
		
		format.setSelectedItem(settings.format);
		display.setSelected(settings.preview);
		viewTool.setEnabled(settings.preview);
		viewTool.setText(settings.viewer);
		browseviewTool.setEnabled(settings.preview);

		if (settings.format.equalsIgnoreCase("afp")) {
			setRes.setSelected(settings.setRes);
			setRes.setEnabled(true);
			res.setEnabled(settings.setRes);
			browseRes.setEnabled(settings.setRes);
		} else {
			setRes.setSelected(false);
			setRes.setEnabled(false);
			res.setEnabled(settings.setRes);
			browseRes.setEnabled(settings.setRes);
		}
		
		applyStylesheet.setActionCommand("TRANSFORM");
		browseStylesheet.setActionCommand("BROWSE_STYLESHEET");
		xslParameters.setActionCommand("XSL_PARAMS");
		format.setActionCommand("FORMAT");
		browseOutput.setActionCommand("BROWSE_OUTPUT");
		browseRes.setActionCommand("BROWSE_RESOURCE");
		display.setActionCommand("DISPLAY");
		setRes.setActionCommand("SET_RESOURCE");
		browseviewTool.setActionCommand("BROWSE_VIEWER");
		ok.setActionCommand("OK");
		cancel.setActionCommand("CANCEL");
		
		applyStylesheet.addActionListener(listener);
		browseStylesheet.addActionListener(listener);
		xslParameters.addActionListener(listener);
		format.addActionListener(listener);
		browseOutput.addActionListener(listener);
		browseRes.addActionListener(listener);
		display.addActionListener(listener);
		setRes.addActionListener(listener);
		browseviewTool.addActionListener(listener);
		ok.addActionListener(listener);
		cancel.addActionListener(listener);
		
		GridBagLayout gridbag = new GridBagLayout();
		GridBagConstraints 
			buttonConstraints = new GridBagConstraints(),
			textFieldConstraints = new GridBagConstraints(),
			labelConstraints = new GridBagConstraints(),
			c = new GridBagConstraints();
		//Apply stylesheet panel		
		stylesheetPanel.setLayout(gridbag);
		stylesheetPanel.setBorder(new TitledBorder("Stylesheet"));
		
		buttonConstraints.anchor = GridBagConstraints.CENTER;
		buttonConstraints.fill = GridBagConstraints.HORIZONTAL; 
		buttonConstraints.insets = new Insets(10,5,10,5);

		textFieldConstraints.anchor = GridBagConstraints.CENTER;
		textFieldConstraints.fill = GridBagConstraints.HORIZONTAL; 
		textFieldConstraints.insets = new Insets(10,5,10,5);
		
		buttonConstraints.weightx = 0.0; 
		buttonConstraints.weighty =0.0;
		buttonConstraints.gridy = 0;
		buttonConstraints.gridx = 0; 
		stylesheetPanel.add(applyStylesheet, buttonConstraints);
		
		textFieldConstraints.gridx = 1;
		textFieldConstraints.weightx = 1.0;
		stylesheetPanel.add(stylesheet, textFieldConstraints);
		
		buttonConstraints.gridx = 2; 
		buttonConstraints.weightx = 0.0;
		stylesheetPanel.add(browseStylesheet, buttonConstraints);
		
		buttonConstraints.fill = GridBagConstraints.NONE;
		buttonConstraints.gridy = 1; 
		buttonConstraints.gridx = 1;
		
		gridbag.setConstraints(xslParameters, buttonConstraints);
		stylesheetPanel.add(xslParameters);
		
		//Output File panel
		outputFilePanel.setLayout(gridbag);
		outputFilePanel.setBorder(new TitledBorder("Output"));
		labelConstraints.anchor = GridBagConstraints.CENTER;
		labelConstraints.fill = GridBagConstraints.NONE; 
		labelConstraints.insets = new Insets(10,5,10,5);
		labelConstraints.weightx = 1.0; 
		labelConstraints.weighty = 0.0;
		labelConstraints.gridwidth = 1;
		labelConstraints.gridy = 0;
		labelConstraints.gridx = 0; 
		outputFilePanel.add(formatLabel, labelConstraints);
		
		labelConstraints.weightx = 1.0;
		labelConstraints.gridwidth = 1;
		labelConstraints.gridx = 1; 
		outputFilePanel.add(format, labelConstraints);
		
		labelConstraints.fill = GridBagConstraints.HORIZONTAL;
		labelConstraints.weightx = 2.0;
		labelConstraints.weighty = 1.0;
		labelConstraints.gridwidth = 2;
		labelConstraints.gridx = 0; 
		labelConstraints.gridy = 1;
		outputFilePanel.add(outputLabel, labelConstraints);
		
		textFieldConstraints.weightx = 2.0;
		labelConstraints.gridwidth = 2;
		textFieldConstraints.gridx = 2;
		textFieldConstraints.gridy = 1;
		outputFilePanel.add(output, textFieldConstraints);
		
		textFieldConstraints.weightx = 1.0;
		labelConstraints.gridwidth = 1;
		buttonConstraints.gridx = 4; 
		textFieldConstraints.gridy = 1;
		outputFilePanel.add(browseOutput, buttonConstraints);

		//labelConstraints.fill = GridBagConstraints.EAST;
		labelConstraints.weighty = 2.0;
		labelConstraints.gridwidth = 2;
		labelConstraints.gridy = 2;
		labelConstraints.gridx = 0; 
		outputFilePanel.add(setRes, labelConstraints);
		
		textFieldConstraints.weightx = 2.0;
		labelConstraints.gridwidth = 2;
		textFieldConstraints.gridy = 2;
		textFieldConstraints.gridx = 2;
		outputFilePanel.add(res, textFieldConstraints);
		
		textFieldConstraints.weightx = 1.0;
		labelConstraints.gridwidth = 1;
		buttonConstraints.gridy = 2;
		buttonConstraints.gridx = 4;
		outputFilePanel.add(browseRes, buttonConstraints);
		
	
		//Preview Tool panel
		viewToolPanel.setLayout(gridbag);
		viewToolPanel.setBorder(new TitledBorder("Viewer"));
		
		buttonConstraints.gridy = 0;
		buttonConstraints.gridx = 0; 
		viewToolPanel.add(display, buttonConstraints);
		
		textFieldConstraints.gridx = 1;
		textFieldConstraints.gridy = 0;
		viewToolPanel.add(viewTool, textFieldConstraints);
		
		buttonConstraints.gridx = 2;
		buttonConstraints.weightx = 0.0;
		viewToolPanel.add(browseviewTool, buttonConstraints);

		//Button's panel
		buttonPanel.setLayout(gridbag);
		buttonConstraints.gridx = 0; buttonConstraints.gridy = 0;	
		buttonPanel.add(ok, buttonConstraints);
		buttonConstraints.gridx = 1; buttonConstraints.gridy = 0;	
		buttonPanel.add(cancel, buttonConstraints);
		
	  // main panel
		Container mainPanel = getContentPane();
		mainPanel.setLayout(gridbag);
		c.anchor = GridBagConstraints.CENTER;
		c.fill = GridBagConstraints.BOTH; c.insets = new Insets(5,0,5,0);
		c.weightx = 0.0; c.weighty = 0.0;
		c.gridx = 0;
		c.gridy = 0; mainPanel.add(stylesheetPanel, c);
		c.gridy = 1; mainPanel.add(outputFilePanel, c);
		c.gridy = 2; mainPanel.add(viewToolPanel, c);
		c.gridy = 3; mainPanel.add(buttonPanel, c);
		
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		Dimension frameSize = frame.getSize();
		if (frameSize.height > screenSize.height) 
		{
			frameSize.height = screenSize.height;
		}
		if (frameSize.width > screenSize.width) 
		{
			frameSize.width = screenSize.width;
		}
		setLocation((screenSize.width-frameSize.width)/2,
			(screenSize.height-frameSize.height)/2);
		setSize(600,520);
		validate();
		setVisible(true);
  }
    
  class Listener implements ActionListener {
		void start() {	
			settings.transform = applyStylesheet.isSelected();
			settings.stylesheet = stylesheet.getText();
			settings.format = (String)format.getSelectedItem();
			settings.preview = display.isSelected();
			settings.viewer = viewTool.getText();
			settings.result = output.getText();
			settings.afpRes = res.getText();
			settings.setRes = setRes.isSelected();
			SettingsPanel.this.dispose();
			/*try {
				settings.save();
			} catch(Exception ex) {
				JOptionPane.showMessageDialog(SettingsPanel.this,
					"Could not save settings for future runs:\n"+ex.getMessage(),
					"Error", JOptionPane.OK_OPTION);
			}*/
				startFormatting = true;
		}			
		public void actionPerformed(ActionEvent e) {
			String command = e.getActionCommand();
			if(command.equals("TRANSFORM")) {
				stylesheet.setEnabled(applyStylesheet.isSelected());
				browseStylesheet.setEnabled(applyStylesheet.isSelected());
				xslParameters.setEnabled(applyStylesheet.isSelected());
			} else if(command.equals("BROWSE_STYLESHEET") ) {
				FileChooser filechooser = new FileChooser(settings.source, new String[] {"xsl"});
				
				if	(filechooser.showOpenDialog(SettingsPanel.this)==JFileChooser.APPROVE_OPTION)					
					stylesheet.setText(filechooser.getSelectedFile().getAbsolutePath());
				
			} else if(command.equals("XSL_PARAMS") ) {
				XSLParamTable table = new XSLParamTable(SettingsPanel.this, settings); 
			} else if(command.equals("FORMAT") ) {
				String outputFile = output.getText();
				String type = (String)format.getSelectedItem();
				output.setText(Util.replext(outputFile, type));
				if (type.equals("pdf")) {
					display.setSelected(true);
					settings.preview = true;
					browseviewTool.setEnabled(display.isSelected());
					viewTool.setEnabled(display.isSelected());
					setRes.setSelected(false);
					setRes.setEnabled(false);
					settings.setRes = false;
					res.setEnabled(setRes.isSelected());
					browseRes.setEnabled(setRes.isSelected());
				} else if (type.equals("afp")){
					display.setSelected(false);
					settings.preview = false;
					browseviewTool.setEnabled(display.isSelected());
					viewTool.setEnabled(display.isSelected());
					setRes.setEnabled(true);
					settings.setRes = false;
					res.setEnabled(setRes.isSelected());
					browseRes.setEnabled(setRes.isSelected());
					res.setText(Util.replext(outputFile, "res"));					
				} else {
					display.setSelected(false);
					settings.preview = false;
					browseviewTool.setEnabled(display.isSelected());
					viewTool.setEnabled(display.isSelected());
					setRes.setSelected(false);
					settings.setRes = false;
					res.setEnabled(setRes.isSelected());
					browseRes.setEnabled(setRes.isSelected());
					setRes.setEnabled(false);
				}
			}	else if(command.equals("SET_RESOURCE") ) {
				res.setEnabled(setRes.isSelected());
				browseRes.setEnabled(setRes.isSelected());							
			} else if(command.equals("BROWSE_OUTPUT") ) {
				String type = (String)format.getSelectedItem();
				FileChooser filechooser= new FileChooser(output.getText(), new String [] {type});
				if(filechooser.showSaveDialog(SettingsPanel.this) == JFileChooser.APPROVE_OPTION)
				{	
					String outputFile = filechooser.getSelectedFile().getAbsolutePath();
					if(!outputFile.endsWith("."+type))
						outputFile+="."+type;
					output.setText(outputFile);
				}
			} else if(command.equals("BROWSE_RESOURCE") ) {
				String type = "res";
				FileChooser filechooser= new FileChooser(res.getText(), new String [] {type});
				if(filechooser.showSaveDialog(SettingsPanel.this) == JFileChooser.APPROVE_OPTION)
				{	
					String resFile = filechooser.getSelectedFile().getAbsolutePath();
					if(!resFile.endsWith("."+type))
						resFile+="."+type;
					res.setText(resFile);
				}
			} else if(command.equals("DISPLAY") ) {
				browseviewTool.setEnabled(display.isSelected());
				viewTool.setEnabled(display.isSelected());
			} else if(command.equals("BROWSE_VIEWER") ) {
				FileChooser filechooser = new FileChooser(viewTool.getText(), null);
				if(filechooser.showOpenDialog(SettingsPanel.this) == JFileChooser.APPROVE_OPTION)
					viewTool.setText(filechooser.getSelectedFile().getAbsolutePath());
			} else if(command.equals("OK") ) {
				java.io.File outputFile = new java.io.File(output.getText());
				if (outputFile.exists()) {
					try {
						outputFile.renameTo(new java.io.File(Util.replext(output.getText(), "bak")));
					} catch(Exception ex){
						JOptionPane.showMessageDialog(SettingsPanel.this,
						"Could not save old file to "+Util.replext(output.getText(), "bak")+":\n"+ex.getMessage(),
						"Error", JOptionPane.OK_OPTION);						
					}
					/*int value = JOptionPane.showConfirmDialog(SettingsPanel.this,
						"The file "+output.getText()+" already exists.\n"+"Are you sure that you want to overwrite it?",
						"File Exists", JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE);
					if (value == JOptionPane.NO_OPTION) 
						return;*/
				}
				start();
			} else if(command.equals("CANCEL") ) {
				SettingsPanel.this.dispose();
			}
		}
  }
}
