/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xepx.ant;

import com.renderx.sax.XMLReaderFactory;
import com.renderx.util.URLSpec;
import com.renderx.xep.FOTarget;
import com.renderx.xep.FOTransformer;
import com.renderx.xep.Formatter;
import com.renderx.xep.FormatterImpl;
import com.renderx.xep.lib.ConfigurationException;
import com.renderx.xepx.ant.Param;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XSLEngine {
    private static final Hashtable formats = new Hashtable();
    private FOTransformer transformer = null;
    private long styleLM = 0L;
    private FormatterImpl formatter;
    private String outputFormat = null;

    public XSLEngine() throws ConfigurationException {
        this.formatter = new FormatterImpl();
    }

    public XSLEngine(Properties properties) throws ConfigurationException {
        this.formatter = new FormatterImpl(properties);
    }

    public void cleanup() {
        this.formatter.cleanup();
    }

    public String createTransformer(String string, Vector vector, String string2) throws FileNotFoundException, MalformedURLException, SAXException, TransformerConfigurationException {
        if (!formats.containsKey(string2)) {
            throw new RuntimeException("unknown output format '" + string2 + "'");
        }
        this.outputFormat = (String)formats.get(string2);
        this.styleLM = 0L;
        if (string != null) {
            File file = new File(string);
            if (file.exists()) {
                this.styleLM = file.lastModified();
            }
            SAXSource sAXSource = new SAXSource(XMLReaderFactory.createXMLReader(), new InputSource(new URLSpec(string).toString()));
            this.transformer = new FOTransformer((Source)sAXSource, (Formatter)this.formatter);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Param param = (Param)enumeration.nextElement();
                this.transformer.setParameter(param.name, (Object)param.value);
            }
        } else {
            this.transformer = new FOTransformer((Formatter)this.formatter);
        }
        return this.outputFormat;
    }

    public void process(File file, File file2, boolean bl) throws Exception {
        if (bl || file.lastModified() > file2.lastModified() || this.styleLM > file2.lastModified()) {
            this.makeDir(file2);
            FilterOutputStream filterOutputStream = null;
            SAXSource sAXSource = null;
            InputSource inputSource = new InputSource(new URLSpec(file.toURL().toString()).toString());
            sAXSource = new SAXSource(XMLReaderFactory.createXMLReader(), inputSource);
            try {
                filterOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                FOTarget fOTarget = new FOTarget((OutputStream)filterOutputStream, this.outputFormat);
                this.transformer.transform((Source)sAXSource, fOTarget);
            }
            catch (Exception exception) {
                filterOutputStream.close();
                file2.delete();
                throw exception;
            }
            filterOutputStream.close();
        }
    }

    private void makeDir(File file) throws IOException, SecurityException {
        String string = file.getParent();
        if (string == null || !new File(string).isDirectory() && !new File(string).mkdirs()) {
            throw new IOException("directory '" + string + "' for target file '" + file + "' cannot be created");
        }
    }

    private static URL toURL(File file) throws MalformedURLException {
        String string = file.getAbsolutePath().replace(File.separatorChar, '/');
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (file.isDirectory() && !string.endsWith("/")) {
            string = string + "/";
        }
        return new URL("file", "", string);
    }

    static {
        formats.put("PDF", "pdf");
        formats.put("PostScript", "ps");
        formats.put("XEP", "xep");
    }
}

