/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep;

import com.renderx.sax.JAXPSourceConverter;
import com.renderx.xep.FOTarget;
import com.renderx.xep.Formatter;
import com.renderx.xep.FormatterCore;
import com.renderx.xep.lib.Conf;
import com.renderx.xep.lib.ConfigurationException;
import com.renderx.xep.lib.DefaultLogger;
import com.renderx.xep.lib.Logger;
import java.io.IOException;
import java.util.Properties;
import javax.xml.transform.Source;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class FormatterImpl
implements Formatter {
    private final FormatterCore core;

    public FormatterImpl() throws ConfigurationException {
        this(new Properties());
    }

    public FormatterImpl(Logger logger) throws ConfigurationException {
        this(new Properties(), logger);
    }

    public FormatterImpl(Properties properties) throws ConfigurationException {
        this(properties, (Logger)new DefaultLogger());
    }

    public FormatterImpl(Properties properties, Logger logger) throws ConfigurationException {
        this(new Conf(properties, logger));
    }

    public FormatterImpl(Source source) throws ConfigurationException {
        this(source, new Properties());
    }

    public FormatterImpl(Source source, Logger logger) throws ConfigurationException {
        this(source, new Properties(), logger);
    }

    public FormatterImpl(Source source, Properties properties) throws ConfigurationException {
        this(source, properties, new DefaultLogger());
    }

    public FormatterImpl(Source source, Properties properties, Logger logger) throws ConfigurationException {
        this(FormatterImpl.createConfig(source, properties, logger));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Conf createConfig(Source source, Properties properties, Logger logger) throws ConfigurationException {
        try {
            Conf conf;
            JAXPSourceConverter jAXPSourceConverter = new JAXPSourceConverter(source);
            try {
                conf = new Conf(jAXPSourceConverter.source, jAXPSourceConverter.parser, properties, logger);
                Object var6_7 = null;
                if (jAXPSourceConverter.stream == null) return conf;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (jAXPSourceConverter.stream == null) throw throwable;
                jAXPSourceConverter.stream.close();
                throw throwable;
            }
            jAXPSourceConverter.stream.close();
            return conf;
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException);
        }
        catch (SAXException sAXException) {
            throw new ConfigurationException(sAXException);
        }
    }

    protected FormatterImpl(Conf conf) throws ConfigurationException {
        this.core = new FormatterCore(conf);
    }

    public void cleanup() {
        this.core.cleanup();
    }

    public void render(Source source, FOTarget fOTarget) throws SAXException, IOException {
        this.render(source, fOTarget, this.core.config.logger);
    }

    public void render(Source source, FOTarget fOTarget, Logger logger) throws SAXException, IOException {
        this.render(source, this.createGenerator(fOTarget, logger), logger);
    }

    public ContentHandler createContentHandler(String string, FOTarget fOTarget) throws ConfigurationException {
        return this.createContentHandler(string, fOTarget, this.core.config.logger);
    }

    public ContentHandler createContentHandler(String string, FOTarget fOTarget, Logger logger) throws ConfigurationException {
        return this.createContentHandler(string, this.createGenerator(fOTarget, logger), logger);
    }

    public void render(Source source, ContentHandler contentHandler) throws SAXException, IOException {
        this.render(source, contentHandler, this.core.config.logger);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void render(Source source, ContentHandler contentHandler, Logger logger) throws SAXException, IOException {
        JAXPSourceConverter jAXPSourceConverter = new JAXPSourceConverter(source);
        try {
            this.core.render(jAXPSourceConverter.source, jAXPSourceConverter.parser, contentHandler, logger);
            Object var6_5 = null;
            if (jAXPSourceConverter.stream == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (jAXPSourceConverter.stream == null) throw throwable;
            jAXPSourceConverter.stream.close();
            throw throwable;
        }
        jAXPSourceConverter.stream.close();
    }

    public ContentHandler createContentHandler(String string, ContentHandler contentHandler) throws ConfigurationException {
        return this.createContentHandler(string, contentHandler, this.core.config.logger);
    }

    public ContentHandler createContentHandler(String string, ContentHandler contentHandler, Logger logger) throws ConfigurationException {
        return this.core.createContentHandler(string, contentHandler, logger);
    }

    public ContentHandler createGenerator(FOTarget fOTarget) throws ConfigurationException {
        return this.createGenerator(fOTarget, this.core.config.logger);
    }

    public ContentHandler createGenerator(FOTarget fOTarget, Logger logger) throws ConfigurationException {
        return this.core.createGenerator(fOTarget.stream, fOTarget.format, fOTarget.options, logger);
    }
}

