/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.util;

import com.renderx.sax.InputSource;
import com.renderx.sax.XMLReaderFactory;
import com.renderx.util.Hashtable;
import com.renderx.util.List;
import com.renderx.util.SeekableFileInputStream;
import com.renderx.util.SeekableInput;
import com.renderx.util.Stack;
import com.renderx.util.User;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class Magic {
    private static List magdir = new List();
    private static Hashtable extab = new Hashtable();
    private static boolean initialized = false;

    public static synchronized void init() {
        if (!initialized) {
            String string = User.getProperty("com.renderx.util.magic");
            if (string == null) {
                string = "resource:com/renderx/util/magic.xml";
            }
            try {
                XMLReader xMLReader = XMLReaderFactory.createXMLReader();
                xMLReader.setContentHandler(new Config());
                xMLReader.parse(new InputSource(string));
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException("error initializing com.renderx.util.Magic:" + exception.toString());
            }
            initialized = true;
        }
    }

    private static boolean matches(SeekableInput seekableInput, List list) {
        if (list.isEmpty()) {
            return true;
        }
        Enumeration enumeration = list.elements();
        block2: while (enumeration.hasMoreElements()) {
            Check check = (Check)enumeration.nextElement();
            byte[] byArray = new byte[check.bytes.length];
            try {
                seekableInput.seek(check.offset);
                seekableInput.readFully(byArray);
            }
            catch (IOException iOException) {
                continue;
            }
            int n = 0;
            while (n != byArray.length) {
                if (byArray[n] != check.bytes[n]) continue block2;
                ++n;
            }
            return Magic.matches(seekableInput, check.checklist);
        }
        return false;
    }

    public static String MIME(String string, SeekableInput seekableInput) throws IOException, UnknownMIMETypeException {
        int n = string.lastIndexOf(46);
        String string2 = n != -1 ? string.substring(++n, string.length()).toLowerCase() : "";
        Entry entry = (Entry)extab.get(string2);
        String string3 = null;
        if (entry != null) {
            if (Magic.matches(seekableInput, entry.checklist)) {
                return entry.mimetype;
            }
            string3 = entry.mimetype;
        }
        Enumeration enumeration = magdir.elements();
        while (enumeration.hasMoreElements()) {
            entry = (Entry)enumeration.nextElement();
            if (!Magic.matches(seekableInput, entry.checklist)) continue;
            return entry.mimetype;
        }
        if (string3 != null) {
            return string3;
        }
        throw new UnknownMIMETypeException(string);
    }

    public static void main(String[] stringArray) {
        Magic.init();
        int n = 0;
        while (n != stringArray.length) {
            String string = stringArray[n];
            try {
                System.out.println(string + ": " + Magic.MIME(string, new SeekableFileInputStream(string)));
            }
            catch (Exception exception) {
                System.err.println("error processing " + string + ": " + exception);
            }
            ++n;
        }
    }

    private static class Config
    extends DefaultHandler {
        private static final String uri = "http://www.renderx.com/util/magic";
        private Stack clstack = new Stack();
        private List checklist = null;

        private Config() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if ("".equals(string) || uri.equals(string)) {
                if (string2.equals("entry")) {
                    Entry entry = new Entry(attributes.getValue("mime-type"));
                    magdir.snoc(entry);
                    this.checklist = entry.checklist;
                    String string4 = attributes.getValue("extensions");
                    if (string4 != null) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
                        while (stringTokenizer.hasMoreTokens()) {
                            extab.put(stringTokenizer.nextToken().trim().toLowerCase(), entry);
                        }
                    }
                } else if (string2.equals("match")) {
                    Check check = new Check();
                    check.offset = Long.parseLong(attributes.getValue("offset"));
                    String string5 = attributes.getValue("bytes");
                    if (string5 != null) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string5, ",");
                        check.bytes = new byte[stringTokenizer.countTokens()];
                        int n = 0;
                        while (n != check.bytes.length) {
                            check.bytes[n] = Short.decode(stringTokenizer.nextToken()).byteValue();
                            ++n;
                        }
                    } else {
                        String string6 = attributes.getValue("string");
                        if (string6 != null) {
                            check.bytes = string6.getBytes();
                        } else {
                            throw new SAXException("either string or bytes must be specified for each match");
                        }
                    }
                    this.checklist.snoc(check);
                    this.clstack.push(this.checklist);
                    this.checklist = check.checklist;
                } else if (!string2.equals("magic")) {
                    throw new SAXException("unexpected element: '" + string2 + "'");
                }
            }
        }

        public void endElement(String string, String string2, String string3) {
            if ("".equals(string) || uri.equals(string)) {
                if (string2.equals("format")) {
                    this.checklist = null;
                } else if (string2.equals("match")) {
                    this.checklist = (List)this.clstack.pop();
                }
            }
        }
    }

    private static class Check {
        long offset;
        byte[] bytes;
        List checklist = new List();

        private Check() {
        }
    }

    private static class Entry {
        String mimetype;
        List checklist = new List();

        Entry(String string) {
            this.mimetype = string;
        }
    }

    public static class UnknownMIMETypeException
    extends Exception {
        public String path;

        public UnknownMIMETypeException() {
        }

        public UnknownMIMETypeException(String string) {
            super("cannot determine mime type for file '" + string + "'");
            this.path = string;
        }
    }
}

