/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.PDFDocument;
import com.renderx.pdflib.PDFObject;
import com.renderx.pdflib.PDFOutputStream;
import com.renderx.pdflib.Resources;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class AppearanceStream
extends PDFObject {
    private final float[] bbox;
    private IndirectObject length_id;
    private int length;
    Resources formResources = null;
    private ByteArrayOutputStream accumulator = null;
    PDFOutputStream contentStream = null;
    boolean initiallySelected = true;
    String streamName;

    AppearanceStream(IndirectObject indirectObject, float[] fArray, PDFDocument pDFDocument) {
        super(indirectObject);
        this.bbox = fArray;
        this.accumulator = new ByteArrayOutputStream(128);
        try {
            this.contentStream = new PDFOutputStream(this.accumulator, pDFDocument);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    String getType() {
        return "XObject";
    }

    void writeBody(PDFOutputStream pDFOutputStream) {
        pDFOutputStream.println("/Subtype/Form");
        this.length_id = pDFOutputStream.getNextID();
        pDFOutputStream.println("/BBox [0 0 " + PDFOutputStream.pdf_float(this.bbox[2] - this.bbox[0]) + " " + PDFOutputStream.pdf_float(this.bbox[3] - this.bbox[1]) + "]");
        pDFOutputStream.println("/Matrix [1 0 0 1 0 0]");
        pDFOutputStream.println("/Length " + this.length_id.toStringR());
        pDFOutputStream.println("/Resources " + this.formResources.getID().toStringR());
        if (pDFOutputStream.compression) {
            pDFOutputStream.println("/Filter /FlateDecode");
        }
        pDFOutputStream.println(">>");
        pDFOutputStream.println("stream");
        int n = pDFOutputStream.size();
        pDFOutputStream.startStream();
        try {
            this.accumulator.writeTo(pDFOutputStream);
            this.accumulator.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        pDFOutputStream.finishStream();
        this.length = pDFOutputStream.size() - n;
        pDFOutputStream.println("\nendstream");
        pDFOutputStream.println("endobj");
        pDFOutputStream.doc.currentResources = null;
    }

    void writeSubObjects(PDFOutputStream pDFOutputStream) {
        pDFOutputStream.printLength(this.length_id, this.length);
        this.formResources.write(pDFOutputStream);
    }
}

