/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.afplib.orders;

import com.renderx.afplib.AFP;
import com.renderx.afplib.AFPException;
import com.renderx.afplib.AFPInternalException;
import com.renderx.afplib.Point2D;
import com.renderx.afplib.orders.ModcaOrders;
import com.renderx.afplib.orders.Orders;
import com.renderx.graphics.Image;
import com.renderx.util.ErrorHandler;
import com.renderx.xep.pre.Attr;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class GocaOrders
extends Orders {
    public static final short GDD_ORDER_SUBDET = 247;
    public static final short WINDOW_SPECIFICATION = 246;
    public static final short GEAR_ORDER_CODE = 96;
    public static final short GBAR_ORDER_CODE = 104;
    public static final short GFLT_ORDER_CODE = 197;
    public static final short GLINE_ORDER_CODE = 193;
    public static final short GSAP_ORDER_CODE = 34;
    public static final short GFARC_ORDER_CODE = 199;
    public static final short GSLW_ORDER_CODE = 25;
    public static final short END_SEGMENT_ORDER_CODE = 113;
    public static final short BSI_ORDER_CODE = 112;
    public static final short GSCECOL_ORDER_CODE = 38;
    public static final short GSPCOL_ORDER_CODE = 178;
    public static final short CHST_ORDER_CODE = 195;
    public static final short GBOX_ORDER_CODE = 192;
    public static final short GSCC_ORDER_CODE = 51;
    public static final short GSCS_ORDER_CODE = 56;
    public static final short GSCR_ORDER_CODE = 57;
    public static final short GSCA_ORDER_CODE = 52;
    private Attr.Color currentColor = null;
    private ModcaOrders modcaOrders = null;
    public static final short GSCR_MODE_DRAWING_DEFAUT = 0;
    public static final short GSCR_MODE_STRING_PRECISION = 1;
    public static final short GSCR_MODE_CHARACTER_PRECCISON = 2;
    String nameGocaSegment;

    public GocaOrders(AFP aFP, ErrorHandler errorHandler) {
        super(aFP, errorHandler);
        this.resetColor();
        this.modcaOrders = new ModcaOrders(aFP, errorHandler);
    }

    public void writeTextGivenPosition(Point2D point2D, String string) throws AFPInternalException {
        if (!this.isValidPoints(new Point2D[]{point2D})) {
            return;
        }
        this.afp.writeByte(195);
        this.afp.writeByte(4 + string.length());
        this.afp.writePoint2bytes(point2D);
        try {
            this.afp.writeText(string);
        }
        catch (AFPException aFPException) {
            this.logger.error(aFPException.toString());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.logger.error(unsupportedEncodingException.toString());
        }
    }

    public void writeGSCC_SetCharacterCell(double d) throws AFPInternalException {
        this.afp.writeByte(51);
        this.afp.writeByte(4);
        this.afp.writeByte((int)d);
        this.afp.writeByte((int)d);
    }

    public void writeGSCS_SetCharacterSet(int n) throws AFPInternalException {
        this.afp.writeByte(56);
        this.afp.writeByte(n);
    }

    public void writeGSCR_SetCharacterPrecision(int n) throws AFPInternalException {
        this.afp.writeByte(57);
        this.afp.writeByte(n);
    }

    public void writeGSCA_SetCharacterAngle(int n) throws AFPInternalException {
        this.afp.writeByte(52);
        this.afp.writeByte(4);
        int n2 = 0;
        int n3 = 0;
        if (n == 0) {
            n2 = 10;
        } else if (n == 90) {
            n3 = 10;
        } else if (n == 180) {
            n2 = -10;
        } else if (n == 270) {
            n3 = -10;
        } else {
            this.logger.warning("This angle not support: " + n);
            n2 = 10;
        }
        this.afp.writeShort(n2);
        this.afp.writeShort(n3);
    }

    public void writeGBOX_Box(Point2D point2D, Point2D point2D2) throws AFPInternalException {
        if (!this.isValidPoints(new Point2D[]{point2D, point2D2})) {
            return;
        }
        this.writeGBAR_BeginArea();
        this.afp.writeByte(192);
        this.afp.writeFlagsInByte(new boolean[]{false, false, true, false, false, false, false});
        this.afp.writePoint2bytes(point2D);
        this.afp.writePoint2bytes(point2D2);
        this.writeGEAR_EndArea();
    }

    public void writeGBAR_BeginArea() throws AFPInternalException {
        this.afp.writeByte(104);
        this.afp.writeByte(1);
    }

    public void writeGEAR_EndArea() throws AFPInternalException {
        this.afp.writeByte(96);
        this.afp.writeByte(0);
    }

    public void writeCurveLine(Point2D point2D, Point2D point2D2, Point2D[] point2DArray) throws AFPInternalException {
        if (!this.isValidPoints(new Point2D[]{point2D, point2D2}) || !this.isValidPoints(point2DArray)) {
            return;
        }
        int n = (point2DArray.length + 2) * 4;
        this.afp.writeByte(197);
        this.afp.writeByte(n);
        this.afp.writePoint2bytes(point2D);
        for (int i = 0; i < point2DArray.length; ++i) {
            this.afp.writePoint2bytes(point2DArray[i]);
        }
        this.afp.writePoint2bytes(point2D2);
    }

    public void writeGLINE_LineGivenPosition(Point2D[] point2DArray) throws AFPInternalException {
        int n = point2DArray.length - 1;
        if (!this.isValidPoints(point2DArray)) {
            return;
        }
        this.afp.writeByte(193);
        this.afp.writeByte(point2DArray.length * 4);
        this.afp.writeShort(point2DArray[0].x);
        this.afp.writeShort(point2DArray[0].y);
        for (int i = 1; i < n; ++i) {
            this.afp.writeShort(point2DArray[i].x);
            this.afp.writeShort(point2DArray[i].y);
        }
        this.afp.writeShort(point2DArray[n].x);
        this.afp.writeShort(point2DArray[n].y);
    }

    public void writeGSAP_SetArcParameters(Point2D point2D, Point2D point2D2, Point2D point2D3) throws AFPInternalException {
        if (!this.isValidPoints(new Point2D[]{point2D, point2D2, point2D3})) {
            return;
        }
        int n = (int)Math.round(Math.sqrt(Math.pow(point2D3.x - point2D.x, 2.0) + Math.pow(point2D3.y - point2D.y, 2.0)));
        int n2 = (int)Math.round(Math.sqrt(Math.pow(point2D3.x - point2D2.x, 2.0) + Math.pow(point2D3.y - point2D2.y, 2.0)));
        double d = (double)Math.abs(point2D3.x - point2D.x) / (double)n;
        double d2 = (double)Math.abs(point2D3.y - point2D.y) / (double)n;
        this.afp.writeByte(34);
        this.afp.writeByte(8);
        this.afp.writeShort((int)Math.round((double)n * d));
        this.afp.writeShort((int)Math.round((double)n2 * d));
        if (point2D3.x < point2D.x && point2D3.y > point2D.y || point2D3.x > point2D.x && point2D3.y < point2D.y) {
            this.afp.writeShort((int)Math.round((double)n2 * d2));
            this.afp.writeShort((int)Math.round((double)(-n) * d2));
        } else {
            this.afp.writeShort((int)Math.round((double)(-n2) * d2));
            this.afp.writeShort((int)Math.round((double)n * d2));
        }
    }

    public void writeGFARC_FullArc(Point2D point2D) throws AFPInternalException {
        if (!this.isValidPoints(new Point2D[]{point2D})) {
            return;
        }
        this.afp.writeByte(199);
        this.afp.writeByte(6);
        this.afp.writePoint2bytes(point2D);
        this.afp.writeByte(1);
        this.afp.writeByte(0);
    }

    public void writeSF_GDD(Point2D point2D) throws IOException, AFPInternalException {
        if (!this.isValidPoints(new Point2D[]{point2D})) {
            return;
        }
        this.afp.writeModcaSF("GDD", 37);
        this.afp.writeByte(247);
        this.afp.writeByte(7);
        this.afp.writeByte(176);
        this.afp.writeShort(0);
        this.afp.writeByte(2);
        this.afp.writeByte(0);
        this.afp.writeByte(1);
        this.afp.writeByte(0);
        this.afp.writeByte(246);
        this.afp.writeByte(18);
        this.afp.writeFlagsInByte(new boolean[]{false, false, false, true, false, false, false, false});
        this.afp.writeByte(0);
        this.afp.writeByte(0);
        this.afp.writeByte(0);
        this.afp.writeResolutionBytes();
        this.afp.writeShort(28672);
        this.afp.writeShort(0);
        this.afp.writeShort(point2D.x);
        this.afp.writeShort(0);
        this.afp.writeShort(point2D.y);
        this.afp.flush();
    }

    public void writeGSLW_SetLineWidth(int n) throws AFPInternalException {
        if (n > 0 && n < 256) {
            this.afp.writeByte(25);
            this.afp.writeByte(n);
        } else if (n != 0) {
            this.logger.warning("wrong line thickness:" + n);
        }
    }

    public void writeEndSegment() throws IOException, AFPInternalException {
        this.afp.writeByte(113);
        this.afp.writeByte(0);
    }

    public void writeBeginSegment() throws IOException, AFPInternalException {
        this.afp.writeByte(112);
        this.afp.writeByte(12);
        this.afp.writeShort(0);
        this.afp.writeShort(0);
        this.afp.writeByte(0);
        this.afp.writeFlagsInByte(new boolean[]{false, false, false, true, false, false, false, false});
        this.afp.writeShort(10);
        this.afp.writeShort(0);
        this.afp.writeShort(10);
    }

    public void resetColor() {
        this.currentColor = null;
    }

    public void setColor(Attr.Color color) throws AFPInternalException {
        if (color == null) {
            return;
        }
        if (color.equals(this.currentColor)) {
            return;
        }
        this.currentColor = color;
        if (this.afp.isGocaLevelSupported(3)) {
            int n = this.afp.getExtendedColorSequenceLength(color) + 1;
            this.afp.writeByte(178);
            this.afp.writeByte(n);
            this.afp.writeByte(0);
            this.afp.writeExtendedColorSequence(color);
        } else if (this.afp.isGocaLevelSupported(1)) {
            this.writeGSCECOL_SetExtendedColor(color);
        }
    }

    protected void writeGSCECOL_SetExtendedColor(Attr.Color color) throws AFPInternalException {
        if (color != null) {
            this.afp.writeByte(38);
            this.afp.writeByte(2);
            int n = AFP.extendedColorToOCAColorIndex(color);
            if (n == 16) {
                n = 7;
            }
            this.afp.writeShort(n);
        }
    }

    public void writeGOCABegin(Image image, Point2D point2D, Point2D point2D2) throws IOException, AFPInternalException {
        if (!this.isValidPoints(new Point2D[]{point2D, point2D2})) {
            throw new AFPInternalException("Primitives' coordinate out of range");
        }
        this.nameGocaSegment = this.afp.genImageName(image);
        this.afp.writeModcaSFNamed("BGR", this.nameGocaSegment);
        this.afp.writeModcaSFNamed("BOG", this.nameGocaSegment);
        this.modcaOrders.writeSF_OBD(point2D);
        this.modcaOrders.writeSF_OBP(point2D2, 1, 0);
        this.writeSF_GDD(point2D);
        this.afp.writeModcaSF("EOG", 8);
        this.afp.startAccumulation();
        this.afp.writeModcaSF("GAD");
        this.writeBeginSegment();
    }

    public void writeGOCAEnd() throws IOException, AFPInternalException {
        this.afp.writeAccumulatedLength(1);
        this.afp.flush();
        if (this.nameGocaSegment != null) {
            this.afp.writeModcaSFNamed("EGR", this.nameGocaSegment);
        } else {
            this.afp.writeModcaSFNamedHex("EGR", "FFFF000000000000");
        }
    }
}

