/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.afplib;

import com.renderx.afpcommon.CodePage;
import com.renderx.afplib.AFP;
import com.renderx.afplib.AFPException;
import com.renderx.afplib.AFPInternalException;
import com.renderx.fonts.FontRecord;
import com.renderx.util.ErrorHandler;
import com.renderx.util.Hashtable;
import com.renderx.xep.lib.Session;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public class XFont
implements Cloneable {
    private static final int WEIGHT_100 = 0;
    private static final int WEIGHT_200 = 1;
    private static final int WEIGHT_300 = 2;
    private static final int WEIGHT_400 = 3;
    private static final int WEIGHT_500 = 4;
    private static final int WEIGHT_600 = 5;
    private static final int WEIGHT_700 = 6;
    private static final int WEIGHT_800 = 7;
    private static final int WEIGHT_900 = 8;
    private static final int WEIGHT_TOTAL = 9;
    private static final int WEIGHT_NORMAL = 3;
    private static final int WEIGHT_BOLD = 6;
    private static final int STYLE_NORMAL = 0;
    private static final int STYLE_ITALIC = 1;
    private static final int STYLE_OBLIQUE = 2;
    private static final int STYLE_BACKSLANT = 3;
    private static final int STYLE_TOTAL = 4;
    private static final int STYLE_SLANTED = 2;
    private static final int STYLE_DEFAULT = 0;
    private static final Hashtable styleIndexes = new Hashtable();
    private static final int VARIANT_NORMAL = 0;
    private static final int VARIANT_SMALLCAPS = 1;
    private static final int VARIANT_TOTAL = 2;
    private static final int VARIANT_DEFAULT = 0;
    private static final Hashtable variantIndexes;
    private static final String externalFOCAFontPrefix = "X";
    public static final String DEFAULT_FONT_FAMILY = "Helvetica";
    public static final String DEFAULT_FONT_STYLE = "normal";
    public static final int DEFAULT_FONT_WEIGHT = 400;
    public static final String DEFAULT_FONT_VARIANT = "normal";
    public static final int DEFAULT_FONT_SIZE = 10;
    private static final String fontSizeDesignator = "01234567890ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public String family;
    public String style;
    public int weight;
    public String variant;
    public int size;
    public FontRecord font;
    public String FOCAFontName;
    public CodePage codePage;
    public int fontAFPLocalId = 0;
    private ErrorHandler session;
    private static XFont defaultFont;

    private static final int getWeightIndex(int n) {
        if (n <= 100) {
            return 0;
        }
        if (n <= 200) {
            return 1;
        }
        if (n <= 300) {
            return 2;
        }
        if (n <= 400) {
            return 3;
        }
        if (n <= 500) {
            return 4;
        }
        if (n <= 600) {
            return 5;
        }
        if (n <= 700) {
            return 6;
        }
        if (n <= 800) {
            return 7;
        }
        return 8;
    }

    private static final int getStyleIndex(String string) {
        if (string == null) {
            return 0;
        }
        Integer n = (Integer)styleIndexes.get(string.trim().toLowerCase());
        return n == null ? 0 : n;
    }

    private static final int getVariantIndex(String string) {
        if (string == null) {
            return 0;
        }
        Integer n = (Integer)variantIndexes.get(string.trim().toLowerCase());
        return n == null ? 0 : n;
    }

    public XFont(Session session, String string, String string2, int n, String string3, int n2, String[] stringArray, CodePage codePage) {
        this.session = session;
        this.family = string;
        this.style = string2;
        this.weight = n;
        this.variant = string3;
        this.size = n2;
        this.font = session == null ? null : session.config.fontCatalog.getFontRecord(string, n, string2, string3, n2 / 1000);
        this.codePage = codePage;
        if (stringArray != null && stringArray.length > 0) {
            this.FOCAFontName = stringArray[this.getFontIndex()];
            this.FOCAFontName = this.genAFPCodedFontName();
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof XFont)) {
            return false;
        }
        XFont xFont = (XFont)object;
        return this.family.equals(xFont.family) && this.style.equals(xFont.style) && this.weight == xFont.weight && this.variant.equals(xFont.variant) && this.size == xFont.size && this.codePage.equals(xFont.codePage);
    }

    public int getFontIndex() {
        int n = 0;
        if (XFont.getStyleIndex(this.style) > 0) {
            ++n;
        }
        if (XFont.getWeightIndex(this.weight) > 3) {
            n += 2;
        }
        return n;
    }

    private String genAFPCodedFontName() {
        if (this.FOCAFontName == null || this.FOCAFontName.length() == 0) {
            throw new AFPException("Font family not supported in AFP: " + this.family + ". Configure AFP generator properly.");
        }
        String string = this.FOCAFontName.replace('.', this.genFontChar());
        return string;
    }

    private char genFontChar() {
        int n = this.size / 1000;
        if (n >= fontSizeDesignator.length()) {
            n = fontSizeDesignator.length() - 1;
            this.session.warning("Font size " + this.size + " is too big. Changed to maximal");
        }
        return fontSizeDesignator.charAt(n);
    }

    public boolean isExternalCodedFont() {
        XFont xFont = this;
        return xFont.FOCAFontName.startsWith(externalFOCAFontPrefix);
    }

    public void writeCodedFont(AFP aFP) throws IOException, AFPInternalException {
        if (this.isExternalCodedFont()) {
            this.writeCodedFontFormat1(aFP);
        } else {
            this.writeCodedFontFormat2(aFP);
        }
    }

    public void writeCodedFontFormat2(AFP aFP) throws IOException, AFPInternalException {
        aFP.writeModcaSF("MCF", 38);
        aFP.writeShort(30);
        aFP.writeModcaTripletHeader(2, 12);
        aFP.writeByte(134);
        aFP.writeByte(0);
        aFP.writeEBC(this.FOCAFontName);
        aFP.writeModcaTripletHeader(2, 12);
        aFP.writeByte(133);
        aFP.writeByte(0);
        aFP.writeEBC(this.codePage.afpCodepage);
        aFP.writeModcaTripletHeader(36, 4);
        aFP.writeByte(5);
        aFP.writeByte(this.fontAFPLocalId & 0x7F);
        aFP.flush();
    }

    public void writeCodedFontFormat1(AFP aFP) throws IOException, AFPInternalException {
        aFP.writeModcaSF("MCF-1", 40);
        aFP.writeByte(28);
        aFP.writeNBytes(0L, 3);
        aFP.writeByte(this.fontAFPLocalId & 0x7F);
        aFP.writeByte(0);
        aFP.writeByte(0);
        aFP.writeByte(0);
        aFP.writeEBC(this.FOCAFontName);
        aFP.writeHex("FFFF000000000000");
        aFP.writeHex("FFFF000000000000");
        aFP.flush();
    }

    public static void writeExternalCodedFonts(AFP aFP, ArrayList arrayList) throws IOException, AFPInternalException {
        if (arrayList.size() > 0) {
            aFP.writeModcaSF("MCF-1", 12 + arrayList.size() * 28);
            aFP.writeByte(28);
            aFP.writeNBytes(0L, 3);
            aFP.flush();
            for (int i = 0; i < arrayList.size(); ++i) {
                XFont xFont = (XFont)arrayList.get(i);
                aFP.writeByte(xFont.fontAFPLocalId & 0x7F);
                aFP.writeByte(0);
                aFP.writeByte(0);
                aFP.writeByte(0);
                aFP.writeEBC(xFont.FOCAFontName);
                aFP.writeHex("FFFF000000000000");
                aFP.writeHex("FFFF000000000000");
                aFP.flush();
            }
        }
    }

    public int hashCode() {
        return (this.family.hashCode() * 9 * 4 * 2 + XFont.getWeightIndex(this.weight) * 4 * 2 + XFont.getStyleIndex(this.style) * 2 + XFont.getVariantIndex(this.variant)) * 100 + this.size / 1000;
    }

    public String toString() {
        return "<font family = \"" + this.family + "\"" + " style =\"" + this.style + "\"" + " weight=\"" + this.weight + "\"" + " variant = \"" + this.variant + "\"" + " size = \"" + this.size + "\" (" + " AFP font name = \"" + this.FOCAFontName + "\"" + " local ID = \"" + this.fontAFPLocalId + "\"" + " codePage = \"" + this.codePage + "\" )/>";
    }

    public static XFont createDefaultFont(Session session, Map map, CodePage codePage) {
        if (defaultFont != null) {
            return defaultFont;
        }
        String[] stringArray = (String[])map.get(DEFAULT_FONT_FAMILY);
        if (stringArray == null) {
            throw new AFPException("Default font 'Helvetica' is not specified in configuration file");
        }
        defaultFont = new XFont(session, DEFAULT_FONT_FAMILY, "normal", 400, "normal", 10, stringArray, codePage);
        return defaultFont;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.getMessage());
        }
    }

    static {
        styleIndexes.put("normal", new Integer(0));
        styleIndexes.put("italic", new Integer(1));
        styleIndexes.put("oblique", new Integer(2));
        styleIndexes.put("backslant", new Integer(3));
        variantIndexes = new Hashtable();
        variantIndexes.put("normal", new Integer(0));
        variantIndexes.put("small-caps", new Integer(1));
    }
}

