/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.IncompatibleMatrices;
import jas.hist.IndeterminateMatrix;
import jas.hist.MatrixBug;
import java.text.NumberFormat;

public class Matrix {
    public static double[][] create(int size) {
        double[][] result = new double[size][];
        for (int i = 0; i < size; ++i) {
            result[i] = new double[size];
        }
        return result;
    }

    public static double[][] clone(double[][] in) {
        double[][] result = (double[][])in.clone();
        for (int i = 0; i < result.length; ++i) {
            result[i] = (double[])result[i].clone();
        }
        return result;
    }

    public static void print(double[][] in) {
        NumberFormat nf = NumberFormat.getInstance();
        for (int i = 0; i < in.length; ++i) {
            for (int j = 0; j < in[i].length; ++j) {
                System.out.print(nf.format(in[i][j]) + " ");
            }
            System.out.println();
        }
    }

    public static double[][] multiply(double[][] in1, double[][] in2) throws IncompatibleMatrices {
        double[][] out = new double[in1.length][];
        for (int i = 0; i < in1.length; ++i) {
            if (in1[i].length != in2.length) {
                throw new IncompatibleMatrices();
            }
            out[i] = new double[in2[i].length];
            for (int j = 0; j < in2[i].length; ++j) {
                out[i][j] = 0.0;
                for (int k = 0; k < in1[i].length; ++k) {
                    double[] dArray = out[i];
                    int n = j;
                    dArray[n] = dArray[n] + in1[i][k] * in2[k][j];
                }
            }
        }
        return out;
    }

    public static double invert(double[][] array) throws IndeterminateMatrix {
        int j;
        int i;
        double det = 1.0;
        int order = array.length;
        int[] ik = new int[order];
        int[] jk = new int[order];
        for (int k = 0; k < order; ++k) {
            double save;
            int j2;
            double amax = 0.0;
            for (i = k; i < order; ++i) {
                for (j2 = k; j2 < order; ++j2) {
                    if (!(Math.abs(array[i][j2]) > Math.abs(amax))) continue;
                    amax = array[i][j2];
                    ik[k] = i;
                    jk[k] = j2;
                }
            }
            if (amax == 0.0) {
                throw new IndeterminateMatrix();
            }
            i = ik[k];
            if (k > i) {
                throw new MatrixBug();
            }
            if (i > k) {
                for (j2 = 0; j2 < order; ++j2) {
                    save = array[k][j2];
                    array[k][j2] = array[i][j2];
                    array[i][j2] = -save;
                }
            }
            if (k > (j = jk[k])) {
                throw new MatrixBug();
            }
            if (j > k) {
                for (int i2 = 0; i2 < order; ++i2) {
                    save = array[i2][k];
                    array[i2][k] = array[i2][j];
                    array[i2][j] = -save;
                }
            }
            for (i = 0; i < order; ++i) {
                if (i == k) continue;
                array[i][k] = -array[i][k] / amax;
            }
            for (i = 0; i < order; ++i) {
                if (i == k) continue;
                for (j2 = 0; j2 < order; ++j2) {
                    if (j2 == k) continue;
                    double[] dArray = array[i];
                    int n = j2;
                    dArray[n] = dArray[n] + array[i][k] * array[k][j2];
                }
            }
            for (j = 0; j < order; ++j) {
                if (j == k) continue;
                array[k][j] = array[k][j] / amax;
            }
            array[k][k] = 1.0 / amax;
            det *= amax;
        }
        for (int l = 0; l < order; ++l) {
            int i3;
            int k = order - l - 1;
            int j3 = ik[k];
            if (j3 > k) {
                for (i = 0; i < order; ++i) {
                    double save = array[i][k];
                    array[i][k] = -array[i][j3];
                    array[i][j3] = save;
                }
            }
            if ((i3 = jk[k]) <= k) continue;
            for (j = 0; j < order; ++j) {
                double save = array[k][j];
                array[k][j] = -array[i3][j];
                array[i3][j] = save;
            }
        }
        return det;
    }
}

