/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.pre.exp;

import com.renderx.xep.pre.Attn;
import com.renderx.xep.pre.Attr;
import com.renderx.xep.pre.Expr;
import com.renderx.xep.pre.ParserContext;
import com.renderx.xep.pre.ParserException;
import com.renderx.xep.pre.exp.CMYK_Color;
import com.renderx.xep.pre.exp.Grayscale_Color;
import com.renderx.xep.pre.exp.RGB_Color;
import com.renderx.xep.pre.exp.Registration_Color;
import com.renderx.xep.pre.exp.Spot_Color;

public final class RGB_ICC_Color
extends Expr {
    protected Attr[] rgbData = null;
    protected Attr profile = null;
    protected Attr[] colorData = null;

    public String toString() {
        String string = "rgb-icc(" + this.rgbData[0] + ", " + this.rgbData[1] + ", " + this.rgbData[2] + ", " + this.profile;
        if (this.colorData != null) {
            int n = 0;
            while (n < this.colorData.length) {
                string = string + ", " + this.colorData[n];
                ++n;
            }
        }
        string = string + ")";
        return string;
    }

    public RGB_ICC_Color() {
    }

    public RGB_ICC_Color(Attr[] attrArray, Attr attr, Attr[] attrArray2) {
        this.rgbData = attrArray;
        this.profile = attr;
        this.colorData = attrArray2;
    }

    public Attr initialize(Attr[] attrArray) throws ParserException {
        if (attrArray == null) {
            throw new ParserException("rgb-icc() function requires 5 or more arguments");
        }
        if (attrArray.length < 5) {
            throw new ParserException("rgb-icc() function requires 5 or more arguments");
        }
        this.rgbData = new Attr[3];
        this.rgbData[0] = attrArray[0];
        this.rgbData[1] = attrArray[1];
        this.rgbData[2] = attrArray[2];
        this.profile = attrArray[3];
        this.colorData = new Attr[attrArray.length - 4];
        int n = 4;
        while (n < attrArray.length) {
            this.colorData[n - 4] = attrArray[n];
            ++n;
        }
        return this.preevaluate();
    }

    public final Attr preevaluate() throws ParserException {
        Attr attr = this.selectColorSpace(this.profile.preevaluate());
        if (attr instanceof RGB_ICC_Color) {
            return attr;
        }
        return attr.preevaluate();
    }

    public final Attr evaluate(ParserContext parserContext, Attn attn) throws ParserException {
        Attr attr = this.selectColorSpace(this.profile.evaluate(parserContext, attn));
        if (attr instanceof RGB_ICC_Color) {
            return attr;
        }
        return attr.evaluate(parserContext, attn);
    }

    protected final Attr selectColorSpace(Attr attr) throws ParserException {
        if (attr instanceof Expr) {
            return attr == this.profile ? this : new RGB_ICC_Color(this.rgbData, attr, this.colorData);
        }
        if (attr instanceof Attr.Word) {
            if ("#Grayscale".equals(attr.word())) {
                if (this.colorData == null || this.colorData.length != 1) {
                    throw new ParserException("Built-in #Grayscale profile takes 1 argument");
                }
                return new Grayscale_Color().initialize(this.colorData);
            }
            if ("#CMYK".equals(attr.word())) {
                if (this.colorData == null || this.colorData.length != 4) {
                    throw new ParserException("Built-in #CMYK profile takes 4 arguments");
                }
                return new CMYK_Color().initialize(this.colorData);
            }
            if ("#SpotColor".equals(attr.word())) {
                if (this.colorData == null || this.colorData.length < 2) {
                    throw new ParserException("Built-in #SpotColor profile should take 2 or more arguments");
                }
                return new Spot_Color().initialize(this.colorData);
            }
            if ("#Registration".equals(attr.word())) {
                if (this.colorData == null || this.colorData.length != 1) {
                    throw new ParserException("Built-in #Registration profile takes 1 argument");
                }
                return new Registration_Color().initialize(this.colorData);
            }
            return new RGB_Color().initialize(this.rgbData);
        }
        throw new ParserException("Color profile name in rgb-icc() function cannot be of type " + attr.getTypeName());
    }
}

