/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.pre;

import com.renderx.xep.lib.Logger;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SAXErrorHandler
implements ErrorHandler {
    int errorCount = 0;
    int warningCount = 0;
    private final com.renderx.util.ErrorHandler logger;

    SAXErrorHandler(Logger logger) {
        this.logger = logger;
        this.reset();
    }

    public void reset() {
        this.errorCount = 0;
        this.warningCount = 0;
    }

    private static String formatMessage(SAXParseException sAXParseException) {
        int n = sAXParseException.getLineNumber();
        int n2 = sAXParseException.getColumnNumber();
        if (n <= 0) {
            return sAXParseException.getMessage();
        }
        if (n2 <= 0) {
            return "line " + n + ": " + sAXParseException.getMessage();
        }
        return "line " + n + ", column " + n2 + ": " + sAXParseException.getMessage();
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.logger.warning(SAXErrorHandler.formatMessage(sAXParseException));
        ++this.warningCount;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.logger.error(SAXErrorHandler.formatMessage(sAXParseException));
        ++this.errorCount;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }
}

