/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.gen.backends;

import com.renderx.util.Hashtable;
import com.renderx.xep.gen.H4base;
import com.renderx.xep.lib.InternalException;
import com.renderx.xep.lib.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class EmbeddedImageFilter
implements ContentHandler {
    private static final String XEPURI = "http://www.renderx.com/XEP/xep";
    private final ContentHandler parent;
    private final Logger logger;
    private Hashtable imagetable = new Hashtable();

    public EmbeddedImageFilter(ContentHandler contentHandler, Logger logger) {
        this.parent = contentHandler;
        this.logger = logger;
    }

    public void startDocument() throws SAXException {
        this.logger.openState("generate");
        if (this.parent instanceof H4base) {
            this.logger.event("output-format", ((H4base)this.parent).outFormat());
        }
        this.parent.startDocument();
    }

    public void endDocument() throws SAXException {
        this.parent.endDocument();
        this.logger.closeState("generate");
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (XEPURI.equals(string)) {
            if (string2.equals("page")) {
                this.logger.event("page-number", attributes.getValue("page-number"));
            } else if (string2.equals("image") || string2.equals("media-object") || string2.equals("rich-media-object") || string2.equals("rich-media-resource") || string2.equals("poster")) {
                String string4 = attributes.getValue("id");
                String string5 = attributes.getValue("id-ref");
                if (string4 != null) {
                    this.imagetable.put(string4, attributes.getValue("src"));
                } else if (string5 != null) {
                    String string6 = (String)this.imagetable.get(string5);
                    if (string6 == null) {
                        this.logger.error("Unresolved image reference: id-ref=\"" + string5 + "\"");
                    }
                    AttributesImpl attributesImpl = new AttributesImpl(attributes);
                    attributesImpl.addAttribute("", "src", "src", "CDATA", string6);
                    attributes = attributesImpl;
                }
            }
        }
        try {
            this.parent.startElement(XEPURI, string2, string3, attributes);
        }
        catch (InternalException internalException) {
            this.logger.error(internalException.getMessage());
            throw internalException;
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.parent.characters(cArray, n, n2);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.parent.endElement(string, string2, string3);
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.parent.startPrefixMapping(string, string2);
    }

    public void endPrefixMapping(String string) throws SAXException {
        this.parent.endPrefixMapping(string);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.parent.ignorableWhitespace(cArray, n, n2);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.parent.processingInstruction(string, string2);
    }

    public void skippedEntity(String string) throws SAXException {
        this.parent.skippedEntity(string);
    }

    public void setDocumentLocator(Locator locator) {
        this.parent.setDocumentLocator(locator);
    }
}

