/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pslib;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ASCII85_Encode
extends FilterOutputStream {
    private static final int[] power85 = new int[]{1, 85, 7225, 614125, 52200625};
    private static final int charsPerRow = 64;
    private int offset = 0;
    private int count = 0;
    private long[] inbytes = new long[4];

    public ASCII85_Encode(OutputStream outputStream) {
        super(outputStream);
    }

    public void write(int n) throws IOException {
        this.inbytes[this.count++] = n & 0xFF;
        if (this.count == 4) {
            this.writeTuple();
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n;
        while (n3 < n + n2) {
            this.write(byArray[n3]);
            ++n3;
        }
    }

    public void EOD() throws IOException {
        if (this.count > 0) {
            this.writeTuple();
        }
        super.write(126);
        super.write(62);
    }

    private void writeTuple() throws IOException {
        if (this.offset > 64) {
            super.write(10);
            this.offset = 0;
        }
        long l = 0L;
        int n = 0;
        while (n < 4) {
            l <<= 8;
            l |= this.inbytes[n];
            ++n;
        }
        if (l == 0L) {
            super.write(122);
            ++this.offset;
        } else {
            int n2 = 0;
            while (n2 <= this.count) {
                super.write((byte)(33L + l / (long)power85[4 - n2] % 85L));
                ++n2;
            }
            this.offset += 5;
        }
        this.count = 0;
        this.inbytes[3] = 0L;
        this.inbytes[2] = 0L;
        this.inbytes[1] = 0L;
        this.inbytes[0] = 0L;
    }
}

