/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.fonts.CharMetrics;
import com.renderx.fonts.Encoding;
import com.renderx.fonts.FontDescriptor;
import com.renderx.fonts.Metric;
import com.renderx.fonts.PFxFont;
import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.PDFFontFile;
import com.renderx.pdflib.PDFOutputStream;
import com.renderx.util.SeekableInput;

public class T1FontFile
extends PDFFontFile {
    int length2;
    IndirectObject length2_id;
    int length3;
    IndirectObject length3_id;

    T1FontFile(IndirectObject indirectObject, FontDescriptor fontDescriptor, boolean bl) {
        super(indirectObject, fontDescriptor, bl);
    }

    public String pdfFontType() {
        return "FontFile";
    }

    void writeBody(PDFOutputStream pDFOutputStream) {
        this.writeBaseData(pDFOutputStream);
        this.length2_id = pDFOutputStream.getNextID();
        this.length3_id = pDFOutputStream.getNextID();
        pDFOutputStream.println("/Length2 " + this.length2_id.toStringR());
        pDFOutputStream.println("/Length3 " + this.length3_id.toStringR());
    }

    void writeTail(PDFOutputStream pDFOutputStream) {
        pDFOutputStream.println(">>");
        pDFOutputStream.println("stream");
        int n = pDFOutputStream.size();
        pDFOutputStream.startStream();
        try {
            SeekableInput seekableInput = this.descriptor.record.openSeekableFontStream();
            try {
                PFxFont pFxFont = new PFxFont(seekableInput);
                if (this.enableSubset && this.descriptor.record.subset) {
                    Metric metric = this.descriptor.record.getMetric();
                    pFxFont.newSubset();
                    int n2 = 0;
                    while (n2 < 65536) {
                        CharMetrics charMetrics;
                        if (this.descriptor.used.checkGlyph((char)n2) && (charMetrics = metric.ucm((char)n2)) != null) {
                            pFxFont.addGlyph(charMetrics.n, (Encoding)this.descriptor.encodingTable.get(0));
                        }
                        ++n2;
                    }
                    pFxFont.endSubset();
                }
                pDFOutputStream.print(pFxFont.head);
                this.length1 = pFxFont.head.length();
                if (this.enableSubset && this.descriptor.record.subset) {
                    pDFOutputStream.print(pFxFont.subsetbody);
                    this.length2 = pFxFont.subsetbody.length;
                } else {
                    pDFOutputStream.print(pFxFont.body);
                    this.length2 = pFxFont.body.length;
                }
                pDFOutputStream.println(pFxFont.tail);
                this.length3 = pFxFont.tail.length();
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                seekableInput.close();
                throw throwable;
            }
            seekableInput.close();
            {
            }
        }
        catch (Exception exception) {
            pDFOutputStream.exception("Cannot output subset for Type 1 font '" + this.descriptor.record.fontfile + "', the font is broken", exception);
        }
        pDFOutputStream.finishStream();
        this.length = pDFOutputStream.size() - n;
        pDFOutputStream.println("\nendstream");
        pDFOutputStream.println("endobj");
    }

    public void writeSubObjects(PDFOutputStream pDFOutputStream) {
        super.writeSubObjects(pDFOutputStream);
        pDFOutputStream.printLength(this.length2_id, this.length2);
        pDFOutputStream.printLength(this.length3_id, this.length3);
    }
}

