/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.graphics.vector;

import com.renderx.graphics.vector.OpaqueColor;
import com.renderx.graphics.vector.PaintServer;
import com.renderx.util.Applicator;
import com.renderx.util.List;
import java.io.IOException;
import java.io.PrintStream;

public abstract class Gradient
extends PaintServer {
    public boolean hasStopOpacity = false;
    public List stoplist = new List();

    public Gradient createSoftMaskGradient() {
        Gradient gradient = (Gradient)this.cc();
        gradient.hasStopOpacity = false;
        gradient.stoplist = this.stoplist.map(new List(), new Applicator(){

            public Object f(Object object) {
                Stop stop = (Stop)object;
                Stop stop2 = new Stop(stop.offset, new OpaqueColor.Grayscale(stop.opacity), 1.0);
                return stop2;
            }
        });
        return gradient;
    }

    public static class RadialGradient
    extends Gradient {
        public double xbeg;
        public double ybeg;
        public double rbeg;
        public double xend;
        public double yend;
        public double rend;

        public RadialGradient(double d, double d2, double d3, double d4, double d5, double d6) {
            this.xbeg = d;
            this.ybeg = d2;
            this.rbeg = d3;
            this.xend = d4;
            this.yend = d5;
            this.rend = d6;
        }

        public PaintServer cc() {
            RadialGradient radialGradient = new RadialGradient(this.xbeg, this.ybeg, this.rbeg, this.xend, this.yend, this.rend);
            radialGradient.unit = this.unit;
            radialGradient.matrix = new double[this.matrix.length];
            int n = 0;
            while (n < this.matrix.length) {
                radialGradient.matrix[n] = this.matrix[n];
                ++n;
            }
            radialGradient.stoplist = this.stoplist;
            radialGradient.hasStopOpacity = this.hasStopOpacity;
            return radialGradient;
        }

        public void dump(PrintStream printStream, String string) throws IOException {
            printStream.println(string + "%<radial-gradient/>");
        }
    }

    public static class LinearGradient
    extends Gradient {
        public double xbeg;
        public double ybeg;
        public double xend;
        public double yend;

        public LinearGradient(double d, double d2, double d3, double d4) {
            this.xbeg = d;
            this.ybeg = d2;
            this.xend = d3;
            this.yend = d4;
        }

        public PaintServer cc() {
            LinearGradient linearGradient = new LinearGradient(this.xbeg, this.ybeg, this.xend, this.yend);
            linearGradient.unit = this.unit;
            linearGradient.matrix = new double[this.matrix.length];
            int n = 0;
            while (n < this.matrix.length) {
                linearGradient.matrix[n] = this.matrix[n];
                ++n;
            }
            linearGradient.stoplist = this.stoplist;
            linearGradient.hasStopOpacity = this.hasStopOpacity;
            return linearGradient;
        }

        public void dump(PrintStream printStream, String string) throws IOException {
            printStream.println(string + "%<linear-gradient/>");
        }
    }

    public static class Stop {
        public double offset = 0.0;
        public double opacity = 1.0;
        public OpaqueColor color = null;

        public Stop(double d, OpaqueColor opaqueColor, double d2) {
            this.offset = d;
            this.color = opaqueColor;
            this.opacity = d2;
        }
    }
}

