/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.fonts.afp;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.StringTokenizer;

public abstract class FontResourceObject {
    public static String EBCDIC = "Cp500";
    private static int SCALE_COEFFICIENT = 20;
    private String encoding = EBCDIC;

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public abstract void load(InputStream var1) throws IOException;

    public static byte[] readStructuredField(InputStream inputStream, byte[] byArray) throws IOException {
        int n;
        byte[] byArray2 = new byte[byArray.length + 2];
        byte[] byArray3 = new byte[3];
        byte[] byArray4 = new byte[]{};
        while ((n = inputStream.read()) > -1) {
            int n2 = 1;
            while (n2 < byArray2.length) {
                byArray2[n2 - 1] = byArray2[n2];
                ++n2;
            }
            byArray2[byArray2.length - 1] = (byte)n;
            boolean bl = true;
            int n3 = 2;
            while (n3 < byArray2.length) {
                if (byArray2[n3] != byArray[n3 - 2]) {
                    bl = false;
                }
                ++n3;
            }
            if (!bl) continue;
            byte by = (byte)inputStream.read();
            byte[] byArray5 = new byte[2];
            inputStream.read(byArray5, 0, 2);
            int n4 = FontResourceObject.bytesToInt(new byte[]{byArray2[0], byArray2[1]}) - byArray.length - 5;
            byArray4 = new byte[n4];
            inputStream.read(byArray4, 0, n4);
            break;
        }
        return byArray4;
    }

    public static int bytesToInt(byte[] byArray) {
        return new BigInteger(byArray).intValue();
    }

    public static int bytesToScaledSize(byte[] byArray) {
        return FontResourceObject.bytesToInt(byArray) * SCALE_COEFFICIENT;
    }

    public static int bytesToUnsignInt(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            n += (byArray[n2] & 0xFF) << 8 * (byArray.length - 1 - n2);
            ++n2;
        }
        return n;
    }

    public static boolean[] byteToBits(byte by) {
        boolean[] blArray = new boolean[8];
        int n = 0;
        while (n < blArray.length) {
            blArray[7 - n] = (by & 1 << n) != 0;
            ++n;
        }
        return blArray;
    }

    public static byte[] readFromHexString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        byte[] byArray = new byte[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            byArray[n] = Byte.valueOf(stringTokenizer.nextToken(), 16);
            ++n;
        }
        return byArray;
    }
}

