package com.renderx.xepx.x4u.ct.charsetspanel;

import javax.swing.border.*;
import java.awt.*;
import javax.swing.*;
import org.w3c.dom.*;
import java.awt.event.*;
/**
 * @author: Roschupkin Alexander
 * @version: 1.0
 * @todo
 **/

public class CodeRangePanel extends JPanel
{
    private static final long serialVersionUID = -5440310225279575178L;

    // implements TableModelListener{

    Node root = null;

    JTable aTable = null;


    int currentRow = 0;

    public CodeRangePanel(Node node)
    {
	this.root = node;
	jbInit();
    }


    private void jbInit()
    {
	this.setBorder(new TitledBorder(BorderFactory.createLineBorder(
		Color.black, 2), "Code ranges"));
	this.setLayout(new BorderLayout());// borderLayout1);
	JPanel tablePanel = new JPanel(new GridLayout(1, 1)); // Panel with
                                                                // ScrollPane
                                                                // for JTable
	JPanel commandPanel = new JPanel();
	this.add(tablePanel, BorderLayout.CENTER);
	this.add(commandPanel, BorderLayout.SOUTH);

	JScrollPane tableScrollPane = new JScrollPane();
	tablePanel.add(tableScrollPane, null);
	aTable = new JTable(new DomToTableRangeModel((Element) root, false));
	//TableColumn ffamilyColumn = aTable.getColumnModel().getColumn(1);
	//JComboBox comboBox = new JComboBox(DOMWalker.getFonts());
	//ffamilyColumn.setCellEditor(new DefaultCellEditor(comboBox));
	aTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
	aTable.setSelectionBackground(Color.gray);
	aTable.setCellSelectionEnabled(true);
	aTable.setColumnSelectionAllowed(true);

	tableScrollPane.getViewport().add(aTable, null);

	// Enable after others buttons are pressed
	JButton deleteButton = new JButton("Delete range");
	JButton addButton = new JButton("Add range");
	addButton.addActionListener(new java.awt.event.ActionListener()
	{
	    public void actionPerformed(ActionEvent e)
	    {
		addButton_actionPerformed(e);
	    }
	});
	deleteButton.addActionListener(new java.awt.event.ActionListener()
	{
	    public void actionPerformed(ActionEvent e)
	    {
		deleteButton_actionPerformed(e);
	    }
	});

	commandPanel.add(addButton, null);
	commandPanel.add(deleteButton, null);
    }

    void addButton_actionPerformed(ActionEvent e)
    {
	DomToTableRangeModel tm = (DomToTableRangeModel) aTable.getModel();
	Element tmp = root.getOwnerDocument().createElement("code-range");
	tmp.setAttribute("from", "");
	tmp.setAttribute("to", "");

	root.appendChild(tmp);
	tm.addRow(tmp);
	currentRow = tm.getRowCount() - 1;
    }

    void deleteButton_actionPerformed(ActionEvent e)
    {
	int row = aTable.getSelectedRow();
	if (row < 0)
	    return; // IF table not selected !!!
	DomToTableRangeModel tm = (DomToTableRangeModel) aTable.getModel();
	Node tmp = (Element) tm.getNodeAt(row);
	root.removeChild(tmp);
	tm.deleteRow(row);
	currentRow = (currentRow == 0) ? 0 : currentRow - 1;
    }
}
