package com.renderx.xepx.x4u.as;

class Settings
{   
	public static String XEP_CONFIG_FULL = "com.renderx.xep.CONFIG";
	public static String XEP_CONFIG_SHORT = "CONFIG";
	
	String source, dir, stylesheet, result, afpRes, viewer, format;
	boolean transform, preview, setRes;
	java.util.Vector xslparams = new java.util.Vector();

	private String xepConfigPath;
	
	
	Settings() {
		java.io.File infile = 
			new java.io.File(System.getProperty("user.home"),
					".xep"+java.io.File.separator+"x4u.xml");
		boolean restored = false;
		try {
			org.xml.sax.XMLReader xmlreader =
				com.renderx.sax.XMLReaderFactory.createXMLReader();
			xmlreader.setContentHandler(new Config());
			xmlreader.parse(infile.toURL().toString());
			restored = true;
		} catch(java.io.IOException e) { // no configuration file, normal
		} catch(org.xml.sax.SAXException e) {
			System.err.println("settings file '"+infile
					+"' corrupt, reverting to defaults: "+e);
		}
		//if(!restored) {
		if(!restored) dir = "";
		source = ""; result = ""; stylesheet = ""; afpRes = "";
		format = "pdf";
		transform = false;
		setRes = false;
		if (!restored) {
			preview = false;
			String[] viewers;
			if(java.io.File.separator.equals("\\")){
				viewers = new String[]{
						"C:\\Program Files\\Adobe\\Acrobat 6.0\\Reader\\AcroRd32.exe",
						"C:\\Program Files\\Adobe\\Acrobat 5.0\\Reader\\AcroRd32.exe",
						"C:\\Program Files\\Adobe\\Acrobat 4.0\\Reader\\AcroRd32.exe"
				};
				viewer = "AcroRd32.exe";
			}else if(java.io.File.separator.equals("/")){
				viewers = new String[]{
						"/usr/local/bin/acroread",
						"/usr/X11R6/bin/acroread",
						"/usr/X11R6/bin/xpdf",
						"/usr/bin/xpdf",
						"/usr/local/bin/xpdf",
						"/usr/X11R6/bin/gv",
						"/usr/local/bin/gv",
						"/usr/X11R6/bin/ghostview",
						"/usr/local/bin/ghostview"
				};
				viewer = "acroread";
			}else{
				viewers = new String[]{};
				viewer = "";
			}
			for(int i=0;i!=viewers.length;++i){
				if(new java.io.File(viewers[i]).exists()){
					viewer = viewers[i];
					break;
				}
			}
		}
	}
	
	public String getXEPConfigPath() {
		if (xepConfigPath != null && xepConfigPath.length() > 0) {
			return xepConfigPath;
		}
		String configPath = System.getProperty(XEP_CONFIG_FULL);
		if (configPath == null || configPath.trim().length() == 0) {
			configPath = System.getProperty(XEP_CONFIG_SHORT);	
		}
		return configPath;
	}
	
	public void setXEPConfigPath(String path) {
		xepConfigPath = path; 
	}

	public void setXEPConfigPath(String[] args) {
        for (int i = 0; i < args.length; i++) {
        	int xepPathIndex = args[i].indexOf("-D" + XEP_CONFIG_FULL);
        	int constantLength = XEP_CONFIG_FULL.length();
        	if (xepPathIndex < 0) {
        		xepPathIndex = args[i].indexOf("-D" + XEP_CONFIG_SHORT);
        		constantLength = XEP_CONFIG_SHORT.length();
        	}
        	if (xepPathIndex >= 0) {
        		int start = args[i].indexOf("=", xepPathIndex + constantLength + 2);
        		if (start >= 0 && start < args[i].length()) {
            		xepConfigPath = args[i].substring(start + 1).trim();
            		if (xepConfigPath.length() > 0) {
            			return;
            		}
        		}
        	}
        }
	}

	private class Config extends org.xml.sax.helpers.DefaultHandler {
		public void startElement(String uri,
				String name,
				String qname,
				org.xml.sax.Attributes attrs)
		throws org.xml.sax.SAXException {
			if (name.equals("settings")) {
				String value;
				dir = attrs.getValue("source");
				//result = attrs.getValue("result");
				//afpRes = attrs.getValue("afpresource");
				//stylesheet = attrs.getValue("stylesheet");
				//format = attrs.getValue("format");
				viewer = attrs.getValue("viewer");
				//transform = "true".equals(attrs.getValue("transform"));
				preview = "true".equals(attrs.getValue("preview"));
				//setRes = "true".equals(attrs.getValue("setafpresource"));
			} else if(name.equals("option")) {
				java.util.Vector param = new java.util.Vector();
				param.add(attrs.getValue("name"));
				param.add(attrs.getValue("value"));
				xslparams.add(param);
			}
		}
	}

	void save() throws Exception {
		java.io.File dirH = new java.io.File(System.getProperty("user.home"),".xep");
		dirH.mkdir();
		org.xml.sax.ContentHandler cfg = new com.renderx.sax.Serializer(
				new java.io.File(dirH,"x4u.xml").toString());
		org.xml.sax.helpers.AttributesImpl attrs;
		cfg.startDocument();
		attrs = new org.xml.sax.helpers.AttributesImpl();
		attrs.addAttribute(null,null,"source","CDATA",source);
		dir = source;
		//attrs.addAttribute(null,null,"result","CDATA",result);
		//attrs.addAttribute(null,null,"afpresource","CDATA",afpRes);
		//attrs.addAttribute(null,null,"stylesheet","CDATA",stylesheet);
		//attrs.addAttribute(null,null,"format","CDATA",format);
		attrs.addAttribute(null,null,"viewer","CDATA",viewer);
		//attrs.addAttribute(null,null,"transform","CDATA",transform?"true":"false");
		attrs.addAttribute(null,null,"preview","CDATA",preview?"true":"false");
		//attrs.addAttribute(null,null,"setafpresource","CDATA",setRes?"true":"false");
		cfg.startElement(null,null,"settings",attrs);
		/*attrs = new org.xml.sax.helpers.AttributesImpl();
		cfg.startElement(null,null,"xsl",attrs);
		for(java.util.Enumeration e = xslparams.elements();e.hasMoreElements();) {
			java.util.Vector param = (java.util.Vector)e.nextElement();
			attrs = new org.xml.sax.helpers.AttributesImpl();
			attrs.addAttribute(null,null,"name","CDATA",(String)param.elementAt(0));
			attrs.addAttribute(null,null,"value","CDATA",(String)param.elementAt(1));
			cfg.startElement(null,null,"option",attrs);
			cfg.endElement(null,null,"option");
		}
		cfg.endElement(null,null,"xsl");*/
		cfg.endElement(null,null,"settings");
		cfg.endDocument();
	}
}
