<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"    
    xmlns:fo="http://www.w3.org/1999/XSL/Format">

    <xsl:output method="xml" version="1.0" indent="no" encoding="utf-8"/>

    <xsl:key name="footnotes" match="fo:footnote" use="generate-id((ancestor::fo:table-row)[1])"/>
 
    <xsl:template match="@*|node()">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()"/>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="fo:table-row[.//fo:footnote]">
      <fo:table-row>
        <xsl:apply-templates select="@*"/>
        <xsl:attribute name="keep-together.within-column">always</xsl:attribute>
        <xsl:apply-templates select="node()"/>
      </fo:table-row>
    </xsl:template>
    
    <xsl:template match="fo:footnote[ancestor::fo:table-row]">
      <xsl:choose>
        <xsl:when test="generate-id(.)=generate-id(key('footnotes',generate-id((ancestor::fo:table-row)[1])))">
          <fo:footnote>
            <xsl:apply-templates select="@*"/>
            <xsl:apply-templates select="node()"/>
          </fo:footnote>
          <xsl:apply-templates select="key('footnotes',generate-id(ancestor::fo:table-row))[position() != 1]" mode="table-row"/>
        </xsl:when>
        <xsl:otherwise>
          <fo:footnote>
            <xsl:apply-templates select="@*"/>
            <xsl:apply-templates select="node()[not(self::fo:footnote-body)]"/>
            <fo:footnote-body><fo:block/></fo:footnote-body>
          </fo:footnote>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:template>
 
    <xsl:template match="fo:footnote" mode="table-row">
      <fo:footnote keep-with-previous.within-column="always">
        <xsl:apply-templates select="@*"/>
        <fo:inline/>
        <xsl:apply-templates select="node()[not(self::fo:inline)]"/>
      </fo:footnote>
    </xsl:template>
 
</xsl:stylesheet>
