/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.pre.exp;

import com.renderx.xep.pre.Attn;
import com.renderx.xep.pre.Attr;
import com.renderx.xep.pre.Expr;
import com.renderx.xep.pre.ParserContext;
import com.renderx.xep.pre.ParserException;

public class CMYK_Color
extends Expr {
    protected Attr C = null;
    protected Attr M = null;
    protected Attr Y = null;
    protected Attr K = null;

    public String toString() {
        return "cmyk(" + this.C + ", " + this.M + ", " + this.Y + ", " + this.K + ")";
    }

    public CMYK_Color() {
    }

    public CMYK_Color(Attr attr, Attr attr2, Attr attr3, Attr attr4) {
        this.C = attr;
        this.M = attr2;
        this.Y = attr3;
        this.K = attr4;
    }

    public Attr initialize(Attr[] attrArray) throws ParserException {
        if (attrArray == null) {
            throw new ParserException("cmyk() function requires 4 arguments");
        }
        if (attrArray.length != 4) {
            throw new ParserException("cmyk() function requires 4 arguments");
        }
        this.C = attrArray[0];
        this.M = attrArray[1];
        this.Y = attrArray[2];
        this.K = attrArray[3];
        return this.preevaluate();
    }

    public final Attr preevaluate() throws ParserException {
        return this.calculate(this.C.preevaluate(), this.M.preevaluate(), this.Y.preevaluate(), this.K.preevaluate());
    }

    public final Attr evaluate(ParserContext parserContext, Attn attn) throws ParserException {
        return this.calculate(this.C.evaluate(parserContext, attn), this.M.evaluate(parserContext, attn), this.Y.evaluate(parserContext, attn), this.K.evaluate(parserContext, attn));
    }

    protected final Attr calculate(Attr attr, Attr attr2, Attr attr3, Attr attr4) throws ParserException {
        if (attr instanceof Expr || attr2 instanceof Expr || attr3 instanceof Expr || attr4 instanceof Expr) {
            return attr == this.C && attr2 == this.M && attr3 == this.Y && attr4 == this.K ? this : new CMYK_Color(attr, attr2, attr3, attr4);
        }
        double d = this.extractColorComponent(attr);
        double d2 = this.extractColorComponent(attr2);
        double d3 = this.extractColorComponent(attr3);
        double d4 = this.extractColorComponent(attr4);
        return Attr.Color.CMYK.create(d, d2, d3, d4);
    }

    private double extractColorComponent(Attr attr) throws ParserException {
        double d = 0.0;
        if (attr instanceof Attr.Percentage) {
            d = attr.percentage() / 100.0;
        } else if (attr instanceof Attr.Ratio) {
            d = attr.ratio();
        } else if (attr instanceof Attr.Count) {
            d = attr.count();
        } else {
            throw new ParserException("Argument of cmyk() function cannot be of type " + attr.getTypeName());
        }
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        return d;
    }
}

