/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.util;

import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class Hashtable
extends Dictionary
implements Cloneable,
Serializable {
    private Object[] table;
    private int halfTableLength;
    private int used;
    private int usedLimit;
    private static final int INIT_SIZE = 1;
    private static final float LOAD_FACTOR = 0.5f;

    private final int nextIndex(int n) {
        return n == 0 ? this.halfTableLength - 1 : n - 1;
    }

    private final int firstIndex(Object object) {
        return object.hashCode() & this.halfTableLength - 1;
    }

    public Hashtable() {
        this(1);
    }

    public Hashtable(int n) {
        n = (int)((float)(n + 1) / 0.5f);
        this.halfTableLength = 1;
        while (this.halfTableLength < n) {
            this.halfTableLength <<= 1;
        }
        this.table = new Object[this.halfTableLength << 1];
        this.usedLimit = (int)((float)this.halfTableLength * 0.5f);
    }

    public final int size() {
        return this.used;
    }

    public final boolean isEmpty() {
        return this.used == 0;
    }

    public final Object get(Object object) {
        if (this.used != 0) {
            int n = this.firstIndex(object);
            while (this.table[n] != null) {
                if (this.table[n].equals(object)) {
                    return this.table[n | this.halfTableLength];
                }
                n = this.nextIndex(n);
            }
        }
        return null;
    }

    public final boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    public final Object put(Object object, Object object2) {
        int n = this.firstIndex(object);
        while (this.table[n] != null) {
            if (object.equals(this.table[n])) {
                Object object3 = this.table[n |= this.halfTableLength];
                this.table[n] = object2;
                return object3;
            }
            n = this.nextIndex(n);
        }
        if (this.used >= this.usedLimit) {
            Object[] objectArray = this.table;
            int n2 = this.halfTableLength;
            this.table = new Object[this.table.length << 1];
            this.halfTableLength <<= 1;
            this.usedLimit = (int)((float)this.halfTableLength * 0.5f);
            int n3 = objectArray.length >> 1;
            while (n3 > 0) {
                if (objectArray[--n3] == null) continue;
                int n4 = this.firstIndex(objectArray[n3]);
                while (this.table[n4] != null) {
                    n4 = this.nextIndex(n4);
                }
                this.table[n4] = objectArray[n3];
                this.table[n4 | this.halfTableLength] = objectArray[n3 | n2];
            }
            n = this.firstIndex(object);
            while (this.table[n] != null) {
                n = this.nextIndex(n);
            }
        }
        ++this.used;
        this.table[n] = object;
        this.table[n | this.halfTableLength] = object2;
        return null;
    }

    public Object clone() {
        try {
            Hashtable hashtable = (Hashtable)super.clone();
            hashtable.table = new Object[this.table.length];
            System.arraycopy(this.table, 0, hashtable.table, 0, this.table.length);
            return hashtable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public final Enumeration keys() {
        return new Enumerator(this.table, 0);
    }

    public final Enumeration elements() {
        return new Enumerator(this.table, this.halfTableLength);
    }

    public final Object remove(Object object) {
        if (this.used > 0) {
            int n = this.firstIndex(object);
            while (this.table[n] != null) {
                if (this.table[n].equals(object)) {
                    Object object2 = this.table[n | this.halfTableLength];
                    do {
                        int n2;
                        this.table[n] = null;
                        this.table[n | this.halfTableLength] = null;
                        int n3 = n;
                        while (this.table[n = this.nextIndex(n)] != null && (n <= (n2 = this.firstIndex(this.table[n])) && n2 < n3 || n2 < n3 && n3 < n || n3 < n && n <= n2)) {
                        }
                        this.table[n3] = this.table[n];
                        this.table[n3 | this.halfTableLength] = this.table[n | this.halfTableLength];
                    } while (this.table[n] != null);
                    --this.used;
                    return object2;
                }
                n = this.nextIndex(n);
            }
        }
        return null;
    }

    public final void clear() {
        int n = this.halfTableLength;
        while (--n >= 0) {
            this.table[n] = null;
            this.table[n | this.halfTableLength] = null;
        }
        this.used = 0;
    }

    private static class Enumerator
    implements Enumeration {
        private final Object[] table;
        private final int add;
        private int i;

        Enumerator(Object[] objectArray, int n) {
            this.table = objectArray;
            this.add = n;
            if (objectArray == null) {
                this.i = -1;
            } else {
                this.i = objectArray.length >> 1;
                while (--this.i >= 0 && objectArray[this.i] == null) {
                }
            }
        }

        public boolean hasMoreElements() {
            return this.i >= 0;
        }

        public Object nextElement() {
            if (this.i < 0) {
                throw new NoSuchElementException();
            }
            Object object = this.table[this.i + this.add];
            while (--this.i >= 0 && this.table[this.i] == null) {
            }
            return object;
        }
    }
}

