/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.pdflib.FunctionType2;
import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.PDFIOException;
import com.renderx.pdflib.PDFObject;
import com.renderx.pdflib.PDFOutputStream;

public class PDFSeparateColorSpace
extends PDFObject {
    String name;
    float[] altcolor;
    String altcolorName;
    FunctionType2 function;

    PDFSeparateColorSpace(IndirectObject indirectObject, String string, float[] fArray) {
        super(indirectObject);
        this.altcolor = fArray;
        this.name = "";
        int n = 0;
        while (n < string.length()) {
            int n2 = string.charAt(n);
            if (n2 == 9 || n2 == 10 || n2 == 13 || n2 == 160) {
                n2 = 32;
            }
            if (n2 == 32) {
                this.name = this.name + "#20";
            } else if (n2 == 40 || n2 == 41 || n2 == 60 || n2 == 62 || n2 == 91 || n2 == 93 || n2 == 123 || n2 == 125 || n2 == 47 || n2 == 37) {
                this.name = this.name + "#";
                this.name = this.name + Integer.toHexString(n2);
            } else {
                this.name = this.name + (char)n2;
            }
            ++n;
        }
        if (fArray == null) {
            this.altcolorName = "DeviceGray";
            this.altcolor = new float[]{0.0f};
        }
        switch (this.altcolor.length) {
            case 1: {
                this.altcolorName = "DeviceGray";
                break;
            }
            case 3: {
                this.altcolorName = "DeviceRGB";
                break;
            }
            case 4: {
                this.altcolorName = "DeviceCMYK";
                break;
            }
            default: {
                this.altcolorName = "DeviceGray";
            }
        }
    }

    void writeBody(PDFOutputStream pDFOutputStream) {
        pDFOutputStream.println("[/Separation");
        pDFOutputStream.println("/" + this.name);
        pDFOutputStream.print("/" + this.altcolorName + " ");
        this.function = new FunctionType2(pDFOutputStream.getNextID(), this.altcolor.length, 1.0);
        pDFOutputStream.print(this.function.getID().toStringR());
        pDFOutputStream.print("]");
    }

    void writeSubObjects(PDFOutputStream pDFOutputStream) {
        this.setTransformFunction();
        this.function.write(pDFOutputStream);
    }

    public void writeHead(PDFOutputStream pDFOutputStream) throws PDFIOException {
        this.start_offset = pDFOutputStream.size();
        pDFOutputStream.println(this.obj_id + " obj");
    }

    void writeTail(PDFOutputStream pDFOutputStream) throws PDFIOException {
        pDFOutputStream.println("\nendobj");
    }

    private void setTransformFunction() {
        int n = this.function.outputDimension;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = n == 1 || n == 3 ? 1.0 : 0.0;
            dArray2[n2] = this.altcolor[n2];
            ++n2;
        }
        this.function.setC0(dArray);
        this.function.setC1(dArray2);
    }
}

