/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.fonts.CharMetrics;
import com.renderx.fonts.Encoding;
import com.renderx.fonts.FontDescriptor;
import com.renderx.fonts.Metric;
import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.PDFObject;
import com.renderx.pdflib.PDFOutputStream;
import com.renderx.util.UnicodeData;

public class CMap
extends PDFObject {
    int length;
    IndirectObject length_id;
    FontDescriptor descriptor;
    Encoding encoding;
    boolean enableSubset;

    CMap(IndirectObject indirectObject, FontDescriptor fontDescriptor, Encoding encoding, boolean bl) {
        super(indirectObject);
        this.descriptor = fontDescriptor;
        this.encoding = encoding;
        this.enableSubset = bl;
    }

    void writeBody(PDFOutputStream pDFOutputStream) {
        this.length_id = pDFOutputStream.getNextID();
        pDFOutputStream.println("/Length " + this.length_id.toStringR());
        if (pDFOutputStream.compression) {
            pDFOutputStream.println("/Filter /FlateDecode");
        }
    }

    void writeTail(PDFOutputStream pDFOutputStream) {
        pDFOutputStream.println(">>");
        pDFOutputStream.println("stream");
        int n = pDFOutputStream.size();
        pDFOutputStream.startStream();
        this.writeCMap(pDFOutputStream);
        pDFOutputStream.finishStream();
        this.length = pDFOutputStream.size() - n;
        pDFOutputStream.println("\nendstream");
        pDFOutputStream.println("endobj");
    }

    void writeSubObjects(PDFOutputStream pDFOutputStream) {
        pDFOutputStream.printLength(this.length_id, this.length);
    }

    void writeCMap(PDFOutputStream pDFOutputStream) {
        int n;
        int n2;
        pDFOutputStream.println("%!PS-Adobe-3.0 Resource-CMap\n/CIDInit /ProcSet findresource begin\n12 dict begin\nbegincmap\n/CIDSystemInfo\n<< /Registry (Adobe)\n/Ordering (UCS)\n/Supplement 0\n>> def\n/CMapName /AdHoc-UCS def\n/CMapType 2 def");
        Metric metric = this.descriptor.record.getMetric();
        int n3 = 0;
        int n4 = 0;
        int[] nArray = null;
        if (metric.isCIDFont) {
            nArray = new int[65536];
            n2 = 0;
            while (n2 < 65536) {
                nArray[n2] = 0;
                ++n2;
            }
            CharMetrics charMetrics = null;
            n = 1;
            while (n < 65536) {
                charMetrics = (CharMetrics)metric.uniTable.get((char)n);
                if (charMetrics != null && (!this.enableSubset || n <= 0 || this.descriptor.used.checkGlyph((char)n)) && nArray[charMetrics.c] == 0) {
                    nArray[charMetrics.c] = n;
                    ++n4;
                    if (n3 < charMetrics.c) {
                        n3 = charMetrics.c;
                    }
                }
                ++n;
            }
            pDFOutputStream.println("1 begincodespacerange\n<0000> <FFFF>\nendcodespacerange");
        } else {
            nArray = new int[256];
            n2 = 0;
            while (n2 < 256) {
                nArray[n2] = 0;
                ++n2;
            }
            n3 = 255;
            int n5 = 1;
            while (n5 < 65536) {
                n = this.encoding.getCode((char)n5);
                if (n != -1 && (!this.enableSubset || this.descriptor.used.checkGlyph((char)n5)) && nArray[n] == 0) {
                    nArray[n] = n5;
                    ++n4;
                }
                ++n5;
            }
            pDFOutputStream.println("1 begincodespacerange\n<00> <FF>\nendcodespacerange");
        }
        n2 = 0;
        while (n2 <= n3 && n4 > 0) {
            int n6 = n4 < 100 ? n4 : 100;
            n4 -= n6;
            pDFOutputStream.println("" + n6 + " beginbfchar");
            while (n6 > 0 && n2 <= n3) {
                if (nArray[n2] != 0) {
                    pDFOutputStream.print("<" + (metric.isCIDFont ? this.fourHexDigits(n2) : this.twoHexDigits(n2)) + "> <");
                    char[] cArray = (char[])UnicodeData.LIGATURES.get((char)nArray[n2]);
                    if (cArray != null) {
                        int n7 = 0;
                        while (n7 < cArray.length) {
                            pDFOutputStream.print(this.fourHexDigits(cArray[n7]));
                            ++n7;
                        }
                    } else {
                        pDFOutputStream.print(this.fourHexDigits(nArray[n2]));
                    }
                    pDFOutputStream.println(">");
                    --n6;
                }
                ++n2;
            }
            pDFOutputStream.println("endbfchar");
        }
        pDFOutputStream.println("endcmap\nCMapName currentdict /CMap defineresource pop\nend\nend");
    }

    String fourHexDigits(int n) {
        String string = Integer.toHexString(n);
        string = "0000".substring(0, 4 - string.length()) + string;
        return string;
    }

    String twoHexDigits(int n) {
        String string = Integer.toHexString(n);
        string = "00".substring(0, 2 - string.length()) + string;
        return string;
    }
}

