/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.graphics;

import com.renderx.graphics.Image;
import com.renderx.graphics.ImageFormatException;
import com.renderx.graphics.ObjectRecordCoordinator;
import java.io.IOException;
import java.io.OutputStream;

public abstract class BitmapImage
extends Image {
    protected final double DEFAULT_RESOLUTION = 120.0;
    protected final double MINIMUM_RESOLUTION = 1.0;
    public int pxWidth = 0;
    public int pxHeight = 0;
    public double horzResolution = 120.0;
    public double vertResolution = 120.0;
    public boolean noResolution = true;
    public static final short CM_NONE = 0;
    public static final short CM_RLE = 1;
    public static final short CM_FLATE = 2;
    public static final short CM_JPEG = 3;
    public static final short CM_CCITT3_1D = 4;
    public static final short CM_CCITT3_2D = 5;
    public static final short CM_CCITT4_2D = 6;
    public static final short CM_LZW = 7;
    public static final short CM_LZW_TIFF = 8;
    public short compressionMethod = 0;
    public static final short CS_UNDEFINED = 0;
    public static final short CS_RGB = 1;
    public static final short CS_CMYK = 2;
    public static final short CS_REVERSED_CMYK = 3;
    public static final short CS_GRAYSCALE = 4;
    public static final short CS_REVERSED_GRAYSCALE = 5;
    public static final short CS_INDEXED = 6;
    public static final short CS_HSB = 7;
    public static final short CS_ICCPROFILE = 8;
    public short colorSpace = 0;
    public static final short PREDICTOR_NONE = 0;
    public static final short PREDICTOR_TIFF = 1;
    public static final short PREDICTOR_PNG = 2;
    public short predictor = 0;
    public int bitsPerComponent = 0;
    public boolean usesBigEndian = true;
    public byte[] colorTable = null;
    public byte[] transparentColor = null;
    public boolean separatedAlphaChannel = false;
    public boolean canCopyData = false;
    public boolean canExpandData = false;

    public abstract void parse() throws IOException, ImageFormatException;

    public double getDefaultResolution() {
        return 120.0;
    }

    protected void setDimensions() {
        if (!(this.horzResolution >= 1.0)) {
            this.horzResolution = 120.0;
        }
        if (!(this.vertResolution >= 1.0)) {
            this.vertResolution = 120.0;
        }
        this.width = (double)this.pxWidth / this.horzResolution * 72.0;
        this.height = (double)this.pxHeight / this.vertResolution * 72.0;
    }

    public final void copyData(OutputStream outputStream) throws IOException, ImageFormatException {
        this.copyData(outputStream, null);
    }

    public abstract void copyData(OutputStream var1, ObjectRecordCoordinator var2) throws IOException, ImageFormatException;

    public final void expandData(OutputStream outputStream) throws IOException, ImageFormatException {
        this.expandData(outputStream, null);
    }

    public abstract void expandData(OutputStream var1, ObjectRecordCoordinator var2) throws IOException, ImageFormatException;

    public String toString() {
        return super.toString() + "," + "pxWidth=" + this.pxWidth + "," + "pxHeight=" + this.pxHeight + "," + "horzResolution=" + this.horzResolution + "," + "vertResolution=" + this.vertResolution;
    }
}

