/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.fonts;

import com.renderx.fonts.FontFileFormatError;
import com.renderx.util.Hashtable;
import com.renderx.util.LineEnumerator;
import com.renderx.util.URLSpec;
import com.renderx.util.User;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;

public final class GlyphList {
    private static final String ADOBE_GLYPH_LIST = "resource:com/renderx/fonts/agl.txt";
    public static final GlyphList dflt = new GlyphList();
    private Hashtable Name2Code = new Hashtable();
    private static boolean initialized = false;

    public static synchronized void init() {
        if (initialized) {
            return;
        }
        String string = null;
        try {
            string = User.getProperty("com.renderx.fonts.ADOBE_GLYPH_LIST");
            if (string == null) {
                string = ADOBE_GLYPH_LIST;
            }
            dflt.readGlyphList(new URLSpec(string).openStream());
        }
        catch (Exception exception) {
            throw new RuntimeException("cannot parse " + string + ": " + exception.toString());
        }
        initialized = true;
    }

    public GlyphList() {
    }

    public GlyphList(InputStream inputStream) throws IOException, FontFileFormatError {
        this();
        this.readGlyphList(inputStream);
    }

    public void readGlyphList(InputStream inputStream) throws IOException, FontFileFormatError {
        LineEnumerator lineEnumerator = new LineEnumerator(inputStream);
        int n = 0;
        while (lineEnumerator.hasMoreLines()) {
            StringTokenizer stringTokenizer;
            String string = lineEnumerator.nextLine();
            ++n;
            if (string.startsWith("#", 0) || !(stringTokenizer = new StringTokenizer(string, ";")).hasMoreTokens()) continue;
            String string2 = stringTokenizer.nextToken().trim();
            if (!stringTokenizer.hasMoreTokens()) continue;
            String string3 = stringTokenizer.nextToken().trim();
            this.registerGlyph(string3, (char)Integer.parseInt(string2, 16), n);
        }
    }

    public void readCMap(InputStream inputStream) throws IOException, FontFileFormatError {
        LineEnumerator lineEnumerator = new LineEnumerator(inputStream);
        if (!lineEnumerator.hasMoreLines()) {
            throw new FontFileFormatError("Empty file");
        }
        String string = lineEnumerator.nextLine();
        if (!string.startsWith("%!PS-Adobe-3.0")) {
            throw new FontFileFormatError("File does not appear to be a CMap");
        }
        int n = 1;
        int n2 = 0;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        while (lineEnumerator.hasMoreLines()) {
            string = lineEnumerator.nextLine();
            ++n;
            int n3 = string.indexOf(37);
            if (n3 != -1) {
                string = string.substring(0, n3);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, " <>");
            while (stringTokenizer.hasMoreTokens()) {
                String string5 = stringTokenizer.nextToken().trim();
                switch (n2) {
                    case 0: {
                        if (string5 == "begincidchar") {
                            n2 = 1;
                            string2 = null;
                            break;
                        }
                        if (string5 != "begincidrange") break;
                        n2 = 2;
                        string4 = null;
                        string3 = null;
                        break;
                    }
                    case 1: {
                        if (string5 == "endcidchar") {
                            n2 = 0;
                            break;
                        }
                        if (string2 == null) {
                            string2 = string5;
                            break;
                        }
                        char c = (char)Integer.parseInt(string2, 16);
                        this.registerGlyph(string5, c, n);
                        string2 = null;
                        break;
                    }
                    case 2: {
                        if (string5 == "endcidrange") {
                            n2 = 0;
                            break;
                        }
                        if (string3 == null) {
                            string3 = string5;
                            break;
                        }
                        if (string4 == null) {
                            string4 = string5;
                            break;
                        }
                        char c = (char)Integer.parseInt(string3, 16);
                        char c2 = (char)Integer.parseInt(string4, 16);
                        int n4 = Integer.parseInt(string5, 10);
                        while (c <= c2) {
                            int n5 = n4++;
                            char c3 = c;
                            c = (char)(c + '\u0001');
                            this.registerGlyph(Integer.toString(n5), c3, n);
                        }
                        string3 = null;
                        string4 = null;
                    }
                }
            }
        }
    }

    private void registerGlyph(String string, char c, int n) throws FontFileFormatError {
        if (c == '\u0000') {
            throw new FontFileFormatError("[Line " + n + "]: glyph '" + string + "' has an invalid Unicode number");
        }
        char[] cArray = (char[])this.Name2Code.get(string);
        char[] cArray2 = null;
        if (cArray != null) {
            cArray2 = new char[cArray.length + 1];
            int n2 = 0;
            while (n2 < cArray.length) {
                cArray2[n2 + 1] = cArray[n2];
                ++n2;
            }
        } else {
            cArray2 = new char[]{c};
        }
        this.Name2Code.put(string, cArray2);
    }

    public char[] getUserUnicode(String string) {
        Object object = this.Name2Code.get(string);
        return (char[])object;
    }

    public char[] getDfltUnicode(String string) {
        Object object = GlyphList.dflt.Name2Code.get(string);
        return (char[])object;
    }

    public char[] getUnicodes(String string) {
        char[] cArray;
        int n = string.indexOf(46);
        if (n != -1) {
            string = string.substring(0, n);
        }
        if ((cArray = this.getUserUnicode(string)) != null) {
            return cArray;
        }
        cArray = this.getDfltUnicode(string);
        if (cArray != null) {
            return cArray;
        }
        if (string.startsWith("uni")) {
            string = string.substring(3);
        } else if (string.startsWith("u")) {
            string = string.substring(1);
        } else {
            return null;
        }
        if (string.length() != 4) {
            return null;
        }
        try {
            return new char[]{(char)Integer.parseInt(string, 16)};
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        Object object2;
        if (stringArray.length == 0) {
            System.err.println("Usage: com.renderx.fonts.GlyphList [-cmap | -gl] glyph_list_file_name");
            System.exit(1);
        }
        GlyphList.init();
        System.err.println();
        System.err.println("Default Glyph list:");
        System.err.println("-------------------");
        Enumeration enumeration = GlyphList.dflt.Name2Code.keys();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            object = (char[])GlyphList.dflt.Name2Code.get(object2);
            System.err.println((String)object2 + "   0x" + Integer.toHexString(object[0]));
        }
        try {
            object2 = null;
            if (stringArray.length == 1) {
                object2 = new GlyphList(new FileInputStream(stringArray[0]));
            } else {
                object2 = new GlyphList();
                if (stringArray[0].equals("-cmap")) {
                    ((GlyphList)object2).readCMap(new FileInputStream(stringArray[1]));
                } else {
                    ((GlyphList)object2).readGlyphList(new FileInputStream(stringArray[1]));
                }
            }
            System.err.println();
            System.err.println("Instance Glyph list:");
            System.err.println("--------------------");
            enumeration = ((GlyphList)object2).Name2Code.keys();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                char[] cArray = (char[])((GlyphList)object2).Name2Code.get(object);
                System.err.println((String)object + "   0x" + Integer.toHexString(cArray[0]));
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        System.exit(0);
    }
}

