/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.afplib;

import com.renderx.afplib.AFPException;
import com.renderx.util.Base64OutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public final class Util {
    private Util() {
    }

    private static final byte[] int2Bytes(int n) {
        byte[] byArray = new byte[]{(byte)n, (byte)(n >>>= 8), (byte)(n >>>= 8), (byte)(n >>>= 8)};
        return byArray;
    }

    private static final byte[] long2Bytes(long l) {
        byte[] byArray = new byte[8];
        int n = 0;
        while (n < 8) {
            byArray[n] = (byte)(l & 0xFFL);
            n = (short)(n + 1);
            l >>>= 8;
        }
        return byArray;
    }

    private static final byte[] string2Byte(String string) {
        int n = string.length();
        byte[] byArray = new byte[n / 2];
        int n2 = 0;
        for (int i = 0; i < string.length(); i += 2) {
            byArray[n2] = Util.hex2Byte(string.charAt(i), string.charAt(i + 1));
            ++n2;
        }
        return byArray;
    }

    public static final void writeHex(ByteBuffer byteBuffer, String string) {
        byte[] byArray = Util.string2Byte(string);
        byteBuffer.put(byArray);
    }

    public static final void writeEBC(ByteBuffer byteBuffer, String string) {
        try {
            byte[] byArray = string.getBytes("Cp037");
            byteBuffer.put(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AFPException(unsupportedEncodingException);
        }
    }

    public static final void writeByte(ByteBuffer byteBuffer, int n) {
        byte by = (byte)(n & 0xFF);
        byteBuffer.put(by);
    }

    public static final void writeShort(ByteBuffer byteBuffer, int n) {
        byte[] byArray = Util.int2Bytes(n);
        byteBuffer.put(byArray[1]);
        byteBuffer.put(byArray[0]);
    }

    public static final void writeShortAbsolute(ByteBuffer byteBuffer, int n, int n2) {
        byte[] byArray = Util.int2Bytes(n2);
        byteBuffer.put(n, byArray[1]);
        byteBuffer.put(n + 1, byArray[0]);
    }

    public static final void write3Bytes(ByteBuffer byteBuffer, int n) {
        byte[] byArray = Util.int2Bytes(n);
        byteBuffer.put(byArray[2]);
        byteBuffer.put(byArray[1]);
        byteBuffer.put(byArray[0]);
    }

    public static final void writeNBytes(ByteBuffer byteBuffer, long l, int n) {
        byte[] byArray = Util.long2Bytes(l);
        if (n > 8) {
            n = 8;
        }
        for (int i = 0; i < n; ++i) {
            byteBuffer.put(byArray[n - 1 - i]);
        }
    }

    public static final byte hex2Byte(char c, char c2) {
        int n = c >= '0' && c <= '9' ? c - 48 : (c >= 'a' && c <= 'f' ? c - 97 + 10 : (c >= 'A' && c <= 'F' ? c - 65 + 10 : 0));
        n <<= 4;
        n = c2 >= '0' && c2 <= '9' ? (n += c2 - 48) : (c2 >= 'a' && c2 <= 'f' ? (n += c2 - 97 + 10) : (c2 >= 'A' && c2 <= 'F' ? (n += c2 - 65 + 10) : (n += 0)));
        return (byte)(n & 0xFF);
    }

    public static final String name8(String string) {
        return Util.nameN(string, 8, true);
    }

    public static final String nameN(String string, int n, boolean bl) {
        String string2 = string.trim();
        return string2.length() < n ? string2 + Util.repeatString(" ", n - string2.length()) : (bl ? string2.substring(0, n) : string2);
    }

    public static String repeatString(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static final String name08(String string, String string2) {
        if (string.length() > 8) {
            string = string.substring(0, 8);
        }
        string2 = "00000000" + string2.trim();
        String string3 = string2.substring(string2.length() - 8, string2.length());
        String string4 = string + string3.substring(string.length());
        return string4;
    }

    public static final int parseLength(String string) {
        if (string != null) {
            return Integer.parseInt(string.trim());
        }
        return 0;
    }

    public static final int parseLengthSpecifier(String string) throws NumberFormatException {
        double d = 1.0;
        if (string.endsWith("pt")) {
            d = 1.0;
            string = string.substring(0, string.length() - 2);
        } else if (string.endsWith("in")) {
            d = 72.0;
            string = string.substring(0, string.length() - 2);
        } else if (string.endsWith("px")) {
            d = 0.6;
            string = string.substring(0, string.length() - 2);
        } else if (string.endsWith("pc")) {
            d = 12.0;
            string = string.substring(0, string.length() - 2);
        } else if (string.endsWith("cm")) {
            d = 28.346456692913385;
            string = string.substring(0, string.length() - 2);
        } else if (string.endsWith("mm")) {
            d = 2.834645669291339;
            string = string.substring(0, string.length() - 2);
        } else {
            throw new NumberFormatException("Unknown measurement units in '" + string + "'");
        }
        return (int)Math.round(Double.valueOf(string.trim()) * d * 1000.0);
    }

    public static String parseString(String string) {
        if (string == null) {
            string = "";
        }
        string = string.trim().toLowerCase();
        return string;
    }

    public static short unsignedByteToUnsignedShort(byte by) {
        if (by >= 0) {
            return by;
        }
        return (short)(256 + (short)by);
    }

    public static String[] splitPreservingQuotes(String string) {
        return string.split(",(?!(?:[^',]|[^'],[^'])+')");
    }

    public static String[] splitKeyValuePairs(String string) {
        return string.split("[\\s=](?!(?:\"[^\"]*\"|[^=,])*)");
    }

    public static boolean parseBoolean(String string) throws IllegalArgumentException {
        boolean bl;
        String string2 = string.trim().toLowerCase();
        if ("true".equals(string2) || "yes".equals(string2) || "1".equals(string2)) {
            bl = true;
        } else if ("false".equals(string2) || "no".equals(string2) || "0".equals(string2)) {
            bl = false;
        } else {
            throw new IllegalArgumentException();
        }
        return bl;
    }

    public static class Base64 {
        public static final String base64encode(String string) throws IOException {
            return Base64.base64encode(string.getBytes());
        }

        public static final String base64encode(byte[] byArray) throws IOException {
            StringWriter stringWriter = new StringWriter();
            Base64OutputStream base64OutputStream = new Base64OutputStream(stringWriter);
            base64OutputStream.write(byArray);
            base64OutputStream.close();
            return stringWriter.toString();
        }
    }
}

