package com.renderx.xepx.x4u.ct.charsetspanel;

import java.awt.Dimension;
import java.awt.event.FocusEvent;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

import com.renderx.xepx.x4u.ct.DomToJTreeAdapter;

/**
 * @author AlexanderR
 *
 */

public class CodepageForcelatinPanel extends JPanel
{
    private static final long serialVersionUID = 3839950733117926797L;

    private CharsetsPanel parentPanel;
    
    private JLabel codepageForcelatinLabel = new JLabel();
    private JTextField codepageForcelatinTextField = new JTextField();
    private JTextField source = new JTextField();
    
    public CodepageForcelatinPanel(CharsetsPanel _charsetsPanel)
    {
	this.parentPanel = _charsetsPanel;
	
        add(codepageForcelatinLabel, null);
        add(codepageForcelatinTextField, null);
        
        codepageForcelatinTextField.setName("forcelatin");
        codepageForcelatinTextField.setText("false");      
        codepageForcelatinTextField.setPreferredSize(new Dimension(110, 15));
        codepageForcelatinTextField.setEnabled(true);
        source.setName("");
        
	codepageForcelatinLabel.setText("forcelatin");
	
	codepageForcelatinTextField.getDocument().addDocumentListener
	(
		new DocumentListener()
		{
		  public void insertUpdate(DocumentEvent e) 
		  {
		      parentPanel.textField_focusLost(source, (Element) parentPanel.getCharsetNode());
		  };
		  public void removeUpdate(DocumentEvent e) 
		  { 
		      parentPanel.textField_focusLost(source, (Element) parentPanel.getCharsetNode());
		  };
		  public void changedUpdate(DocumentEvent e) 
		  { 
		  };
		}
	);
	
        codepageForcelatinTextField.addFocusListener
        (
        	new java.awt.event.FocusAdapter()
        	{
        	    public void focusLost(FocusEvent e)
        	    {
        	    }
        
        	    public void focusGained(FocusEvent e)
        	    {
        		parentPanel.textField_focusGained(e, (Element) parentPanel.getCharsetNode());
        	    }
        });	
    }
       
    public String getText()
    {
	return codepageForcelatinTextField.getText();
    }
    
    public void setText(String text)
    {
	codepageForcelatinTextField.setText(text);
    }   
    
    public void setEnabled(boolean value)
    {
	codepageForcelatinTextField.setEnabled(value);
    }
    
    public void setTextFromNode(DomToJTreeAdapter.FontTreeNode node)
    {
	NamedNodeMap attribs = node.getBody().getAttributes();
	if (attribs.getNamedItem("forcelatin") != null)
	{
	    setText(attribs.getNamedItem("forcelatin").getNodeValue());
	    setEnabled(true);
	} else
	{
	    setText("1");
	    setEnabled(false);
	}	
	this.updateUI();
	
	Node sizeNode = node.getBody().getAttributes().getNamedItem("forcelatin");
	String sizeValue = "";
	
	if(sizeNode != null)
	    sizeValue = node.getBody().getAttributes().getNamedItem("forcelatin").getNodeValue();
	
	setText(sizeValue);
    }

    public JTextField getSource()
    {
        return source;
    }

    public void setSource(JTextField source)
    {
        this.source = source;
    }    
}
