/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.PDFObject;
import com.renderx.pdflib.PDFOutputStream;

class RichMediaSettings
extends PDFObject {
    IndirectObject conf_id = null;
    boolean transparency = false;
    String ac;
    String dc;
    int pc = -1;

    RichMediaSettings(IndirectObject indirectObject) {
        super(indirectObject);
    }

    String getType() {
        return "RichMediaSettings";
    }

    void setConfigurationID(IndirectObject indirectObject) {
        this.conf_id = indirectObject;
    }

    void setTransparency(boolean bl) {
        this.transparency = bl;
    }

    void setActivation(String string) {
        this.ac = string;
    }

    void setDeactivation(String string) {
        this.dc = string;
    }

    void setPlayCount(int n) {
        this.pc = n;
    }

    void writeBody(PDFOutputStream pDFOutputStream) {
        pDFOutputStream.print("/Activation");
        pDFOutputStream.println("<</Type /RichMediaActivation /Condition /" + this.ac + " ");
        pDFOutputStream.print("/Animation << /Type /RichMediaAnimation /Subtype /Linear /Speed 1 ");
        pDFOutputStream.println("/PlayCount " + this.pc + ">>");
        if (this.transparency) {
            pDFOutputStream.println("/Presentation <</Transparent true>> ");
        }
        if (this.conf_id != null) {
            pDFOutputStream.print("/Configuration " + this.conf_id.toStringR());
        }
        pDFOutputStream.println(">> ");
        pDFOutputStream.println("/Deactivation");
        pDFOutputStream.print("<</Type /RichMediaDeactivation /Condition /" + this.dc + ">>");
    }

    void writeSubObjects(PDFOutputStream pDFOutputStream) {
    }
}

