/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.afplib.barcodes;

import com.renderx.afplib.AFP;
import com.renderx.afplib.AFPInternalException;
import com.renderx.afplib.ConfigManager;
import com.renderx.afplib.Point2D;
import com.renderx.afplib.XBarcode;
import com.renderx.afplib.barcodes.BarcodeParams;
import java.io.IOException;
import org.xml.sax.Attributes;

public class Code_39
extends XBarcode {
    public Code_39(BarcodeParams barcodeParams, ConfigManager configManager) throws IOException {
        super(barcodeParams, configManager);
        this.standardSymbols = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-.$/+% ";
        this.encBarcode = this.encodeBarcode(this.barcode.getCode(), -1);
        this.widthToNarrowDefault = 65535;
        this.heightMultipler = 3;
    }

    protected void writeSF_BDA(AFP aFP, int n) throws IOException, AFPInternalException {
        aFP.writeModcaSF("BDA", n + this.barcode.getCode().length());
        this.flagsBda[3] = true;
        aFP.writeFlagsInByte(this.flagsBda);
        aFP.writePoint2bytes(new Point2D(0, 0));
        for (int i = 0; i < this.encBarcode.length; ++i) {
            aFP.writeByte(this.encBarcode[i]);
        }
    }

    protected byte[] encodeBarcode(String string, int n) throws IOException {
        Attributes attributes = this.params.getBarcode().attributes;
        String string2 = attributes.getValue("", "addchecksum");
        this.typeModifier = 1;
        if (string2 != null && string2.equals("true")) {
            this.typeModifier = 2;
        }
        if (string.length() > 50) {
            throw new IOException("Too meny symbols: " + string.length());
        }
        if (!this.testSymbol()) {
            throw new IOException("Wrong symbols, " + this.barcode.getCode());
        }
        return this.barcode.getCode().getBytes("Cp500");
    }
}

