/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.afplib;

import com.renderx.afplib.AFP;
import com.renderx.afplib.AFPInternalException;
import com.renderx.afplib.Point2D;
import com.renderx.afplib.XYObject;
import com.renderx.xep.pre.Attr;
import java.io.IOException;
import java.util.ArrayList;

public class XPolygon
extends XYObject {
    ArrayList points = new ArrayList();

    public XPolygon(Point2D point2D, Attr.Color color, int n) {
        super(point2D, color, n);
        this.addPoint(point2D);
    }

    public void addPoint(Point2D point2D) {
        int[] nArray = new int[]{point2D.x, point2D.y};
        this.points.add(nArray);
    }

    public ArrayList getPoints() {
        return this.points;
    }

    public String toString() {
        String string = "POLYGON: color = " + this.color.toString() + " rotation = " + String.valueOf(this.rotation) + " ";
        for (int i = 0; i < this.points.size(); ++i) {
            int[] nArray = (int[])this.points.get(i);
            if (i > 0) {
                string = string + ", ";
            }
            string = string + "(" + String.valueOf(nArray[0]) + "," + String.valueOf(nArray[0]) + ")";
        }
        return string;
    }

    public void writeToAFP(AFP aFP) throws IOException, AFPInternalException {
        int n;
        aFP.setColor(this.color);
        aFP.setOrientation(0, true);
        int n2 = 0;
        int n3 = 0;
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MAX_VALUE;
        for (n = 0; n < this.points.size(); ++n) {
            int[] nArray = (int[])this.points.get(n);
            if (nArray[0] > n2) {
                n2 = nArray[0];
            }
            if (nArray[1] > n3) {
                n3 = nArray[1];
            }
            if (nArray[0] <= n4) {
                n4 = nArray[0];
            }
            if (nArray[1] > n5) continue;
            n5 = nArray[1];
        }
        if (Math.abs(n2 - n4) < Math.abs(n3 - n5)) {
            n = n3 - n5;
            int n6 = n2 - n4;
            aFP.drawVerticalRule(new Point2D(n4, n5).toAFPCoordinates(), new Point2D(n, n6).toAFPCoordinates());
        } else {
            n = n2 - n4;
            int n7 = n3 - n5;
            aFP.drawHorizontalRule(new Point2D(n4, n5).toAFPCoordinates(), new Point2D(n, n7).toAFPCoordinates());
        }
    }
}

