/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.afplib;

import com.renderx.afplib.ConfigManager;
import com.renderx.afplib.Point2D;
import com.renderx.afplib.TIFFFaxEncoder;
import com.renderx.afplib.XGraphic;
import com.renderx.afplib.XPage;
import com.renderx.afplib.XTIFFFaxImage;
import com.renderx.util.Hashtable;
import com.renderx.xep.pre.Attr;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Enumeration;

public class XBilevelShadingPattern
extends XTIFFFaxImage {
    private static final TIFFFaxEncoder FAX_ENCODER = new TIFFFaxEncoder(false);
    private static final int MAX_RESOURCE_LENGTH = 32000;
    public static Patterns patterns = new Patterns();
    private Attr.Color color;
    private Point2D areaSize;
    private boolean isBitmapCompressed = false;
    private XPage page;
    private ConfigManager optionsManager;

    protected XBilevelShadingPattern(XGraphic xGraphic, ConfigManager configManager) {
        super(null);
        this.color = xGraphic.color;
        this.graphic = xGraphic;
        this.areaSize = xGraphic.size;
        this.page = xGraphic.getPage();
        this.logger = xGraphic.document.logger;
        this.optionsManager = configManager;
        xGraphic.mappingOption = configManager.isReplicateAndTrim() ? XGraphic.MO_REPLICATE_AND_TRIM : (configManager.getShadingPatternResolution() == 1.0 ? XGraphic.MO_CENTER_AND_TRIM : XGraphic.MO_SCALE_TO_FILL);
    }

    public void loadImage() throws MalformedURLException, IOException {
        if (this.data != null) {
            return;
        }
        Attr.Color.Grayscale grayscale = (Attr.Color.Grayscale)this.color;
        Patterns.Pattern pattern = patterns.getPattern(grayscale);
        if (this.optionsManager.isReplicateAndTrim()) {
            this.pixelSize = new Point2D(8, pattern.body.length);
            this.data = this.createRaster(pattern.body);
        } else {
            this.pixelSize = new Point2D((int)Math.floor((double)this.areaSize.x * this.optionsManager.getShadingPatternResolution() / 8.0) * 8, (int)Math.floor((double)this.areaSize.y * this.optionsManager.getShadingPatternResolution()));
            if (this.pixelSize.x == 0) {
                this.pixelSize.x = 1;
            }
            if (this.optionsManager.getShadingPatternResolution() != 1.0) {
                this.areaSize = new Point2D((int)((double)this.pixelSize.x / this.optionsManager.getShadingPatternResolution()), (int)((double)this.pixelSize.y / this.optionsManager.getShadingPatternResolution()));
            }
            this.data = this.compressRaster(this.createRaster(pattern.body), pattern.isCompressible);
        }
    }

    private byte[] compressRaster(byte[] byArray, boolean bl) {
        byte[] byArray2;
        block6: {
            if (this.optionsManager.isTryUsingTiffCompression() && bl) {
                int n = this.pixelSize.x / 8;
                byte[] byArray3 = new byte[this.pixelSize.y * n * 2];
                try {
                    int n2 = FAX_ENCODER.encodeT6(byArray, n, 0, this.pixelSize.x, this.pixelSize.y, byArray3);
                    if (n2 < byArray.length) {
                        this.isBitmapCompressed = true;
                        byArray2 = new byte[n2];
                        for (int i = 0; i < n2; ++i) {
                            byArray2[i] = byArray3[i];
                        }
                        break block6;
                    }
                    byArray2 = byArray;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    byArray2 = byArray;
                }
            } else {
                byArray2 = byArray;
            }
        }
        return byArray2;
    }

    private byte[] createRaster(byte[] byArray) {
        int n = this.pixelSize.x / 8;
        byte[] byArray2 = new byte[this.pixelSize.y * n];
        for (int i = 0; i < this.pixelSize.y; ++i) {
            for (int j = 0; j < n; ++j) {
                byArray2[n * i + j] = byArray[i % byArray.length];
            }
        }
        return byArray2;
    }

    public short getIOCAEncodingCode() {
        if (this.isBitmapCompressed) {
            return 130;
        }
        return 3;
    }

    public static class Key {
        private Attr.Color color;
        private Point2D size;

        public Key(XGraphic xGraphic) {
            this.size = xGraphic.size;
            this.color = xGraphic.color;
        }

        public boolean equals(Object object) {
            if (object instanceof Key) {
                Key key = (Key)object;
                return this.color.equals(key.color) && this.size.equals(key.size);
            }
            return false;
        }

        public int hashCode() {
            return this.color.hashCode() + this.size.x + this.size.y;
        }
    }

    public static class Patterns
    extends Hashtable {
        private static final long serialVersionUID = 1L;
        Pattern defaultPattern = null;

        public Patterns() {
            this.addNewPattern(0.0, -1L, -1L, true);
            this.addNewPattern(0.05, -129L, -9L, true);
            this.addNewPattern(0.1, -134250497L, -134250497L, false);
            this.addNewPattern(0.125, -268505090L, -268505090L, false);
            this.addNewPattern(0.2, -8912931L, -8912931L, false);
            this.addNewPattern(0.25, 0x77DD77DDL, 0x77DD77DDL, false);
            this.addNewPattern(0.3, -1151996331L, -1151996331L, false);
            this.addNewPattern(0.375, -1380602443L, -1380602443L, false);
            this.addNewPattern(0.4, 0x55AE55AAL, 0x55E555AAL, false);
            this.addNewPattern(0.5, 0x5555AAAAL, 0x5555AAAAL, false);
            this.addNewPattern(0.6, -2007686571L, -2007686571L, false);
            this.addNewPattern(0.625, -1743415275L, -1743415275L, false);
            this.addNewPattern(0.7, 0x44114411L, 0x44114411L, false);
            this.addNewPattern(0.75, 0x11004400L, 0x11004400L, false);
            this.addNewPattern(0.8, 131104L, 131104L, true);
            this.addNewPattern(0.875, -2146942972L, 0x20021001L, false);
            this.addNewPattern(0.9, 0x100000L, 65536L, true);
            this.addNewPattern(0.9375, 0x8008000L, 0x8008000L, true);
            this.addNewPattern(0.96875, 2048L, 0x800000L, true);
            this.addNewPattern(1.0, 0L, 0L, true);
            this.defaultPattern = new Pattern(287458440L, 1143083264L, false);
        }

        public void addNewPattern(double d, long l, long l2) {
            this.addNewPattern(d, l, l2, true);
        }

        public void addNewPattern(double d, long l, long l2, boolean bl) {
            this.put(Attr.Color.Grayscale.create(d), new Pattern(l, l2, bl));
        }

        public Pattern getPattern(Attr.Color.Grayscale grayscale) {
            Pattern pattern = this.findPattern(grayscale);
            if (pattern != null) {
                return pattern;
            }
            double d = 2.0;
            Enumeration enumeration = this.keys();
            while (enumeration.hasMoreElements()) {
                Attr.Color.Grayscale grayscale2 = (Attr.Color.Grayscale)enumeration.nextElement();
                double d2 = Math.abs(grayscale2.gray() - grayscale.gray());
                if (!(d2 < d)) continue;
                d = d2;
                pattern = this.findPattern(grayscale2);
            }
            return pattern != null ? pattern : this.defaultPattern;
        }

        private Pattern findPattern(Attr.Color.Grayscale grayscale) {
            return (Pattern)this.get(grayscale);
        }

        public class Pattern {
            public byte[] body;
            public boolean isCompressible;

            Pattern(long l, long l2, boolean bl) {
                byte by;
                int n;
                this.isCompressible = bl;
                byte[] byArray = new byte[8];
                for (n = 0; n < 4; ++n) {
                    byArray[3 - n] = by = (byte)(l >> n * 8);
                }
                for (n = 0; n < 4; ++n) {
                    byArray[7 - n] = by = (byte)(l2 >> n * 8);
                }
                this.body = byArray;
            }
        }
    }
}

