/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.afplib;

import com.renderx.afplib.AFP;
import com.renderx.afplib.AFPInternalException;
import com.renderx.afplib.ConfigManager;
import com.renderx.afplib.Point2D;
import com.renderx.afplib.XPage;
import com.renderx.afplib.XYObject;
import com.renderx.afplib.barcodes.BarcodeParams;
import com.renderx.afplib.barcodes.BarcodeTag;
import com.renderx.afplib.orders.ModcaOrders;
import com.renderx.graphics.vector.Barcode;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class XBarcode
extends XYObject {
    protected Barcode barcode;
    protected Point2D size;
    protected byte[] encBarcode;
    protected byte type;
    protected String nameBarcode = "Unsupported";
    protected XPage page;
    public static final Map BARCODE_TYPES = new HashMap();
    public static final String EAN_13_SIGN = "EAN-13";
    public static final String EAN_8_SIGN = "EAN-8";
    public static final String UPC_A_SIGN = "UPC-A";
    public static final String UPC_E_SIGN = "UPC-E";
    public static final String CODE_39_SIGN = "code39";
    public static final String CODE_128_SIGN = "code128";
    public static final String CODEBAR_SIGN = "codabar";
    public static final String INTERLIVED_25_SIGN = "i2of5";
    public static final String STATE_AU_SIGN = "au_post";
    public static final String RM4SCC_SIGN = "RM4SCC";
    public static final int TYPE_EAN_13_LENGHT = 13;
    public static final int TYPE_EAN_8_LENGHT = 8;
    public static final int TYPE_UPC_A_LENGHT = 12;
    public static final int TYPE_UPC_E_LENGHT = 10;
    public static final int TYPE_CODE_39_LENGHT = -1;
    public static final int TYPE_CODE_128_LENGHT = -1;
    public static final int TYPE_CODEBAR_LENGHT = -1;
    public static final int TYPE_INTERLIVED_25_LENGHT = -1;
    public static final int TYPE_STATE_AU_LENGHT = 8;
    public static final int TYPE_RM4SCC_LENGTH = -1;
    protected int heightMultipler = 4;
    protected Point2D extent = new Point2D(0, 0);
    protected int elementHeight = 256;
    protected int typeBarcode = 0;
    protected int typeModifier = 2;
    protected int color = 8;
    protected int fontID = 255;
    protected int moduleWidth = 255;
    protected int widthToNarrowDefault = 0;
    protected String standardSymbols = "0123456789";
    protected double X_AXIS_CORRECTION_RATIO = 1.3;
    public BarcodeParams params;
    public static int codeTypeLength = 0;
    private ConfigManager optionsManager;
    private ModcaOrders modcaOrders = null;
    protected boolean[] flagsBda = new boolean[]{false, false, false, false, false, false, false, false};

    public Barcode getBarcode() {
        return this.barcode;
    }

    public void setBarcode(Barcode barcode) {
        this.barcode = barcode;
    }

    public byte[] getEncBarcode() {
        return this.encBarcode;
    }

    public void setEncBarcode(byte[] byArray) {
        this.encBarcode = byArray;
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte by) {
        this.type = by;
    }

    public BarcodeTag getBarcodeTag() {
        BarcodeTag barcodeTag = new BarcodeTag(this.getBarcode().getCode(), this.getBarcode().getType());
        return barcodeTag;
    }

    public XBarcode(BarcodeParams barcodeParams, ConfigManager configManager) throws IOException {
        super(barcodeParams.getOrigin(), barcodeParams.getRotation());
        this.size = barcodeParams.getSize();
        this.barcode = barcodeParams.getBarcode();
        this.params = barcodeParams;
        String string = this.barcode.getType();
        Byte by = (Byte)BARCODE_TYPES.get(string);
        if (by == null) {
            throw new IOException("Unsupported barcode type");
        }
        this.type = by;
        this.optionsManager = configManager;
    }

    public void writeToAFP(AFP aFP) throws IOException {
        aFP.startAccumulation();
        try {
            aFP.writeModcaSF("BBC", 8);
            aFP.writeModcaSF("BOG", 8);
            this.writeSF_OBD(aFP);
            this.writeSF_OBP(aFP);
            this.writeSF_BDD(aFP, 31);
            aFP.writeModcaSF("EOG", 8);
            this.writeSF_BDA(aFP, 13);
            aFP.writeModcaSF("EBC", 8);
            aFP.stopAccumulation();
        }
        catch (AFPInternalException aFPInternalException) {
            aFP.errorHandler.warning("Exception writing barcode," + this.nameBarcode);
            aFPInternalException.printStackTrace();
            aFP.rollback();
        }
    }

    protected byte[] encodeBarcode(String string, int n) throws IOException {
        if (string.length() != n) {
            throw new IOException("WRONG BARCODE LENGTH");
        }
        if (!this.testSymbol()) {
            throw new IOException("Wrong symbols, " + this.barcode.getCode());
        }
        byte[] byArray = new byte[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            byte by = Byte.parseByte("" + string.charAt(i), 10);
            byArray[i] = (byte)(by + 240);
        }
        return byArray;
    }

    protected void writeSF_BDA(AFP aFP, int n) throws IOException, AFPInternalException {
        aFP.writeModcaSF("BDA", n + this.encBarcode.length);
        aFP.writeFlagsInByte(this.flagsBda);
        aFP.writePoint2bytes(new Point2D(0, 0));
        aFP.writeBytes(this.encBarcode, 0, this.encBarcode.length);
    }

    protected void writeSF_BDD(AFP aFP, int n) throws IOException, AFPInternalException {
        byte[] byArray = new byte[]{0, 0, this.type, 0, 0, 0, 0, 0};
        aFP.writeModcaSF("BDD", n);
        aFP.writeMeasurementUnitBytes();
        aFP.writeResolutionBytes();
        aFP.writePoint2bytes(this.extent);
        aFP.writeShort(0);
        aFP.writeByte(this.type);
        aFP.writeByte(this.typeModifier);
        aFP.writeByte(this.fontID);
        aFP.writeShort(this.color);
        aFP.writeByte(this.moduleWidth);
        aFP.writeShort(this.elementHeight);
        aFP.writeByte(this.heightMultipler);
        aFP.writeShort(this.widthToNarrowDefault);
    }

    protected void writeSF_OBD(AFP aFP) throws IOException, AFPInternalException {
        this.checkModcaOrders(aFP);
        this.size.x = (int)((double)this.size.getX() * this.X_AXIS_CORRECTION_RATIO);
        this.size.y = this.size.getY();
        int n = (int)((double)this.size.getX() * this.X_AXIS_CORRECTION_RATIO);
        int n2 = this.size.getY();
        this.rotateBarcodeCoordinates(this.size, n, n2);
        this.modcaOrders.writeSF_OBD(this.size);
    }

    private void correctOrigin() {
        if (this.rotation != 90) {
            if (this.rotation == 180) {
                this.origin.x += this.size.x;
                this.origin.y += this.size.y;
            } else if (this.rotation == 270) {
                this.origin.x += this.size.y;
            }
        }
    }

    private void checkModcaOrders(AFP aFP) {
        this.modcaOrders = new ModcaOrders(aFP, this.optionsManager.getLogger());
    }

    protected void writeSF_OBP(AFP aFP) throws IOException, AFPInternalException {
        this.checkModcaOrders(aFP);
        this.correctOrigin();
        this.modcaOrders.writeSF_OBP(this.origin, 1, this.rotation);
    }

    public void writeObjectAreaSize(Point2D point2D, AFP aFP) throws IOException, AFPInternalException {
        aFP.writeModcaTripletHeader(76, 9);
        aFP.writeByte(2);
        point2D.x = (int)((double)point2D.getX() * this.X_AXIS_CORRECTION_RATIO);
        point2D.y = point2D.getY();
        int n = (int)((double)point2D.getX() * this.X_AXIS_CORRECTION_RATIO);
        int n2 = point2D.getY();
        this.rotateBarcodeCoordinates(point2D, n, n2);
        aFP.writePoint(point2D);
    }

    private void rotateBarcodeCoordinates(Point2D point2D, int n, int n2) {
        if (this.rotation == 90 || this.rotation == 270) {
            point2D.x = n2;
            point2D.y = n;
        }
    }

    private void calcModuleWidth() {
        int n = this.size.x;
        if (this.rotation == 90 || this.rotation == 270) {
            n = this.size.y;
        }
        this.moduleWidth = n / (this.encBarcode.length + 3) * 1000 / this.optionsManager.getResolution();
    }

    protected boolean testSymbol() {
        for (int i = 0; i < this.barcode.getCode().length(); ++i) {
            if (this.standardSymbols.indexOf(this.barcode.getCode().charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }

    static {
        BARCODE_TYPES.put(EAN_13_SIGN, new Byte(9));
        BARCODE_TYPES.put(EAN_8_SIGN, new Byte(8));
        BARCODE_TYPES.put(UPC_A_SIGN, new Byte(3));
        BARCODE_TYPES.put(UPC_E_SIGN, new Byte(5));
        BARCODE_TYPES.put(CODE_39_SIGN, new Byte(1));
        BARCODE_TYPES.put(CODE_128_SIGN, new Byte(17));
        BARCODE_TYPES.put(CODEBAR_SIGN, new Byte(13));
        BARCODE_TYPES.put(INTERLIVED_25_SIGN, new Byte(12));
        BARCODE_TYPES.put(STATE_AU_SIGN, new Byte(31));
        BARCODE_TYPES.put(RM4SCC_SIGN, new Byte(26));
    }
}

