package com.renderx.xepx.x4u.ct.charsetspanel;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/**
 * @author AlexanderR
 */

public class CharsetParamsPanel extends JPanel
{
    private static final long serialVersionUID = 1642386931731255311L;

    private CharsetsPanel parentPanel;
    private Element node;
    
    private CodepageNamePanel codepageNamePanel;
    private CodepageIbmNamePanel codepageIbmNamePanel;
    private CodepageForcelatinPanel codepageForcelatinPanel;
    private CodepageDescPanel codepageDescPanel;
       
    private TitledBorder titledBorder3;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    
    public CharsetParamsPanel(CharsetsPanel _parentPanel)
    {
	this.parentPanel = _parentPanel;
	
	codepageNamePanel = new CodepageNamePanel(parentPanel);
	codepageIbmNamePanel = new CodepageIbmNamePanel(parentPanel);
	codepageForcelatinPanel = new CodepageForcelatinPanel(parentPanel);
	codepageDescPanel = new CodepageDescPanel(parentPanel);
	
	setBorder(titledBorder3);
        setLayout(gridBagLayout1);

	add(codepageNamePanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0,
		GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(
			0, 0, 0, 0), 0, 0));
	add(codepageIbmNamePanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0,
		GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(
			0, 0, 0, 0), 0, 0));
	add(codepageForcelatinPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0,
		GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(
			0, 0, 0, 0), 0, 0));
	add(codepageDescPanel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0,
		GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(
			0, 0, 0, 0), 0, 0));
    }
    
    public void fillCharsetParamsPanel(Node node)
    {
	if (node == null || node.getNodeName() != "codepage")
	    return; // for inserted nodes
	
	NamedNodeMap attribs = node.getAttributes();
	if (attribs.getNamedItem("codepage-name") != null)
	{
	    this.codepageNamePanel.setText(attribs.getNamedItem("codepage-name").getNodeValue());
	    this.codepageNamePanel.setEnabled(true);
	} else
	{
	    this.codepageNamePanel.setText("");
	}
	this.codepageNamePanel.updateUI();
	
	if (attribs.getNamedItem("ibm-name") != null)
	{
	    this.codepageIbmNamePanel.setText(attribs.getNamedItem("ibm-name").getNodeValue());
	    this.codepageIbmNamePanel.setEnabled(true);
	} else
	{
	    this.codepageIbmNamePanel.setText("");
	}
	this.codepageIbmNamePanel.updateUI();
	
	if (attribs.getNamedItem("forcelatin") != null)
	{
	    this.codepageForcelatinPanel.setText(attribs.getNamedItem("forcelatin").getNodeValue());
	    this.codepageForcelatinPanel.setEnabled(true);
	} else
	{
	    this.codepageForcelatinPanel.setText("");
	}	
	this.codepageForcelatinPanel.updateUI();
	updateUI();
	
	if (attribs.getNamedItem("desc") != null)
	{
	    this.codepageDescPanel.setText(attribs.getNamedItem("desc").getNodeValue());
	    this.codepageDescPanel.setEnabled(true);
	} else
	{
	    this.codepageDescPanel.setText("");
	}	
	this.codepageDescPanel.setEnabled(true);
	this.codepageDescPanel.updateUI();
	updateUI();	
    }    
    
    public void setDefaultValues()
    {
	this.codepageNamePanel.setText("Cp500");
	this.codepageNamePanel.setEnabled(true);
	this.codepageIbmNamePanel.setText("T1V10500");
	this.codepageIbmNamePanel.setEnabled(true);
	this.codepageForcelatinPanel.setText("true");
	this.codepageForcelatinPanel.setEnabled(true);
	this.codepageDescPanel.setText("desc");
	this.codepageDescPanel.setEnabled(true);
    }

    public CodepageNamePanel getCodepageNamePanel()
    {
        return codepageNamePanel;
    }

    public CodepageIbmNamePanel getCodepageIbmNamePanel()
    {
        return codepageIbmNamePanel;
    }
    
    public CodepageForcelatinPanel getCodepageForcelatinPanel()
    {
        return codepageForcelatinPanel;
    }

    public CodepageDescPanel getCodepageDescPanel()
    {
        return codepageDescPanel;
    }

    public Element getNode()
    {
        return node;
    }

    public void setNode(Element node)
    {
        this.node = node;
    }
    
}

