/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.svg;

import com.renderx.fonts.CharMetrics;
import com.renderx.fonts.FontCatalog;
import com.renderx.fonts.KernVector;
import com.renderx.graphics.ImageFactory;
import com.renderx.graphics.ImageFormatException;
import com.renderx.graphics.UnregisteredMIMETypeException;
import com.renderx.graphics.vector.Barcode;
import com.renderx.graphics.vector.ExternalImage;
import com.renderx.graphics.vector.FontSpec;
import com.renderx.graphics.vector.Gradient;
import com.renderx.graphics.vector.GraphicGroup;
import com.renderx.graphics.vector.GraphicObject;
import com.renderx.graphics.vector.ImageTree;
import com.renderx.graphics.vector.PaintServer;
import com.renderx.graphics.vector.PaintSpec;
import com.renderx.graphics.vector.Path;
import com.renderx.graphics.vector.Pattern;
import com.renderx.graphics.vector.RefPaintSpec;
import com.renderx.graphics.vector.Subpath;
import com.renderx.graphics.vector.Text;
import com.renderx.sax.InputSource;
import com.renderx.sax.XMLReaderFactory;
import com.renderx.svg.ParserHandler;
import com.renderx.svg.SVGAttrValue;
import com.renderx.svg.SVGElement;
import com.renderx.svg.SVGMarker;
import com.renderx.svg.SVGParseException;
import com.renderx.svg.SVGParserContext;
import com.renderx.svg.css.StyleSheet;
import com.renderx.util.DefaultErrorHandler;
import com.renderx.util.ErrorHandler;
import com.renderx.util.Hashtable;
import com.renderx.util.List;
import com.renderx.util.URLCache;
import com.renderx.util.URLSpec;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SVGParserHandler
extends ParserHandler {
    Hashtable idtable = new Hashtable();
    int skip = 0;
    public static final String WHITESPACE = " \t\n\r";
    private final ImageFactory imageFactory;
    private final ErrorHandler errHandler;
    private final FontCatalog fontCatalog;
    protected final Hashtable fontCache = new Hashtable();
    private SVGParserContext context = null;
    private StyleSheet stylesheet = null;
    StringBuffer styleText = null;
    private URLSpec baseURL = null;
    public double textOriginX = 0.0;
    public double textOriginY = 0.0;
    public double textOffsetX = 0.0;
    public double textOffsetY = 0.0;
    public int currentTextAnchor = Integer.MIN_VALUE;
    public double nextGlyphPosX = 0.0;
    public double nextGlyphPosY = 0.0;
    public List textX = null;
    public List textY = null;
    public List textDX = null;
    public List textDY = null;
    public List textRotate = null;
    public GraphicGroup textGroup = null;
    boolean drawNextBlank = false;
    CharMetrics lastMetric = null;
    Text lastTextContour = null;
    boolean textOpacityPending = false;
    boolean clipPathPending = false;
    Gradient gradient = null;
    Pattern pattern = null;
    final Hashtable clipPathTable = new Hashtable();
    final Hashtable markerTable = new Hashtable();
    final Hashtable paintServerTable = new Hashtable();

    SVGParserHandler(ImageFactory imageFactory, FontCatalog fontCatalog, ErrorHandler errorHandler, double d, double d2) {
        this.imageFactory = imageFactory;
        this.fontCatalog = fontCatalog;
        this.errHandler = errorHandler;
        this.tree = new ImageTree(d, d2);
    }

    public void setBaseURL(URLSpec uRLSpec) {
        this.baseURL = uRLSpec;
    }

    private double getLength(Attributes attributes, String string, double d) throws SVGParseException {
        String string2 = SVGParserHandler.getAttrValue(attributes, string);
        if (string2 == null) {
            throw new SVGParseException("Missing attribute " + string + " on element " + this.context.element.name);
        }
        return this.context.extractLength(string2, d);
    }

    private double getOptionalLength(Attributes attributes, String string, double d, double d2) {
        String string2 = SVGParserHandler.getAttrValue(attributes, string);
        if (string2 == null) {
            return d2;
        }
        try {
            return this.context.extractLength(string2, d);
        }
        catch (SVGParseException sVGParseException) {
            if (this.errHandler != null) {
                this.errHandler.error("Attribute ignored: " + string + "=\"" + string2 + "\"; " + sVGParseException.getMessage());
            }
            return d2;
        }
    }

    private static String getAttrValue(Attributes attributes, String string) {
        String string2 = "";
        if (string.startsWith("xml:")) {
            string2 = "http://www.w3.org/XML/1998/namespace";
            string = string.substring(4);
        } else if (string.startsWith("xlink:")) {
            string2 = "http://www.w3.org/1999/xlink";
            string = string.substring(6);
        }
        return attributes.getValue(string2, string);
    }

    private static double[] getTransformMatrix(Attributes attributes, String string, double[] dArray) throws SVGParseException {
        String string2 = SVGParserHandler.getAttrValue(attributes, string);
        if (string2 == null) {
            return dArray;
        }
        double[] dArray2 = dArray;
        SVGAttrValue.TransformList transformList = new SVGAttrValue.TransformList(string2);
        Enumeration enumeration = transformList.transforms.elements();
        while (enumeration.hasMoreElements()) {
            SVGAttrValue.TransformList.Transform transform = (SVGAttrValue.TransformList.Transform)enumeration.nextElement();
            if ("matrix".equals(transform.type)) {
                dArray2 = GraphicObject.transform(dArray2, transform.params[0], transform.params[1], transform.params[2], transform.params[3], transform.params[4], transform.params[5]);
                continue;
            }
            if ("translate".equals(transform.type)) {
                dArray2 = GraphicObject.translate(dArray2, transform.params[0], transform.params[1]);
                continue;
            }
            if ("rotate".equals(transform.type)) {
                dArray2 = GraphicObject.translate(dArray2, transform.params[1], transform.params[2]);
                dArray2 = GraphicObject.rotate(dArray2, transform.params[0]);
                dArray2 = GraphicObject.translate(dArray2, -transform.params[1], -transform.params[2]);
                continue;
            }
            if ("scale".equals(transform.type)) {
                dArray2 = GraphicObject.scale(dArray2, transform.params[0], transform.params[1]);
                continue;
            }
            if ("skewX".equals(transform.type)) {
                dArray2 = GraphicObject.skew(dArray2, transform.params[0], 0.0);
                continue;
            }
            if ("skewY".equals(transform.type)) {
                dArray2 = GraphicObject.skew(dArray2, 0.0, transform.params[0]);
                continue;
            }
            throw new SVGParseException("Internal error: incorrect transformation step " + transform.type);
        }
        return dArray2;
    }

    private void applyTransformAttribute(Attributes attributes, String string) throws SVGParseException {
        this.context.curGroup.matrix = SVGParserHandler.getTransformMatrix(attributes, string, this.context.curGroup.matrix);
    }

    private static boolean isPaintServer(PaintSpec paintSpec) {
        if (paintSpec == null) {
            return false;
        }
        return paintSpec instanceof PaintServer;
    }

    private GraphicGroup getTransformedGroup(Attributes attributes) throws SVGParseException {
        String string = SVGParserHandler.getAttrValue(attributes, "transform");
        if (string != null || this.context.opacity != 1.0 || this.context.clipPath != null || SVGParserHandler.isPaintServer(this.context.fill) || this.context.stroke != null && SVGParserHandler.isPaintServer(this.context.stroke.paint)) {
            this.pushGroup();
        }
        if (string != null) {
            this.applyTransformAttribute(attributes, "transform");
        }
        if (this.context.clipPath != null) {
            this.applyClipping();
        }
        if (SVGParserHandler.isPaintServer(this.context.fill)) {
            this.context.curGroup.fill = this.context.fill;
        }
        if (this.context.stroke != null && SVGParserHandler.isPaintServer(this.context.stroke.paint)) {
            this.context.curGroup.stroke = this.context.stroke;
        }
        this.setOpacity();
        return this.context.curGroup;
    }

    private void setOpacity() {
        if (this.context.opacity != 1.0) {
            this.context.curGroup.opacity = this.context.opacity;
        }
    }

    private void applyClipping() {
        if (this.context.clipPath == null) {
            return;
        }
        GraphicGroup graphicGroup = (GraphicGroup)this.clipPathTable.get(this.context.clipPath);
        if (graphicGroup == null) {
            if (this.errHandler != null) {
                this.errHandler.error("No 'clipPath' element found with id='" + this.context.clipPath + "'");
            }
            return;
        }
        if (graphicGroup.children.length() == 0) {
            return;
        }
        this.context.curGroup.clippath = graphicGroup;
    }

    private GraphicGroup pushGroup() {
        GraphicGroup graphicGroup = new GraphicGroup();
        if (this.context.curGroup != null) {
            this.context.curGroup.append(graphicGroup);
        }
        this.context.curGroup = graphicGroup;
        return graphicGroup;
    }

    private void setViewport(double d, double d2) {
        this.context.setViewport(d, d2);
        if (this.context.overflow == 1) {
            return;
        }
        this.context.curGroup.clipRect(0.0, 0.0, d, d2);
    }

    private void setViewbox(Attributes attributes) throws SVGParseException {
        String string = SVGParserHandler.getAttrValue(attributes, "viewBox");
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", \t\n\r");
        if (!stringTokenizer.hasMoreTokens()) {
            throw new SVGParseException("Invalid viewBox attribute: no data");
        }
        double d = new SVGAttrValue.Length((String)stringTokenizer.nextToken()).len;
        if (!stringTokenizer.hasMoreTokens()) {
            throw new SVGParseException("Invalid viewBox attribute: required 4 numbers, only 1 found");
        }
        double d2 = new SVGAttrValue.Length((String)stringTokenizer.nextToken()).len;
        if (!stringTokenizer.hasMoreTokens()) {
            throw new SVGParseException("Invalid viewBox attribute: required 4 numbers, only 2 found");
        }
        double d3 = new SVGAttrValue.Length((String)stringTokenizer.nextToken()).len;
        if (d3 == 0.0) {
            throw new SVGParseException("Invalid viewBox attribute: width is 0");
        }
        if (!stringTokenizer.hasMoreTokens()) {
            throw new SVGParseException("Invalid viewBox attribute: required 4 numbers, only 3 found");
        }
        double d4 = new SVGAttrValue.Length((String)stringTokenizer.nextToken()).len;
        if (d4 == 0.0) {
            throw new SVGParseException("Invalid viewBox attribute: height is 0");
        }
        if (stringTokenizer.hasMoreTokens()) {
            throw new SVGParseException("Invalid viewBox attribute: extra data after 4 numbers");
        }
        this.scaleToViewport(attributes, d, d2, d3, d4);
    }

    private void scaleToViewport(Attributes attributes, double d, double d2, double d3, double d4) throws SVGParseException {
        boolean bl = true;
        boolean bl2 = true;
        double d5 = 0.5;
        double d6 = 0.5;
        String string = SVGParserHandler.getAttrValue(attributes, "preserveAspectRatio");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (!stringTokenizer.hasMoreTokens()) {
                throw new SVGParseException("Invalid preserveAspectRatio attribute: no data");
            }
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("defer")) {
                if (!stringTokenizer.hasMoreTokens()) {
                    throw new SVGParseException("Invalid preserveAspectRatio attribute: 'defer' shall be followed by alignment specifier");
                }
                string2 = stringTokenizer.nextToken();
            }
            if ("none".equals(string2)) {
                bl = false;
            } else if ("xMinYMin".equals(string2)) {
                d5 = 0.0;
                d6 = 0.0;
            } else if ("xMinYMid".equals(string2)) {
                d5 = 0.0;
                d6 = 0.5;
            } else if ("xMinYMax".equals(string2)) {
                d5 = 0.0;
                d6 = 1.0;
            } else if ("xMidYMin".equals(string2)) {
                d5 = 0.5;
                d6 = 0.0;
            } else if ("xMidYMid".equals(string2)) {
                d5 = 0.5;
                d6 = 0.5;
            } else if ("xMidYMax".equals(string2)) {
                d5 = 0.5;
                d6 = 1.0;
            } else if ("xMaxYMin".equals(string2)) {
                d5 = 1.0;
                d6 = 0.0;
            } else if ("xMaxYMid".equals(string2)) {
                d5 = 1.0;
                d6 = 0.5;
            } else if ("xMaxYMax".equals(string2)) {
                d5 = 1.0;
                d6 = 1.0;
            } else {
                throw new SVGParseException("Invalid alignment value in preserveAspectRatio: " + string2);
            }
            if (stringTokenizer.hasMoreTokens()) {
                bl2 = !"slice".equals(stringTokenizer.nextToken());
            }
        }
        double d7 = this.context.viewportX / d3;
        double d8 = this.context.viewportY / d4;
        if (bl) {
            double d9 = d7 < d8 == bl2 ? d7 : d8;
            this.pushGroup().transform(d9, 0.0, 0.0, d9, -d * d9, -d2 * d9);
            this.context.curGroup.translate((this.context.viewportX / d9 - d3) * d5, (this.context.viewportY / d9 - d4) * d6);
        } else {
            this.pushGroup().transform(d7, 0.0, 0.0, d8, -d * d7, -d2 * d8);
        }
        this.context.setViewport(d3, d4);
    }

    private double getPaintServerBase(short s, String string) {
        if (s == 1) {
            return 0.6;
        }
        if (string.equals("X")) {
            return this.context.viewportX;
        }
        if (string.equals("Y")) {
            return this.context.viewportY;
        }
        return this.context.viewportXY;
    }

    private PaintSpec adjustGradient(Gradient gradient) {
        if (gradient.stoplist.length() >= 2) {
            return gradient.cc();
        }
        if (gradient.stoplist.length() == 1) {
            return ((Gradient.Stop)gradient.stoplist.car()).color;
        }
        return null;
    }

    private PaintSpec getPaintServer(RefPaintSpec refPaintSpec) {
        String string = SVGParserContext.getIdRef(refPaintSpec.refName);
        if (string != null) {
            PaintServer paintServer = (PaintServer)this.paintServerTable.get(string);
            if (paintServer == null && this.errHandler != null) {
                this.errHandler.warning("No paint server found with 'id'=" + string + "; paint server ignored");
                return null;
            }
            if (paintServer instanceof Gradient) {
                return this.adjustGradient((Gradient)paintServer);
            }
            if (paintServer instanceof Pattern) {
                return paintServer.cc();
            }
        }
        return null;
    }

    private void resolveFillStrokePaintSpec() {
        if (this.context.fill != null && this.context.fill instanceof RefPaintSpec) {
            this.context.fill = this.getPaintServer((RefPaintSpec)this.context.fill);
        }
        if (this.context.stroke != null && this.context.stroke.paint != null && this.context.stroke.paint instanceof RefPaintSpec) {
            this.context.stroke.paint = this.getPaintServer((RefPaintSpec)this.context.stroke.paint);
        }
    }

    private void adjustPaintServerMatrix(PaintServer paintServer, double d, double d2, double d3, double d4) {
        if (paintServer == null) {
            return;
        }
        if (paintServer.unit == 1) {
            if (d3 == Double.MIN_VALUE || d4 == Double.MIN_VALUE) {
                if (this.errHandler != null) {
                    this.errHandler.error("An element has a paint server with 'objectBoundingBox\" units and has no width or height; gradient ignored.");
                }
                paintServer = null;
                return;
            }
            double[] dArray = new double[]{d3 / 0.6, 0.0, 0.0, d4 / 0.6, d, d2};
            paintServer.matrix = GraphicObject.multipleMatrix(dArray, paintServer.matrix);
        }
    }

    private void applyFillStrokeBBox(double d, double d2, double d3, double d4) {
        if (SVGParserHandler.isPaintServer(this.context.fill)) {
            this.adjustPaintServerMatrix((PaintServer)this.context.fill, d, d2, d3, d4);
        }
        if (this.context.stroke != null && SVGParserHandler.isPaintServer(this.context.stroke.paint)) {
            this.adjustPaintServerMatrix((PaintServer)this.context.stroke.paint, d, d2, d3, d4);
        }
    }

    private String getPaintServerUnitValue(Attributes attributes, String string) {
        String string2 = SVGParserHandler.getAttrValue(attributes, string);
        if (string2 != null && !PaintServer.unitTable.containsKey(string2)) {
            this.errHandler.warning("Attribute " + string + " cannot have '" + string2 + "' value;" + " attribute ignored");
            return null;
        }
        return string2;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.skip > 0) {
            return;
        }
        if (this.styleText != null) {
            this.styleText.append(cArray, n, n2);
            return;
        }
        if (this.context.fonts == null || this.context.fonts.length == 0 || this.context.fonts[0] == null) {
            return;
        }
        if (this.textGroup == null) {
            return;
        }
        CharMetrics charMetrics = null;
        int n3 = 0;
        while (n3 < this.context.fonts.length && charMetrics == null) {
            charMetrics = this.context.fonts[n3].getMetric().ucm(' ');
            ++n3;
        }
        CharMetrics charMetrics2 = this.context.fonts[0].getMetric().missingGlyph;
        if (charMetrics2 == null) {
            charMetrics2 = charMetrics;
        }
        double d = this.context.fontSize * this.context.fontStretch;
        if (charMetrics != null) {
            d *= (double)charMetrics.wx / 1000.0;
        } else if (charMetrics2 != null) {
            d *= (double)charMetrics2.wx / 1000.0;
        }
        d += this.context.wordSpacing;
        double d2 = this.context.fontSize * this.context.fontStretch;
        if (charMetrics2 != null) {
            d2 *= (double)charMetrics2.wx / 1000.0;
        }
        int n4 = n;
        int n5 = n + n2;
        while (n4 < n5) {
            if (WHITESPACE.indexOf(cArray[n4]) != -1) {
                if (this.drawNextBlank) {
                    this.nextGlyphPosX += d + this.context.letterSpacing;
                }
                this.lastMetric = null;
                this.lastTextContour = null;
                ++n4;
                this.drawNextBlank = this.context.preserveSpace;
                continue;
            }
            this.drawNextBlank = true;
            int n6 = this.getFontNumber(cArray[n4]);
            double d3 = d2;
            if (n6 != -1) {
                Object object;
                CharMetrics charMetrics3 = this.context.fonts[n6].getMetric().ucm(cArray[n4]);
                double d4 = 0.0;
                if (this.lastMetric != null && this.lastMetric.kernTable != null && (object = (KernVector)this.lastMetric.kernTable.get(cArray[n4])) != null) {
                    d4 = ((KernVector)object).X;
                    this.nextGlyphPosX += this.context.fontSize * this.context.fontStretch * d4 / 1000.0;
                }
                d3 = this.context.fontSize * this.context.fontStretch * (double)charMetrics3.wx / 1000.0;
                this.lastMetric = charMetrics3;
                this.resolveFillStrokePaintSpec();
                this.applyFillStrokeBBox(0.0, 0.0, Double.MIN_VALUE, Double.MIN_VALUE);
                if (this.context.textRotate != 0.0) {
                    object = new GraphicGroup();
                    this.lastTextContour = new Text(this.context.fill, this.context.stroke, this.context.fillRule, this.context.clipRule, this.context.fillOpacity, this.context.strokeOpacity, new FontSpec(this.context.fonts[n6].familyName, this.context.fontWeight, this.context.fontStyle, this.context.fontVariant, this.context.fontSize, this.context.fontStretch), new String(cArray, n4, 1), 0.0, 0.0);
                    ((GraphicGroup)object).translate(this.nextGlyphPosX, this.nextGlyphPosY + this.context.baselineShift);
                    ((GraphicGroup)object).rotate(-this.context.textRotate);
                    ((GraphicGroup)object).append(this.lastTextContour);
                    this.textGroup.append((GraphicObject)object);
                } else if (d4 == 0.0 && this.lastTextContour != null && this.context.letterSpacing == 0.0) {
                    this.lastTextContour.value = this.lastTextContour.value + cArray[n4];
                } else {
                    this.lastTextContour = new Text(this.context.fill, this.context.stroke, this.context.fillRule, this.context.clipRule, this.context.fillOpacity, this.context.strokeOpacity, new FontSpec(this.context.fonts[n6].familyName, this.context.fontWeight, this.context.fontStyle, this.context.fontVariant, this.context.fontSize, this.context.fontStretch), new String(cArray, n4, 1), this.nextGlyphPosX, this.nextGlyphPosY + this.context.baselineShift);
                    this.textGroup.append(this.lastTextContour);
                }
            }
            this.textOffsetX = this.nextGlyphPosX + d3;
            this.textOffsetY = this.nextGlyphPosY;
            this.nextGlyphPosX = this.textOffsetX + this.context.letterSpacing;
            ++n4;
        }
    }

    private int getFontNumber(char c) {
        int n = 0;
        while (n < this.context.fonts.length) {
            if (this.context.fonts[n].getMetric().exists(c)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        block12: {
            if (this.skip > 0) {
                --this.skip;
                return;
            }
            this.lastMetric = null;
            this.lastTextContour = null;
            try {
                switch (this.context.element.id) {
                    case 2: {
                        this.clipPathPending = false;
                        break;
                    }
                    case 18: {
                        this.closeTextChunk();
                        this.nextGlyphPosX = 0.0;
                        this.textOffsetX = 0.0;
                        this.textOriginX = 0.0;
                        this.nextGlyphPosY = 0.0;
                        this.textOffsetY = 0.0;
                        this.textOriginY = 0.0;
                        this.textOpacityPending = false;
                        break;
                    }
                    case 20: {
                        this.textOpacityPending = false;
                        break;
                    }
                    case 22: {
                        String string4 = this.styleText.toString();
                        this.styleText = null;
                        this.stylesheet = new StyleSheet(string4, this.errHandler);
                        break;
                    }
                    case 8: 
                    case 14: {
                        this.gradient = null;
                        break;
                    }
                    case 13: {
                        if (this.context.curGroup.children.isEmpty() && this.pattern.parent != null) {
                            this.pattern.content = this.pattern.parent.content;
                        }
                        this.pattern = null;
                    }
                }
            }
            catch (Exception exception) {
                if (this.errHandler == null) break block12;
                this.errHandler.exception("", exception);
            }
        }
        this.context = this.context.prev;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.skip > 0) {
            ++this.skip;
            return;
        }
        this.lastMetric = null;
        this.lastTextContour = null;
        SVGElement sVGElement = SVGElement.get(string, string2);
        if (sVGElement == null) {
            this.skip = 1;
            return;
        }
        if (this.styleText != null) {
            this.skip = 1;
            return;
        }
        this.context = SVGParserContext.createContext(this.context, sVGElement, this.baseURL, this.fontCatalog, this.fontCache, this.errHandler);
        if (sVGElement.transparent) {
            return;
        }
        try {
            this.context.setProperties(attributes, this.stylesheet, this.errHandler);
            if (this.context.hidden) {
                this.context = this.context.prev;
                this.skip = 1;
                return;
            }
            if (this.tree.root == null) {
                if (sVGElement.id != 17) {
                    throw new SVGParseException("Top-level element for an SVG image must be 'svg'");
                }
                if (this.tree.width == 0.0) {
                    this.tree.width = this.getLength(attributes, "width", 0.0);
                }
                if (this.tree.height == 0.0) {
                    this.tree.height = this.getLength(attributes, "height", 0.0);
                }
                this.context.curGroup = new GraphicGroup();
                this.tree.root = this.context.curGroup;
                this.context.curGroup.transform(1.0, 0.0, 0.0, -1.0, 0.0, this.tree.height);
                this.setViewport(this.tree.width, this.tree.height);
                this.setViewbox(attributes);
                this.setOpacity();
                return;
            }
            this.resolveFillStrokePaintSpec();
            switch (sVGElement.id) {
                case 17: {
                    if (this.clipPathPending) {
                        throw new SVGParseException("SVG element 'svg' is not allowed as a descendant of 'clipPath' element");
                    }
                    double d = this.getOptionalLength(attributes, "x", this.context.viewportX, 0.0);
                    double d2 = this.getOptionalLength(attributes, "y", this.context.viewportY, 0.0);
                    double d3 = this.getOptionalLength(attributes, "width", this.context.viewportX, this.context.viewportX);
                    double d4 = this.getOptionalLength(attributes, "height", this.context.viewportY, this.context.viewportY);
                    this.pushGroup();
                    this.context.curGroup.translate(d, d2);
                    this.setViewport(d3, d4);
                    this.setViewbox(attributes);
                    this.applyClipping();
                    this.setOpacity();
                    break;
                }
                case 5: {
                    if (this.clipPathPending && this.context.clipPath != null && this.errHandler != null) {
                        this.context.clipPath = null;
                        this.errHandler.warning("'clip-path' property is not supported on SVG 'clipPath' element and its descendants.");
                    }
                    GraphicGroup graphicGroup = new GraphicGroup();
                    this.context.curGroup.append(graphicGroup);
                    this.context.curGroup = graphicGroup;
                    this.applyTransformAttribute(attributes, "transform");
                    this.applyClipping();
                    this.setOpacity();
                    break;
                }
                case 3: {
                    if (this.clipPathPending) {
                        throw new SVGParseException("SVG element 'defs' is not allowed as a descendant of 'clipPath' element");
                    }
                    GraphicGroup graphicGroup = new GraphicGroup();
                    this.context.curGroup.append(graphicGroup);
                    this.context.curGroup = graphicGroup;
                    this.setOpacity();
                    break;
                }
                case 9: {
                    Object object;
                    if (this.clipPathPending) {
                        throw new SVGParseException("SVG element 'marker' is not allowed as a descendant of 'clipPath' element");
                    }
                    String string4 = SVGParserHandler.getAttrValue(attributes, "id");
                    double d = this.getOptionalLength(attributes, "markerWidth", 0.0, 1.7999999999999998);
                    double d5 = this.getOptionalLength(attributes, "markerHeight", 0.0, 1.7999999999999998);
                    Object object2 = new GraphicGroup();
                    this.context.curGroup = object2;
                    this.setViewport(d, d5);
                    this.setViewbox(attributes);
                    this.setOpacity();
                    double d6 = this.getOptionalLength(attributes, "refX", this.context.viewportX, 0.0);
                    double d7 = this.getOptionalLength(attributes, "refY", this.context.viewportY, 0.0);
                    double d8 = this.context.curGroup.matrix[0] * d6 + this.context.curGroup.matrix[2] * d7 + this.context.curGroup.matrix[4];
                    double d9 = this.context.curGroup.matrix[1] * d6 + this.context.curGroup.matrix[3] * d7 + this.context.curGroup.matrix[5];
                    if (d8 != 0.0 || d9 != 0.0) {
                        object = new GraphicGroup();
                        ((GraphicGroup)object).translate(-d8, -d9);
                        ((GraphicGroup)object).append((GraphicObject)object2);
                        object2 = object;
                    }
                    object = SVGParserHandler.getAttrValue(attributes, "markerUnits");
                    String string5 = SVGParserHandler.getAttrValue(attributes, "orient");
                    SVGMarker sVGMarker = new SVGMarker(string4, (GraphicGroup)object2, d, d5, (String)(object == null ? "strokeWidth" : object), string5 == null ? "0" : string5);
                    this.markerTable.put(string4, sVGMarker);
                    break;
                }
                case 20: {
                    if (this.context.opacity != 1.0 && this.errHandler != null) {
                        this.errHandler.warning("Opacity is not supported on SVG 'tspan' element.");
                    }
                    if (SVGParserHandler.getAttrValue(attributes, "x") != null) {
                        this.closeTextChunk();
                        this.openTextChunk(attributes);
                        break;
                    }
                    this.startTextSpan(attributes);
                    break;
                }
                case 18: {
                    if (this.clipPathPending && this.context.clipPath != null && this.errHandler != null) {
                        this.context.clipPath = null;
                        this.errHandler.warning("'clip-path' property is not supported on SVG 'clipPath' element and its descendants.");
                    }
                    if (this.context.opacity != 1.0) {
                        this.textOpacityPending = true;
                    }
                    this.getTransformedGroup(attributes);
                    this.openTextChunk(attributes);
                    break;
                }
                case 15: {
                    if (this.clipPathPending && this.context.clipPath != null && this.errHandler != null) {
                        this.context.clipPath = null;
                        this.errHandler.warning("'clip-path' property is not supported on SVG 'clipPath' element and its descendants.");
                    }
                    double d = this.getLength(attributes, "width", this.context.viewportX);
                    double d10 = this.getLength(attributes, "height", this.context.viewportY);
                    if (d <= 0.0 || d10 <= 0.0) {
                        return;
                    }
                    double d11 = this.getOptionalLength(attributes, "x", this.context.viewportX, 0.0);
                    double d12 = this.getOptionalLength(attributes, "y", this.context.viewportY, 0.0);
                    String string6 = SVGParserHandler.getAttrValue(attributes, "rx");
                    String string7 = SVGParserHandler.getAttrValue(attributes, "ry");
                    double d13 = 0.0;
                    double d14 = 0.0;
                    if (string6 != null || string7 != null) {
                        if (string6 != null) {
                            d13 = this.context.extractLength(string6, this.context.viewportX);
                        }
                        if (string7 != null) {
                            d14 = this.context.extractLength(string7, this.context.viewportY);
                        }
                        if (string6 == null) {
                            d13 = d14;
                        }
                        if (string7 == null) {
                            d14 = d13;
                        }
                    }
                    this.applyFillStrokeBBox(d11, d12, d, d10);
                    Path path = new Path(this.context.fill, this.context.stroke, this.context.fillRule, this.context.clipRule, this.context.fillOpacity, this.context.strokeOpacity);
                    if (d13 <= 0.0 || d14 <= 0.0) {
                        path.rectangle(d11, d12, d, d10);
                    } else {
                        if (d13 * 2.0 > d) {
                            d13 = d / 2.0;
                        }
                        if (d14 * 2.0 > d10) {
                            d14 = d10 / 2.0;
                        }
                        path.moveto(d11 + d13, d12);
                        path.lineto(d11 + d - d13, d12);
                        path.quarterarcto(d11 + d, d12 + d14, true);
                        path.lineto(d11 + d, d12 + d10 - d14);
                        path.quarterarcto(d11 + d - d13, d12 + d10, false);
                        path.lineto(d11 + d13, d12 + d10);
                        path.quarterarcto(d11, d12 + d10 - d14, true);
                        path.lineto(d11, d12 + d14);
                        path.quarterarcto(d11 + d13, d12, false);
                        path.closepath();
                    }
                    this.getTransformedGroup(attributes).append(path);
                    break;
                }
                case 1: {
                    double d;
                    if (this.clipPathPending && this.context.clipPath != null && this.errHandler != null) {
                        this.context.clipPath = null;
                        this.errHandler.warning("'clip-path' property is not supported on SVG 'clipPath' element and its descendants.");
                    }
                    if ((d = this.getLength(attributes, "r", this.context.viewportXY)) <= 0.0) {
                        return;
                    }
                    double d15 = this.getOptionalLength(attributes, "cx", this.context.viewportX, 0.0);
                    double d16 = this.getOptionalLength(attributes, "cy", this.context.viewportY, 0.0);
                    this.applyFillStrokeBBox(d15 - d, d16 - d, 2.0 * d, 2.0 * d);
                    Path path = new Path(this.context.fill, this.context.stroke, this.context.fillRule, this.context.clipRule, this.context.fillOpacity, this.context.strokeOpacity);
                    path.circle(d15, d16, d);
                    this.getTransformedGroup(attributes).append(path);
                    break;
                }
                case 4: {
                    if (this.clipPathPending && this.context.clipPath != null && this.errHandler != null) {
                        this.context.clipPath = null;
                        this.errHandler.warning("'clip-path' property is not supported on SVG 'clipPath' element and its descendants.");
                    }
                    double d = this.getLength(attributes, "rx", this.context.viewportX);
                    double d17 = this.getLength(attributes, "ry", this.context.viewportY);
                    if (d <= 0.0 || d17 <= 0.0) {
                        return;
                    }
                    double d18 = this.getOptionalLength(attributes, "cx", this.context.viewportX, 0.0);
                    double d19 = this.getOptionalLength(attributes, "cy", this.context.viewportY, 0.0);
                    this.applyFillStrokeBBox(d18 - d, d19 - d17, 2.0 * d, 2.0 * d17);
                    Path path = new Path(this.context.fill, this.context.stroke, this.context.fillRule, this.context.clipRule, this.context.fillOpacity, this.context.strokeOpacity);
                    path.ellipse(d18, d19, d, d17);
                    this.getTransformedGroup(attributes).append(path);
                    break;
                }
                case 7: {
                    if (this.clipPathPending && this.context.clipPath != null && this.errHandler != null) {
                        this.context.clipPath = null;
                        this.errHandler.warning("'clip-path' property is not supported on SVG 'clipPath' element and its descendants.");
                    }
                    this.applyFillStrokeBBox(0.0, 0.0, Double.MIN_VALUE, Double.MIN_VALUE);
                    Path path = new Path(null, this.context.stroke, this.context.fillRule, this.context.clipRule, this.context.fillOpacity, this.context.strokeOpacity);
                    path.moveto(this.getOptionalLength(attributes, "x1", this.context.viewportX, 0.0), this.getOptionalLength(attributes, "y1", this.context.viewportY, 0.0));
                    path.lineto(this.getOptionalLength(attributes, "x2", this.context.viewportX, 0.0), this.getOptionalLength(attributes, "y2", this.context.viewportY, 0.0));
                    this.getTransformedGroup(attributes).append(path);
                    this.appendMarkers(path);
                    break;
                }
                case 10: {
                    if (this.clipPathPending && this.context.clipPath != null && this.errHandler != null) {
                        this.context.clipPath = null;
                        this.errHandler.warning("'clip-path' property is not supported on SVG 'clipPath' element and its descendants.");
                    }
                    this.applyFillStrokeBBox(0.0, 0.0, Double.MIN_VALUE, Double.MIN_VALUE);
                    Path path = new Path(this.context.fill, this.context.stroke, this.context.fillRule, this.context.clipRule, this.context.fillOpacity, this.context.strokeOpacity);
                    SVGAttrValue.PathData pathData = new SVGAttrValue.PathData(SVGParserHandler.getAttrValue(attributes, "d"));
                    Enumeration enumeration = pathData.chunks.elements();
                    double d = 0.0;
                    double d20 = 0.0;
                    double d21 = 0.0;
                    double d22 = 0.0;
                    while (enumeration.hasMoreElements()) {
                        SVGAttrValue.PathData.Chunk chunk = (SVGAttrValue.PathData.Chunk)enumeration.nextElement();
                        switch (chunk.command) {
                            case 'M': {
                                path.moveto(chunk.params[0], chunk.params[1]);
                                d22 = 0.0;
                                d21 = 0.0;
                                d20 = 0.0;
                                d = 0.0;
                                break;
                            }
                            case 'm': {
                                path.moveto(path.curX + chunk.params[0], path.curY + chunk.params[1]);
                                d22 = 0.0;
                                d21 = 0.0;
                                d20 = 0.0;
                                d = 0.0;
                                break;
                            }
                            case 'Z': 
                            case 'z': {
                                path.closepath();
                                d22 = 0.0;
                                d21 = 0.0;
                                d20 = 0.0;
                                d = 0.0;
                                break;
                            }
                            case 'L': {
                                path.lineto(chunk.params[0], chunk.params[1]);
                                d22 = 0.0;
                                d21 = 0.0;
                                d20 = 0.0;
                                d = 0.0;
                                break;
                            }
                            case 'l': {
                                path.lineto(path.curX + chunk.params[0], path.curY + chunk.params[1]);
                                d22 = 0.0;
                                d21 = 0.0;
                                d20 = 0.0;
                                d = 0.0;
                                break;
                            }
                            case 'V': {
                                path.lineto(path.curX, chunk.params[0]);
                                d22 = 0.0;
                                d21 = 0.0;
                                d20 = 0.0;
                                d = 0.0;
                                break;
                            }
                            case 'v': {
                                path.lineto(path.curX, path.curY + chunk.params[0]);
                                d22 = 0.0;
                                d21 = 0.0;
                                d20 = 0.0;
                                d = 0.0;
                                break;
                            }
                            case 'H': {
                                path.lineto(chunk.params[0], path.curY);
                                d22 = 0.0;
                                d21 = 0.0;
                                d20 = 0.0;
                                d = 0.0;
                                break;
                            }
                            case 'h': {
                                path.lineto(path.curX + chunk.params[0], path.curY);
                                d22 = 0.0;
                                d21 = 0.0;
                                d20 = 0.0;
                                d = 0.0;
                                break;
                            }
                            case 'C': {
                                path.curveto(chunk.params[0], chunk.params[1], chunk.params[2], chunk.params[3], chunk.params[4], chunk.params[5]);
                                d = chunk.params[4] - chunk.params[2];
                                d20 = chunk.params[5] - chunk.params[3];
                                d22 = 0.0;
                                d21 = 0.0;
                                break;
                            }
                            case 'c': {
                                path.curveto(path.curX + chunk.params[0], path.curY + chunk.params[1], path.curX + chunk.params[2], path.curY + chunk.params[3], path.curX + chunk.params[4], path.curY + chunk.params[5]);
                                d = chunk.params[4] - chunk.params[2];
                                d20 = chunk.params[5] - chunk.params[3];
                                d22 = 0.0;
                                d21 = 0.0;
                                break;
                            }
                            case 'S': {
                                path.curveto(path.curX + d, path.curY + d20, chunk.params[0], chunk.params[1], chunk.params[2], chunk.params[3]);
                                d = chunk.params[2] - chunk.params[0];
                                d20 = chunk.params[3] - chunk.params[1];
                                d22 = 0.0;
                                d21 = 0.0;
                                break;
                            }
                            case 's': {
                                path.curveto(path.curX + d, path.curY + d20, path.curX + chunk.params[0], path.curY + chunk.params[1], path.curX + chunk.params[2], path.curY + chunk.params[3]);
                                d = chunk.params[2] - chunk.params[0];
                                d20 = chunk.params[3] - chunk.params[1];
                                d22 = 0.0;
                                d21 = 0.0;
                                break;
                            }
                            case 'Q': {
                                path.quadcurveto(chunk.params[0], chunk.params[1], chunk.params[2], chunk.params[3]);
                                d21 = chunk.params[2] - chunk.params[0];
                                d22 = chunk.params[3] - chunk.params[1];
                                d20 = 0.0;
                                d = 0.0;
                                break;
                            }
                            case 'q': {
                                path.quadcurveto(path.curX + chunk.params[0], path.curY + chunk.params[1], path.curX + chunk.params[2], path.curY + chunk.params[3]);
                                d21 = chunk.params[2] - chunk.params[0];
                                d22 = chunk.params[3] - chunk.params[1];
                                d20 = 0.0;
                                d = 0.0;
                                break;
                            }
                            case 'T': {
                                path.quadcurveto(path.curX + d21, path.curY + d22, chunk.params[0], chunk.params[1]);
                                d21 = chunk.params[0] - (path.curX + d21);
                                d22 = chunk.params[1] - (path.curY + d22);
                                d20 = 0.0;
                                d = 0.0;
                                break;
                            }
                            case 't': {
                                path.quadcurveto(path.curX + d21, path.curY + d22, path.curX + chunk.params[0], path.curY + chunk.params[1]);
                                d21 = chunk.params[0] - d21;
                                d22 = chunk.params[1] - d22;
                                d20 = 0.0;
                                d = 0.0;
                                break;
                            }
                            case 'A': {
                                path.arcto(chunk.params[0], chunk.params[1], chunk.params[2], chunk.params[3] != 0.0, chunk.params[4] != 0.0, chunk.params[5], chunk.params[6]);
                                d22 = 0.0;
                                d21 = 0.0;
                                d20 = 0.0;
                                d = 0.0;
                                break;
                            }
                            case 'a': {
                                path.arcto(chunk.params[0], chunk.params[1], chunk.params[2], chunk.params[3] != 0.0, chunk.params[4] != 0.0, path.curX + chunk.params[5], path.curY + chunk.params[6]);
                                d22 = 0.0;
                                d21 = 0.0;
                                d20 = 0.0;
                                d = 0.0;
                                break;
                            }
                            default: {
                                throw new SVGParseException("Internal error: invalid command in parsed path data");
                            }
                        }
                    }
                    this.getTransformedGroup(attributes).append(path);
                    this.appendMarkers(path);
                    break;
                }
                case 11: 
                case 12: {
                    if (this.clipPathPending && this.context.clipPath != null && this.errHandler != null) {
                        this.context.clipPath = null;
                        this.errHandler.warning("'clip-path' property is not supported on SVG 'clipPath' element and its descendants.");
                    }
                    Path path = new Path(this.context.fill, this.context.stroke, this.context.fillRule, this.context.clipRule, this.context.fillOpacity, this.context.strokeOpacity);
                    String string8 = SVGParserHandler.getAttrValue(attributes, "points");
                    if (string8 == null) {
                        throw new SVGParseException("'" + sVGElement.name + "' element misses required 'points' attribute");
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(string8, ", \t\r\n");
                    boolean bl = true;
                    double d = 0.0;
                    double d23 = 0.0;
                    double d24 = Double.MIN_VALUE;
                    double d25 = Double.MIN_VALUE;
                    while (stringTokenizer.hasMoreTokens()) {
                        double d26 = this.context.extractLength(stringTokenizer.nextToken(), this.context.viewportX);
                        if (d26 < d) {
                            d = d26;
                        }
                        if (d26 > d24) {
                            d24 = d26;
                        }
                        if (!stringTokenizer.hasMoreTokens()) {
                            throw new SVGParseException("Odd number of tokens in 'points' attribute");
                        }
                        double d27 = this.context.extractLength(stringTokenizer.nextToken(), this.context.viewportY);
                        if (d27 < d23) {
                            d23 = d27;
                        }
                        if (d27 > d25) {
                            d25 = d27;
                        }
                        if (bl) {
                            path.moveto(d26, d27);
                            bl = false;
                            continue;
                        }
                        path.lineto(d26, d27);
                    }
                    this.applyFillStrokeBBox(d, d23, d24 - d, d25 - d23);
                    if (sVGElement.id == 11) {
                        path.closepath();
                    }
                    this.getTransformedGroup(attributes).append(path);
                    this.appendMarkers(path);
                    break;
                }
                case 6: {
                    if (this.clipPathPending) {
                        throw new SVGParseException("SVG element 'image' is not allowed as a descendant of 'clipPath' element");
                    }
                    String string9 = SVGParserHandler.getAttrValue(attributes, "xlink:href");
                    if (string9 == null) {
                        throw new SVGParseException("svg:image has no xlink:href attribute");
                    }
                    ExternalImage externalImage = null;
                    try {
                        externalImage = new ExternalImage(this.imageFactory.makeImage(new URLSpec(this.context.baseURL, string9)));
                    }
                    catch (IOException iOException) {
                        throw new SVGParseException(iOException.toString());
                    }
                    catch (ImageFormatException imageFormatException) {
                        throw new SVGParseException(imageFormatException.toString());
                    }
                    catch (UnregisteredMIMETypeException unregisteredMIMETypeException) {
                        throw new SVGParseException(unregisteredMIMETypeException.toString());
                    }
                    double d = this.getOptionalLength(attributes, "width", this.context.viewportX, externalImage.image.width);
                    double d28 = this.getOptionalLength(attributes, "height", this.context.viewportY, externalImage.image.height);
                    if (d <= 0.0 || d28 <= 0.0) {
                        return;
                    }
                    double d29 = this.getOptionalLength(attributes, "x", this.context.viewportX, 0.0);
                    double d30 = this.getOptionalLength(attributes, "y", this.context.viewportY, 0.0);
                    this.pushGroup();
                    String string10 = SVGParserHandler.getAttrValue(attributes, "transform");
                    if (string10 != null) {
                        this.applyTransformAttribute(attributes, "transform");
                    }
                    this.context.curGroup.translate(d29, d30);
                    this.setViewport(d, d28);
                    this.applyClipping();
                    this.setOpacity();
                    this.scaleToViewport(attributes, 0.0, 0.0, externalImage.image.width, externalImage.image.height);
                    this.context.curGroup.transform(1.0, 0.0, 0.0, -1.0, 0.0, externalImage.image.height);
                    this.context.curGroup.append(externalImage);
                    break;
                }
                case 2: {
                    String string11;
                    if (this.clipPathPending) {
                        throw new SVGParseException("SVG element 'clipPath' is not allowed as a descendant of 'clipPath' element");
                    }
                    if (this.context.clipPath != null && this.errHandler != null) {
                        this.context.clipPath = null;
                        this.errHandler.warning("'clip-path' property is not supported on SVG 'clipPath' element and its descendants.");
                    }
                    if ((string11 = SVGParserHandler.getAttrValue(attributes, "id")) == null) {
                        throw new SVGParseException("SVG element 'clipPath' should have 'id' attribute");
                    }
                    this.clipPathPending = true;
                    this.context.curGroup = new GraphicGroup();
                    this.applyTransformAttribute(attributes, "transform");
                    this.clipPathTable.put(string11, this.context.curGroup);
                    break;
                }
                case 22: {
                    if (this.clipPathPending) {
                        throw new SVGParseException("SVG element 'style' is not allowed as a descendant of 'clipPath' element");
                    }
                    if (this.stylesheet != null) {
                        throw new SVGParseException("Multiple 'style' elements in the SVG file: only the first is retained");
                    }
                    this.styleText = new StringBuffer();
                    break;
                }
                case 28: {
                    break;
                }
                case 27: {
                    Barcode barcode = new Barcode(SVGParserHandler.getAttrValue(attributes, "value"), SVGParserHandler.getAttrValue(attributes, "type"), this.context.viewportX, this.context.viewportY, attributes);
                    this.context.curGroup.append(barcode);
                    break;
                }
                case 8: {
                    String string12 = SVGParserHandler.getAttrValue(attributes, "id");
                    if (string12 == null) {
                        throw new SVGParseException("SVG element 'linearGradient' should have 'id' attribute");
                    }
                    short s = 1;
                    String string13 = this.getPaintServerUnitValue(attributes, "gradientUnits");
                    if (string13 != null) {
                        s = (Short)PaintServer.unitTable.get(string13);
                    }
                    double d = this.getPaintServerBase(s, "X");
                    double d31 = this.getPaintServerBase(s, "Y");
                    double d32 = this.getOptionalLength(attributes, "x1", d, this.context.extractLength("0%", d));
                    double d33 = this.getOptionalLength(attributes, "y1", d31, this.context.extractLength("0%", d31));
                    double d34 = this.getOptionalLength(attributes, "x2", d, this.context.extractLength("100%", d));
                    double d35 = this.getOptionalLength(attributes, "y2", d31, this.context.extractLength("0%", d31));
                    this.gradient = new Gradient.LinearGradient(d32, d33, d34, d35);
                    String string14 = SVGParserHandler.getAttrValue(attributes, "xlink:href");
                    if (string14 != null) {
                        if (this.paintServerTable.containsKey(string14 = SVGParserContext.getIdRef(string14))) {
                            PaintServer paintServer = ((PaintServer)this.paintServerTable.get(string14)).cc();
                            this.gradient = (Gradient)paintServer;
                            if (string13 == null) {
                                d = this.getPaintServerBase(this.gradient.unit, "X");
                                d31 = this.getPaintServerBase(this.gradient.unit, "Y");
                                s = this.gradient.unit;
                            }
                            if (SVGParserHandler.getAttrValue(attributes, "x1") != null) {
                                ((Gradient.LinearGradient)this.gradient).xbeg = this.getLength(attributes, "x1", d);
                            }
                            if (SVGParserHandler.getAttrValue(attributes, "y1") != null) {
                                ((Gradient.LinearGradient)this.gradient).ybeg = this.getLength(attributes, "y1", d31);
                            }
                            if (SVGParserHandler.getAttrValue(attributes, "x2") != null) {
                                ((Gradient.LinearGradient)this.gradient).xend = this.getLength(attributes, "x2", d);
                            }
                            if (SVGParserHandler.getAttrValue(attributes, "y2") != null) {
                                ((Gradient.LinearGradient)this.gradient).yend = this.getLength(attributes, "y2", d31);
                            }
                        } else if (this.errHandler != null) {
                            this.errHandler.warning("No 'linearGradient' element found with id=\"" + string14 + "\";" + " referenced linear gradient ignored.");
                        }
                    }
                    this.gradient.unit = s;
                    if (SVGParserHandler.getAttrValue(attributes, "gradientTransform") != null) {
                        this.gradient.matrix = SVGParserHandler.getTransformMatrix(attributes, "gradientTransform", new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0});
                    }
                    this.paintServerTable.put(string12, this.gradient);
                    break;
                }
                case 14: {
                    String string15 = SVGParserHandler.getAttrValue(attributes, "id");
                    if (string15 == null) {
                        throw new SVGParseException("SVG element 'radialGradient' should have 'id' attribute");
                    }
                    short s = 1;
                    String string16 = this.getPaintServerUnitValue(attributes, "gradientUnits");
                    if (string16 != null) {
                        s = (Short)PaintServer.unitTable.get(string16);
                    }
                    double d = this.getPaintServerBase(s, "X");
                    double d36 = this.getPaintServerBase(s, "Y");
                    double d37 = this.getPaintServerBase(s, "XY");
                    double d38 = this.getOptionalLength(attributes, "cx", d, this.context.extractLength("50%", d));
                    double d39 = this.getOptionalLength(attributes, "cy", d36, this.context.extractLength("50%", d36));
                    double d40 = this.getOptionalLength(attributes, "fx", d, d38);
                    double d41 = this.getOptionalLength(attributes, "fy", d36, d39);
                    double d42 = this.getOptionalLength(attributes, "r", d37, this.context.extractLength("50%", d37));
                    this.gradient = new Gradient.RadialGradient(d40, d41, 0.0, d38, d39, d42);
                    String string17 = SVGParserHandler.getAttrValue(attributes, "xlink:href");
                    if (string17 != null) {
                        if (this.paintServerTable.containsKey(string17 = SVGParserContext.getIdRef(string17))) {
                            PaintServer paintServer = ((PaintServer)this.paintServerTable.get(string17)).cc();
                            this.gradient = (Gradient)paintServer;
                            if (string16 == null) {
                                d = this.getPaintServerBase(this.gradient.unit, "X");
                                d36 = this.getPaintServerBase(this.gradient.unit, "Y");
                                d37 = this.getPaintServerBase(this.gradient.unit, "XY");
                                s = this.gradient.unit;
                            }
                            if (SVGParserHandler.getAttrValue(attributes, "fx") != null) {
                                ((Gradient.RadialGradient)this.gradient).xbeg = this.getLength(attributes, "fx", d);
                            }
                            if (SVGParserHandler.getAttrValue(attributes, "fy") != null) {
                                ((Gradient.RadialGradient)this.gradient).ybeg = this.getLength(attributes, "fy", d36);
                            }
                            if (SVGParserHandler.getAttrValue(attributes, "cx") != null) {
                                ((Gradient.RadialGradient)this.gradient).xend = this.getLength(attributes, "cx", d);
                            }
                            if (SVGParserHandler.getAttrValue(attributes, "cy") != null) {
                                ((Gradient.RadialGradient)this.gradient).yend = this.getLength(attributes, "cy", d);
                            }
                            if (SVGParserHandler.getAttrValue(attributes, "r") != null) {
                                ((Gradient.RadialGradient)this.gradient).rend = this.getLength(attributes, "r", d37);
                            }
                        } else if (this.errHandler != null) {
                            this.errHandler.warning("No 'radialGradient' element found with id=\"" + string17 + "\";" + " referenced radial gradient ignored.");
                        }
                    }
                    this.gradient.unit = s;
                    if (SVGParserHandler.getAttrValue(attributes, "gradientTransform") != null) {
                        this.gradient.matrix = SVGParserHandler.getTransformMatrix(attributes, "gradientTransform", new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0});
                    }
                    this.paintServerTable.put(string15, this.gradient);
                    break;
                }
                case 16: {
                    double d;
                    String string18 = SVGParserHandler.getAttrValue(attributes, "offset");
                    if (string18 == null) {
                        throw new SVGParseException("SVG element 'stop' should have 'offset' attribute");
                    }
                    double d43 = 0.0;
                    try {
                        d43 = Double.parseDouble(string18);
                    }
                    catch (NumberFormatException numberFormatException) {
                        SVGAttrValue.Length length = new SVGAttrValue.Length(string18);
                        if (length.base != 3) {
                            throw new SVGParseException("Attribute 'offset' should be number or percentage");
                        }
                        d43 = length.len;
                    }
                    if (d43 < 0.0) {
                        d43 = 0.0;
                    }
                    if (d43 > 1.0) {
                        d43 = 1.0;
                    }
                    if (this.gradient.stoplist.isPair() && d43 < (d = ((Gradient.Stop)this.gradient.stoplist.last()).offset)) {
                        d43 = d;
                    }
                    this.gradient.stoplist.append(new Gradient.Stop(d43, this.context.stopColor, this.context.stopOpacity));
                    if (this.context.stopOpacity == 1.0) break;
                    this.gradient.hasStopOpacity = true;
                    break;
                }
                case 13: {
                    String string19 = SVGParserHandler.getAttrValue(attributes, "id");
                    if (string19 == null) {
                        throw new SVGParseException("SVG element 'pattern' should have 'id' attribute");
                    }
                    short s = 1;
                    int n = 2;
                    String string20 = this.getPaintServerUnitValue(attributes, "patternUnits");
                    String string21 = this.getPaintServerUnitValue(attributes, "patternContentUnits");
                    if (string20 != null) {
                        s = (Short)PaintServer.unitTable.get(string20);
                    }
                    if (string21 != null) {
                        n = ((Short)PaintServer.unitTable.get(string21)).shortValue();
                    }
                    double d = this.getPaintServerBase(s, "X");
                    double d44 = this.getPaintServerBase(s, "Y");
                    double d45 = this.getPaintServerBase(s, "XY");
                    double d46 = this.getOptionalLength(attributes, "x", d, 0.0);
                    double d47 = this.getOptionalLength(attributes, "y", d44, 0.0);
                    double d48 = this.getOptionalLength(attributes, "width", d45, 0.0);
                    double d49 = this.getOptionalLength(attributes, "height", d45, 0.0);
                    this.pattern = new Pattern(d46, d47, d48, d49);
                    String string22 = SVGParserHandler.getAttrValue(attributes, "xlink:href");
                    if (string22 != null) {
                        if (this.paintServerTable.containsKey(string22 = SVGParserContext.getIdRef(string22))) {
                            this.pattern = new Pattern((Pattern)this.paintServerTable.get(string22));
                            if (string20 == null) {
                                d = this.getPaintServerBase(this.pattern.unit, "X");
                                d44 = this.getPaintServerBase(this.pattern.unit, "Y");
                                d45 = this.getPaintServerBase(this.pattern.unit, "XY");
                                s = this.pattern.unit;
                            }
                            if (SVGParserHandler.getAttrValue(attributes, "x") != null) {
                                this.pattern.x = d46 = this.getLength(attributes, "x", d);
                            }
                            if (SVGParserHandler.getAttrValue(attributes, "y") != null) {
                                this.pattern.y = d47 = this.getLength(attributes, "y", d44);
                            }
                            if (SVGParserHandler.getAttrValue(attributes, "width") != null) {
                                this.pattern.xstep = d48 = this.getLength(attributes, "width", d45);
                            }
                            if (SVGParserHandler.getAttrValue(attributes, "height") != null) {
                                this.pattern.ystep = d49 = this.getLength(attributes, "height", d45);
                            }
                        } else if (this.errHandler != null) {
                            this.errHandler.warning("No 'pattern' element found with id=\"" + string22 + "\";" + " referenced pattern ignored.");
                        }
                    }
                    this.pattern.unit = s;
                    if (SVGParserHandler.getAttrValue(attributes, "patternTransform") != null) {
                        this.pattern.matrix = SVGParserHandler.getTransformMatrix(attributes, "patternTransform", new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0});
                    }
                    this.pattern.matrix = GraphicObject.translate(this.pattern.matrix, d46, d47);
                    this.context.curGroup = this.pattern.content;
                    this.context.curGroup.clippath = null;
                    this.setViewport(this.pattern.xstep, this.pattern.ystep);
                    if (SVGParserHandler.getAttrValue(attributes, "viewBox") != null) {
                        this.setViewbox(attributes);
                    } else if (n == 1) {
                        this.scaleToViewport(attributes, 0.0, 0.0, 1.0, 1.0);
                    } else {
                        this.scaleToViewport(attributes, 0.0, 0.0, this.pattern.xstep, this.pattern.ystep);
                    }
                    this.paintServerTable.put(string19, this.pattern);
                    break;
                }
            }
        }
        catch (Exception exception) {
            if (this.errHandler != null) {
                this.errHandler.error("SVG element '" + sVGElement.name + "' ignored: " + exception.toString());
            }
            this.context = this.context.prev;
            this.skip = 1;
        }
    }

    private SVGMarker retrieveMarker(String string) {
        return string == null ? null : (SVGMarker)this.markerTable.get(string);
    }

    private void appendMarkers(Path path) {
        if (this.clipPathPending) {
            return;
        }
        SVGMarker sVGMarker = this.retrieveMarker(this.context.markerStart);
        SVGMarker sVGMarker2 = this.retrieveMarker(this.context.markerMid);
        SVGMarker sVGMarker3 = this.retrieveMarker(this.context.markerEnd);
        Enumeration enumeration = path.subs.elements();
        while (enumeration.hasMoreElements()) {
            Subpath subpath = (Subpath)enumeration.nextElement();
            if (subpath.segs.isEmpty()) continue;
            Enumeration enumeration2 = subpath.segs.elements();
            Subpath.Segment segment = (Subpath.Segment)enumeration2.nextElement();
            Subpath.Segment segment2 = (Subpath.Segment)subpath.segs.last();
            double d = subpath.startX - segment2.xend;
            double d2 = subpath.startY - segment2.yend;
            if (!subpath.closed) {
                this.drawMarker(sVGMarker, subpath.startX, subpath.startY, 0.0, 0.0, segment.startSlopeX(), segment.startSlopeY());
            } else if (subpath.startX == segment2.xend && subpath.startY == segment2.yend) {
                this.drawMarker(sVGMarker, subpath.startX, subpath.startY, segment2.endSlopeX(), segment2.endSlopeY(), segment.startSlopeX(), segment.startSlopeY());
            } else {
                this.drawMarker(sVGMarker, subpath.startX, subpath.startY, d, d2, segment.startSlopeX(), segment.startSlopeY());
            }
            Subpath.Segment segment3 = segment;
            while (enumeration2.hasMoreElements()) {
                Subpath.Segment segment4 = (Subpath.Segment)enumeration2.nextElement();
                if (segment4.startSlopeX() == 0.0 && segment4.startSlopeY() == 0.0) continue;
                if (segment4.beginsArc) {
                    this.drawMarker(sVGMarker2, segment4.xbeg, segment4.ybeg, segment3.endSlopeX(), segment3.endSlopeY(), segment4.startSlopeX(), segment4.startSlopeY());
                }
                segment3 = segment4;
            }
            if (!subpath.closed) {
                this.drawMarker(sVGMarker3, segment2.xend, segment2.yend, segment2.endSlopeX(), segment2.endSlopeY(), 0.0, 0.0);
                continue;
            }
            if (subpath.startX == segment2.xend && subpath.startY == segment2.yend) {
                this.drawMarker(sVGMarker3, segment2.xend, segment2.yend, segment2.endSlopeX(), segment2.endSlopeY(), segment.startSlopeX(), segment.startSlopeY());
                continue;
            }
            this.drawMarker(sVGMarker2, segment2.xend, segment2.yend, segment2.endSlopeX(), segment2.endSlopeY(), d, d2);
            this.drawMarker(sVGMarker3, subpath.startX, subpath.startY, d, d2, segment.startSlopeX(), segment.startSlopeY());
        }
    }

    protected void drawMarker(SVGMarker sVGMarker, double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        if (sVGMarker == null) {
            return;
        }
        if (sVGMarker.width == 0.0 || sVGMarker.height == 0.0) {
            return;
        }
        if (sVGMarker.useStrokeWidth && (this.context.stroke == null || this.context.stroke.thickness == 0.0)) {
            return;
        }
        GraphicGroup graphicGroup = this.context.curGroup;
        GraphicGroup graphicGroup2 = this.pushGroup();
        graphicGroup2.translate(d, d2);
        if (sVGMarker.autoRotate) {
            double d8;
            double d9;
            double d10;
            d7 = Math.sqrt(d3 * d3 + d4 * d4);
            double d11 = Math.sqrt(d5 * d5 + d6 * d6);
            if (d7 == 0.0) {
                d10 = d5;
                d9 = d6;
                d8 = d11;
            } else if (d11 == 0.0) {
                d10 = d3;
                d9 = d4;
                d8 = d7;
            } else {
                d10 = d3 / d7 + d5 / d11;
                d9 = d4 / d7 + d6 / d11;
                d8 = Math.sqrt(d10 * d10 + d9 * d9);
                if (d8 == 0.0) {
                    d10 = d4;
                    d9 = -d3;
                    d8 = d7;
                }
            }
            if (d8 != 0.0) {
                graphicGroup2.transform(d10 /= d8, d9 /= d8, -d9, d10, 0.0, 0.0);
            }
        } else {
            graphicGroup2.rotate(sVGMarker.orientation);
        }
        if (sVGMarker.useStrokeWidth) {
            d7 = this.context.stroke.thickness / 0.6;
            graphicGroup2.scale(d7, d7);
        }
        graphicGroup2.append(sVGMarker.body);
        this.context.curGroup = graphicGroup;
    }

    public void openTextChunk(Attributes attributes) throws SVGParseException {
        String string = this.getFirstTokenFromAttr(attributes, "x");
        if (string != null) {
            this.nextGlyphPosX = this.context.extractLength(string, this.context.viewportX);
        }
        this.startTextSpan(attributes);
        this.textGroup = new GraphicGroup();
        this.context.curGroup.append(this.textGroup);
        this.textGroup.scale(1.0, -1.0);
        this.textOriginX = this.textOffsetX = this.nextGlyphPosX;
        this.textOriginY = this.textOffsetY = this.nextGlyphPosY;
        this.currentTextAnchor = this.context.textAnchor;
        this.drawNextBlank = this.context.preserveSpace;
    }

    public void closeTextChunk() {
        switch (this.currentTextAnchor) {
            case 0: {
                break;
            }
            case 1: {
                this.textGroup.translate((this.textOriginX - this.textOffsetX) / 2.0, (this.textOriginY - this.textOffsetY) / 2.0);
                this.nextGlyphPosX = this.textOffsetX += (this.textOriginX - this.textOffsetX) / 2.0;
                this.nextGlyphPosY = this.textOffsetY += (this.textOriginY - this.textOffsetY) / 2.0;
                break;
            }
            case 2: {
                this.textGroup.translate(this.textOriginX - this.textOffsetX, this.textOriginY - this.textOffsetY);
                this.nextGlyphPosX = this.textOffsetX = this.textOriginX;
                this.nextGlyphPosY = this.textOffsetY = this.textOriginY;
                break;
            }
        }
        this.textGroup = null;
    }

    public void startTextSpan(Attributes attributes) throws SVGParseException {
        String string;
        String string2;
        String string3;
        String string4 = this.getFirstTokenFromAttr(attributes, "y");
        if (string4 != null) {
            this.nextGlyphPosY = -this.context.extractLength(string4, this.context.viewportY);
        }
        if ((string3 = this.getFirstTokenFromAttr(attributes, "dx")) != null) {
            this.nextGlyphPosX += this.context.extractLength(string3, this.context.viewportX);
        }
        if ((string2 = this.getFirstTokenFromAttr(attributes, "dy")) != null) {
            this.nextGlyphPosY -= this.context.extractLength(string2, this.context.viewportY);
        }
        if ((string = this.getFirstTokenFromAttr(attributes, "rotate")) != null) {
            this.context.textRotate = new SVGAttrValue.Angle((String)string).angle;
        }
    }

    String getFirstTokenFromAttr(Attributes attributes, String string) throws SVGParseException {
        String string2 = SVGParserHandler.getAttrValue(attributes, string);
        if (string2 == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " \n\r\t,");
        return stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
    }

    public static void main(String[] stringArray) throws Exception {
        String string = null;
        if (stringArray.length == 1) {
            string = stringArray[0] + ".ps";
            System.out.println("Dumping graphic tree to " + string);
        } else if (stringArray.length == 2) {
            string = stringArray[1];
        } else {
            System.out.println("Usage: com.renderx.svg.SVGParserHandler <input file name> [<output file name>]");
            System.exit(0);
        }
        XMLReader xMLReader = XMLReaderFactory.createXMLReader();
        DefaultErrorHandler defaultErrorHandler = new DefaultErrorHandler();
        URLCache uRLCache = new URLCache();
        FontCatalog fontCatalog = new FontCatalog(uRLCache, defaultErrorHandler);
        ImageFactory imageFactory = new ImageFactory(fontCatalog, uRLCache, defaultErrorHandler);
        SVGParserHandler sVGParserHandler = new SVGParserHandler(imageFactory, fontCatalog, defaultErrorHandler, 0.0, 0.0);
        xMLReader.setContentHandler(sVGParserHandler);
        InputSource inputSource = new InputSource(new URLSpec(stringArray[0]));
        xMLReader.parse(inputSource);
        sVGParserHandler.tree.dump(new PrintStream(new FileOutputStream(string)), "");
    }
}

