/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.sax;

import com.renderx.util.Hashtable;
import com.renderx.util.User;
import java.io.IOException;
import java.util.Locale;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributeListImpl;

public class XMLReaderAdapter
implements Parser,
ContentHandler {
    boolean namespacesUndeclared = true;
    private static final String DEFAULT_RESOLVER_CLASS_NAME = "none";
    private static final Hashtable namespaceTable = new Hashtable();
    static final String ALIEN_NAMESPACE_URI = "[alien namespace]";
    static final String ALIEN_NAMESPACE_PREFIX = "alien";
    private XMLReader parent = null;
    private DocumentHandler handler = null;

    public XMLReaderAdapter(XMLReader xMLReader) throws SAXException {
        this.parent = xMLReader;
        if (xMLReader != null) {
            xMLReader.setContentHandler(this);
            try {
                xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
                xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
            String string = User.getProperty("com.renderx.sax.entityresolver");
            if (string == null) {
                string = DEFAULT_RESOLVER_CLASS_NAME;
            }
            if (!DEFAULT_RESOLVER_CLASS_NAME.equals(string)) {
                try {
                    xMLReader.setEntityResolver((EntityResolver)Class.forName(string).newInstance());
                }
                catch (Exception exception) {
                    throw new SAXException("Cannot create entity resolver " + string + ": " + exception.toString());
                }
            }
        }
    }

    public void setDocumentHandler(DocumentHandler documentHandler) {
        this.handler = documentHandler;
    }

    public void setLocale(Locale locale) throws SAXException {
    }

    public void parse(InputSource inputSource) throws SAXException, IOException {
        this.parent.parse(inputSource);
    }

    public void parse(String string) throws SAXException, IOException {
        this.parent.parse(string);
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.parent.setDTDHandler(dTDHandler);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.parent.setEntityResolver(entityResolver);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.parent.setErrorHandler(errorHandler);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4;
        Object object;
        AttributeListImpl attributeListImpl = new AttributeListImpl();
        int n = 0;
        while (n < attributes.getLength()) {
            object = attributes.getQName(n);
            if (object == null || !((String)object).startsWith("xmlns:") && !((String)object).equals("xmlns")) {
                string4 = this.buildQualifiedName(attributes.getURI(n), attributes.getLocalName(n));
                attributeListImpl.addAttribute(string4, "CDATA", attributes.getValue(n));
            }
            ++n;
        }
        if (this.namespacesUndeclared) {
            this.namespacesUndeclared = false;
            object = namespaceTable.keys();
            while (object.hasMoreElements()) {
                string4 = (String)object.nextElement();
                String string5 = (String)namespaceTable.get(string4);
                attributeListImpl.addAttribute("xmlns:" + string5, "CDATA", string4);
            }
            attributeListImpl.addAttribute("xmlns:alien", "CDATA", ALIEN_NAMESPACE_URI);
        }
        this.handler.startElement(this.buildQualifiedName(string, string2), attributeListImpl);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.handler.endElement(this.buildQualifiedName(string, string2));
    }

    private String buildQualifiedName(String string, String string2) {
        if (string == null || string.length() == 0) {
            return string2;
        }
        if (string.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml:" + string2;
        }
        String string3 = (String)namespaceTable.get(string);
        if (string3 == null) {
            string3 = ALIEN_NAMESPACE_PREFIX;
        }
        return string3 + ":" + string2;
    }

    public void startPrefixMapping(String string, String string2) {
    }

    public void endPrefixMapping(String string) {
    }

    public void skippedEntity(String string) {
    }

    public void startDocument() throws SAXException {
        this.namespacesUndeclared = true;
        this.handler.startDocument();
    }

    public void endDocument() throws SAXException {
        this.handler.endDocument();
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.handler.characters(cArray, n, n2);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.handler.ignorableWhitespace(cArray, n, n2);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.handler.processingInstruction(string, string2);
    }

    public void setDocumentLocator(Locator locator) {
        this.handler.setDocumentLocator(locator);
    }

    static {
        namespaceTable.put("http://www.w3.org/1999/XSL/Transform", "xsl");
        namespaceTable.put("http://www.w3.org/1999/XSL/Format", "fo");
        namespaceTable.put("http://www.w3.org/2000/svg", "svg");
        namespaceTable.put("http://www.w3.org/1999/xlink", "xlink");
        namespaceTable.put("http://www.renderx.com/XSL/Extensions", "rx");
    }
}

