/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pslib;

import com.renderx.pslib.PSDocument;
import com.renderx.pslib.Strings;
import com.renderx.util.URLUtil;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PSOutputStream
extends BufferedOutputStream {
    PSDocument doc;

    PSOutputStream(PSDocument pSDocument, OutputStream outputStream) throws IOException {
        super(outputStream, 512);
        this.doc = pSDocument;
    }

    public void print(char c) throws IOException {
        if (c < '\u00ff') {
            this.write((byte)c);
        } else {
            this.write(("u" + Integer.toHexString(c)).getBytes());
        }
    }

    public void print(int n) throws IOException {
        if (n < 255) {
            this.write((byte)n);
        } else {
            this.write(("u" + Integer.toHexString(n)).getBytes());
        }
    }

    public void print(String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            this.print(string.charAt(n2));
            ++n2;
        }
    }

    public void println() throws IOException {
        this.print('\n');
    }

    public void println(String string) throws IOException {
        this.print(string);
        this.println();
    }

    public void writeHexByte(int n) throws IOException {
        this.print(this.hexByte(n));
    }

    public String hexByte(int n) {
        return "" + Integer.toHexString(n >> 4 & 0xF) + Integer.toHexString(n & 0xF);
    }

    public void writeHexArray(byte[] byArray) throws IOException {
        if (byArray == null) {
            return;
        }
        int n = 0;
        while (n < byArray.length) {
            this.print(Integer.toHexString(byArray[n] >> 4 & 0xF));
            this.print(Integer.toHexString(byArray[n] & 0xF));
            if ((n + 1) % 32 == 0) {
                this.print('\n');
            }
            ++n;
        }
    }

    public void print_annotation(String string, int n) throws IOException {
        this.print(Strings.quote_string(string, n, this.doc.UNICODE_ANNOTATIONS));
    }

    void createAction(String string, boolean bl) throws IOException {
        this.print("/Action ");
        string = string.trim();
        if (string.toLowerCase().startsWith("file:")) {
            String string2 = string.substring(5);
            if (string2.startsWith("//")) {
                string2 = string2.substring(2);
            }
            String string3 = null;
            int n = string2.lastIndexOf(35);
            if (n != -1) {
                string3 = string2.substring(n + 1).trim();
                string2 = string2.substring(0, n).trim();
            }
            if (string2.length() != 0) {
                this.println("<</Subtype /GoToR /NewWindow " + (bl ? "true" : "false"));
                if (string3 == null || string3.length() == 0) {
                    this.println("/Dest [0 /Fit]");
                } else {
                    this.print("/Dest ");
                    this.print_annotation(URLUtil.urlDecode(string3), 65535);
                    this.println();
                }
                this.print("/File ");
                this.print_annotation(URLUtil.urlDecode(string2), 65535);
                this.println(">>");
                return;
            }
        }
        this.println("<</Subtype /URI /URI ");
        this.print_annotation(string, 65535);
        this.println(">>");
    }
}

