/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pslib;

import com.renderx.fonts.CharMetrics;
import com.renderx.fonts.Encoding;
import com.renderx.fonts.FontDescriptor;
import com.renderx.fonts.Metric;
import com.renderx.pslib.CFFFont;
import com.renderx.pslib.PSOutputStream;
import com.renderx.pslib.T1Font;
import com.renderx.pslib.TTFont;
import com.renderx.util.Hashtable;
import java.io.IOException;
import java.util.Enumeration;

public class Fonts {
    private Hashtable reencodedFonts = new Hashtable();

    String getPSFontName(FontDescriptor fontDescriptor, int n) {
        String string = fontDescriptor.record.getMetric().fontName + "." + n;
        this.reencodedFonts.put(string, fontDescriptor);
        return string;
    }

    void write(PSOutputStream pSOutputStream, Hashtable hashtable) throws IOException {
        Object object;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object = (FontDescriptor)hashtable.get(enumeration.nextElement());
            if (!((FontDescriptor)object).record.embed) continue;
            if (!((FontDescriptor)object).record.getMetric().isCFF) {
                pSOutputStream.print("\n%%BeginResource: font " + ((FontDescriptor)object).record.getMetric().fontName + "\n");
            }
            switch (((FontDescriptor)object).record.datatype) {
                case 2: {
                    new TTFont((FontDescriptor)object).write(pSOutputStream);
                    break;
                }
                case 1: {
                    new T1Font((FontDescriptor)object).write(pSOutputStream);
                    break;
                }
                case 3: 
                case 4: {
                    if (pSOutputStream.doc.LANGUAGE_LEVEL >= 3) {
                        new CFFFont((FontDescriptor)object).write(pSOutputStream);
                        break;
                    }
                    pSOutputStream.doc.errorHandler.error("CFF font embedding is a feature of Postscript Level 3; font " + ((FontDescriptor)object).record.getMetric().fontName + " not embed");
                    break;
                }
                default: {
                    pSOutputStream.doc.errorHandler.error("Unsupported font type in PSDocument.setfont() for font " + ((FontDescriptor)object).record.getMetric().fontName);
                }
            }
            if (((FontDescriptor)object).record.getMetric().isCFF) continue;
            pSOutputStream.print("\n%%EndResource\n");
        }
        enumeration = this.reencodedFonts.keys();
        while (enumeration.hasMoreElements()) {
            int n;
            object = (String)enumeration.nextElement();
            int n2 = new Integer(((String)object).substring(((String)object).lastIndexOf(".") + 1));
            FontDescriptor fontDescriptor = (FontDescriptor)this.reencodedFonts.get(object);
            Encoding encoding = (Encoding)fontDescriptor.encodingTable.get(n2);
            pSOutputStream.print("/" + (String)object + ".enc [ ");
            Encoding encoding2 = null;
            if (!fontDescriptor.record.subset && n2 == 0) {
                encoding2 = encoding;
            } else {
                encoding2 = new Encoding();
                n = 0;
                Metric metric = fontDescriptor.record.getMetric();
                int n3 = 0;
                while (n3 < 256) {
                    char c = encoding.byte2uni[n3];
                    if (c != '\u0000' && fontDescriptor.used.checkGlyph(c)) {
                        encoding2.uni2byte.put(c, new Integer(n3));
                        encoding2.table[n3] = metric.ucm(c);
                        encoding2.byte2uni[n3] = c;
                        n = 1;
                    }
                    ++n3;
                }
                if (n == 0) {
                    CharMetrics charMetrics = metric.ucm(' ');
                    if (charMetrics != null || (charMetrics = metric.missingGlyph) == null) {
                        // empty if block
                    }
                    encoding2.assignCode(' ', charMetrics);
                }
            }
            n = encoding2.getLastCode();
            int n4 = 0;
            while (n4 <= n) {
                if (n4 % 8 == 7) {
                    pSOutputStream.println();
                } else {
                    pSOutputStream.print(" ");
                }
                if (encoding2.table[n4] == null) {
                    pSOutputStream.print("/.notdef");
                } else {
                    pSOutputStream.print("/" + encoding2.table[n4].n);
                }
                ++n4;
            }
            pSOutputStream.println("] def");
            pSOutputStream.println("/" + (String)object + " /" + fontDescriptor.record.getMetric().fontName + " " + (String)object + ".enc REENCODEFONT");
        }
    }
}

