/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib.parser;

import com.renderx.graphics.vector.GraphicObject;
import com.renderx.pdflib.PDFOutputStream;
import com.renderx.pdflib.parser.PDFArray;
import com.renderx.pdflib.parser.PDFElement;
import com.renderx.pdflib.parser.PDFInstance;
import com.renderx.util.List;
import java.io.IOException;

public class Rectangle
extends PDFElement {
    public double x1;
    public double y1;
    public double x2;
    public double y2;
    private double[] matrix = new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0};

    public Rectangle(double d, double d2, double d3, double d4) {
        this.x1 = d;
        this.y1 = d2;
        this.x2 = d3;
        this.y2 = d4;
    }

    public Rectangle(PDFArray pDFArray) {
        this.x1 = new Double(((PDFElement)pDFArray.array.get(0)).toString());
        this.y1 = new Double(((PDFElement)pDFArray.array.get(1)).toString());
        this.x2 = new Double(((PDFElement)pDFArray.array.get(2)).toString());
        this.y2 = new Double(((PDFElement)pDFArray.array.get(3)).toString());
    }

    void write(PDFOutputStream pDFOutputStream, PDFInstance pDFInstance) throws IOException {
        double[] dArray = GraphicObject.transformPoint(this.matrix, this.x1, this.y1);
        double[] dArray2 = GraphicObject.transformPoint(this.matrix, this.x2, this.y2);
        pDFOutputStream.write(91);
        pDFOutputStream.print(PDFOutputStream.pdf_float(dArray[0]));
        pDFOutputStream.write(32);
        pDFOutputStream.print(PDFOutputStream.pdf_float(dArray[1]));
        pDFOutputStream.write(32);
        pDFOutputStream.print(PDFOutputStream.pdf_float(dArray2[0]));
        pDFOutputStream.write(32);
        pDFOutputStream.print(PDFOutputStream.pdf_float(dArray2[1]));
        pDFOutputStream.write(93);
    }

    List getIndirectObjects() {
        return new List();
    }

    public String toString() {
        return "" + this.x1 + " " + this.y1 + " " + this.x2 + " " + this.y2;
    }

    public double getWidth() {
        return this.x2 - this.x1;
    }

    public double getHeight() {
        return this.y2 - this.y1;
    }

    public void setMatrix(double[] dArray) {
        this.matrix = dArray;
    }
}

