/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.PDFObject;
import com.renderx.pdflib.PDFOutputStream;
import com.renderx.pdflib.Page;
import com.renderx.util.Hashtable;

public class Pages
extends PDFObject {
    int pagesCount;
    Hashtable pages;
    Pages[] kids = null;
    IndirectObject parent_id = null;
    int start = -1;
    int end = -1;
    public static final int NODESIZE = 10;

    String getType() {
        return "Pages";
    }

    Pages(IndirectObject indirectObject) {
        super(indirectObject);
        this.pagesCount = -1;
        this.pages = new Hashtable();
    }

    Pages(IndirectObject indirectObject, IndirectObject indirectObject2, Hashtable hashtable, int n, int n2) {
        super(indirectObject);
        this.pagesCount = n2 - n;
        this.pages = hashtable;
        this.parent_id = indirectObject2;
        this.start = n;
        this.end = n2;
    }

    int getPagesCount() {
        return this.pagesCount;
    }

    void addPage(Page page) {
        ++this.pagesCount;
        this.pages.put(new Integer(this.pagesCount), page);
    }

    void writeBody(PDFOutputStream pDFOutputStream) {
        pDFOutputStream.println("/Count " + (this.pagesCount + 1));
        if (this.parent_id != null) {
            pDFOutputStream.println("/Parent " + this.parent_id.toStringR());
        }
        this.kids = this.start == -1 ? this.enumerateKids(pDFOutputStream, 0, this.pages.size() - 1) : this.enumerateKids(pDFOutputStream, this.start, this.end);
    }

    void writeSubObjects(PDFOutputStream pDFOutputStream) {
        int n;
        if (this.kids != null) {
            n = 0;
            while (n < this.kids.length) {
                this.kids[n].write(pDFOutputStream);
                ++n;
            }
            this.kids = null;
        }
        if (this.start == -1) {
            n = 0;
            while (n < this.pages.size()) {
                ((Page)this.pages.get(new Integer(n))).write(pDFOutputStream);
                ++n;
            }
            this.pages = null;
        }
    }

    private Pages[] enumerateKids(PDFOutputStream pDFOutputStream, int n, int n2) {
        if (n2 - n < 10) {
            pDFOutputStream.print("/Kids [");
            int n3 = n;
            while (n3 <= n2) {
                Page page = (Page)this.pages.get(new Integer(n3));
                pDFOutputStream.print(page.getID().toStringR() + " ");
                page.parent_id = this.getID();
                this.pages.put(new Integer(n3), page);
                ++n3;
            }
            pDFOutputStream.println("]");
            return null;
        }
        int n4 = 10;
        int n5 = (n2 - n + 10) / 10;
        while (n5 > 10) {
            n4 *= 10;
            n5 = (n5 + 10 - 1) / 10;
        }
        pDFOutputStream.print("/Kids [");
        Pages[] pagesArray = new Pages[n5];
        int n6 = 0;
        while (n6 < n5) {
            int n7 = n + n4 - 1;
            if (n7 > n2) {
                n7 = n2;
            }
            pagesArray[n6] = new Pages(pDFOutputStream.getNextID(), this.getID(), this.pages, n, n7);
            n += n4;
            pDFOutputStream.print(" " + pagesArray[n6].getID().toStringR());
            ++n6;
        }
        pDFOutputStream.println("]");
        return pagesArray;
    }
}

